/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.TableCell;
import java.util.Calendar;
import java.util.Date;

public class DateValue
implements CellValue {
    private final Date value;

    public static DateValue from(Object o) throws FastOdsException {
        if (o instanceof Date) {
            return new DateValue((Date)o);
        }
        if (o instanceof Calendar) {
            return new DateValue(((Calendar)o).getTime());
        }
        if (o instanceof Number) {
            return new DateValue(new Date(((Number)o).longValue()));
        }
        if (o instanceof DateValue) {
            return (DateValue)o;
        }
        throw new FastOdsException("Can't cast " + o + " to Date");
    }

    public DateValue(Date value) {
        this.value = new Date(value.getTime());
    }

    @Override
    public void setToCell(TableCell cell) {
        cell.setDateValue(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateValue)) {
            return false;
        }
        DateValue other = (DateValue)o;
        return this.value.equals(other.value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "DateValue[" + this.value + "]";
    }
}

