/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.TableCell;

public class CurrencyValue
implements CellValue {
    private final Number value;
    private final String currency;

    public static CurrencyValue from(Object o, String currency) throws FastOdsException {
        if (o instanceof Number) {
            return new CurrencyValue((Number)o, currency);
        }
        if (o instanceof CurrencyValue) {
            CurrencyValue currencyValue = (CurrencyValue)o;
            return new CurrencyValue(currencyValue.value, currency);
        }
        throw new FastOdsException("Can't cast " + o + " to Currency");
    }

    public CurrencyValue(Number value, String currency) {
        this.value = value;
        this.currency = currency;
    }

    @Override
    public void setToCell(TableCell tableCell) {
        tableCell.setCurrencyValue(this.value, this.currency);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CurrencyValue)) {
            return false;
        }
        CurrencyValue other = (CurrencyValue)o;
        return this.value.equals(other.value) && this.currency.equals(other.currency);
    }

    public final int hashCode() {
        return this.value.hashCode() * 31 + this.currency.hashCode();
    }
}

