/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import com.epam.parso.Column;
import com.epam.parso.SasFileProperties;
import com.epam.parso.impl.SasFileReaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import smile.data.DataFrame;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.vector.BaseVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.Vector;
import smile.io.Input;

public interface SAS {
    public static DataFrame read(Path path) throws IOException {
        return SAS.read(Files.newInputStream(path, new OpenOption[0]), Integer.MAX_VALUE);
    }

    public static DataFrame read(String path) throws IOException, URISyntaxException {
        return SAS.read(Input.stream(path), Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataFrame read(InputStream input, int limit) throws IOException {
        try {
            SasFileReaderImpl reader = new SasFileReaderImpl(input);
            SasFileProperties properties = reader.getSasFileProperties();
            List columns = reader.getColumns();
            int nrows = (int)properties.getRowCount();
            int ncols = (int)properties.getColumnsCount();
            Object[][] rows = new Object[Math.min(nrows, limit)][];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = reader.readNext();
            }
            BaseVector[] vectors = new BaseVector[ncols];
            for (int j = 0; j < ncols; ++j) {
                int i;
                Object[] vector;
                Column column = (Column)columns.get(j);
                if (column.getType() == String.class) {
                    vector = new String[nrows];
                    for (i = 0; i < rows.length; ++i) {
                        vector[i] = (String)rows[i][j];
                    }
                    vectors[j] = Vector.of((String)column.getName(), (DataType)DataTypes.StringType, (Object[])vector);
                    continue;
                }
                vector = new double[nrows];
                for (i = 0; i < rows.length; ++i) {
                    vector[i] = ((Number)rows[i][j]).doubleValue();
                }
                vectors[j] = DoubleVector.of((String)column.getName(), (double[])vector);
            }
            DataFrame dataFrame = DataFrame.of((BaseVector[])vectors);
            return dataFrame;
        }
        finally {
            input.close();
        }
    }
}

