/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.io.HadoopInput;
import smile.io.LocalInputFile;

public class Parquet {
    private static final Logger logger = LoggerFactory.getLogger(Parquet.class);

    private Parquet() {
    }

    public static DataFrame read(Path path) throws IOException {
        return Parquet.read(path, Integer.MAX_VALUE);
    }

    public static DataFrame read(Path path, int limit) throws IOException {
        return Parquet.read(new LocalInputFile(path), limit);
    }

    public static DataFrame read(String path) throws IOException, URISyntaxException {
        return Parquet.read(path, Integer.MAX_VALUE);
    }

    public static DataFrame read(String path, int limit) throws IOException, URISyntaxException {
        return Parquet.read(HadoopInput.file(path), limit);
    }

    public static DataFrame read(InputFile file) throws IOException {
        return Parquet.read(file, Integer.MAX_VALUE);
    }

    public static DataFrame read(InputFile file, int limit) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)file);){
            PageReadStore store;
            ParquetMetadata footer = reader.getFooter();
            MessageType schema = footer.getFileMetaData().getSchema();
            StructType struct = Parquet.toSmileSchema(schema);
            logger.debug("The meta data of parquet file {}: {}", (Object)file.toString(), (Object)ParquetMetadata.toPrettyJSON((ParquetMetadata)footer));
            int nrows = (int)Math.min(reader.getRecordCount(), (long)limit);
            ArrayList<Tuple> rows = new ArrayList<Tuple>(nrows);
            while ((store = reader.readNextRowGroup()) != null) {
                long rowCount = store.getRowCount();
                MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
                RecordReader recordReader = columnIO.getRecordReader(store, (RecordMaterializer)new GroupRecordConverter(schema));
                int i = 0;
                while ((long)i < rowCount && rows.size() < nrows) {
                    rows.add(Tuple.of((Object[])Parquet.group2object((Group)recordReader.read(), schema.getColumns(), struct), (StructType)struct));
                    ++i;
                }
            }
            DataFrame dataFrame = DataFrame.of(rows);
            return dataFrame;
        }
    }

    private static Object[] group2object(Group g, List<ColumnDescriptor> columns, StructType schema) {
        int length = schema.length();
        Object[] o = new Object[length];
        block28: for (int i = 0; i < length; ++i) {
            int rep = g.getFieldRepetitionCount(i);
            StructField field = schema.field(i);
            ColumnDescriptor column = columns.get(i);
            PrimitiveType primitiveType = column.getPrimitiveType();
            OriginalType originalType = primitiveType.getOriginalType();
            switch (primitiveType.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    if (rep == 1) {
                        o[i] = g.getBoolean(i, 0);
                        continue block28;
                    }
                    if (rep <= 1) continue block28;
                    boolean[] a = new boolean[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getBoolean(i, j);
                    }
                    o[i] = a;
                    continue block28;
                }
                case INT32: {
                    int scale;
                    if (originalType == null) {
                        if (rep == 1) {
                            o[i] = g.getInteger(i, 0);
                            continue block28;
                        }
                        if (rep <= 1) continue block28;
                        int[] a = new int[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getInteger(i, j);
                        }
                        o[i] = a;
                        continue block28;
                    }
                    switch (originalType) {
                        case INT_8: {
                            if (rep == 1) {
                                o[i] = (byte)g.getInteger(i, 0);
                                break;
                            }
                            if (rep <= 1) break;
                            byte[] a = new byte[rep];
                            for (int j = 0; j < rep; ++j) {
                                a[j] = (byte)g.getInteger(i, j);
                            }
                            o[i] = a;
                            break;
                        }
                        case UINT_8: 
                        case INT_16: {
                            if (rep == 1) {
                                o[i] = (short)g.getInteger(i, 0);
                                break;
                            }
                            if (rep <= 1) break;
                            short[] a = new short[rep];
                            for (int j = 0; j < rep; ++j) {
                                a[j] = (short)g.getInteger(i, j);
                            }
                            o[i] = a;
                            break;
                        }
                        case UINT_16: 
                        case INT_32: {
                            if (rep == 1) {
                                o[i] = g.getInteger(i, 0);
                                break;
                            }
                            if (rep <= 1) break;
                            int[] a = new int[rep];
                            for (int j = 0; j < rep; ++j) {
                                a[j] = g.getInteger(i, j);
                            }
                            o[i] = a;
                            break;
                        }
                        case DECIMAL: {
                            if (rep != 1) break;
                            int unscaledValue = g.getInteger(i, 0);
                            DecimalMetadata decimalMetadata = primitiveType.getDecimalMetadata();
                            scale = decimalMetadata.getScale();
                            o[i] = BigDecimal.valueOf(unscaledValue, scale);
                            break;
                        }
                        case DATE: {
                            if (rep != 1) break;
                            int days = g.getInteger(i, 0);
                            o[i] = LocalDate.ofEpochDay(days);
                            break;
                        }
                        case TIME_MILLIS: {
                            if (rep != 1) break;
                            int millis = g.getInteger(i, 0);
                            o[i] = LocalTime.ofNanoOfDay(millis * 1000000);
                        }
                    }
                    continue block28;
                }
                case INT64: {
                    if (originalType == null) {
                        if (rep == 1) {
                            o[i] = g.getLong(i, 0);
                            continue block28;
                        }
                        if (rep <= 1) continue block28;
                        long[] a = new long[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getLong(i, j);
                        }
                        o[i] = a;
                        continue block28;
                    }
                    switch (originalType) {
                        case INT_64: {
                            if (rep == 1) {
                                o[i] = g.getLong(i, 0);
                                break;
                            }
                            if (rep <= 1) break;
                            long[] a = new long[rep];
                            for (int j = 0; j < rep; ++j) {
                                a[j] = g.getLong(i, j);
                            }
                            o[i] = a;
                            break;
                        }
                        case DECIMAL: {
                            if (rep != 1) break;
                            long unscaledValue = g.getLong(i, 0);
                            DecimalMetadata decimalMetadata = primitiveType.getDecimalMetadata();
                            int scale = decimalMetadata.getScale();
                            o[i] = BigDecimal.valueOf(unscaledValue, scale);
                            break;
                        }
                        case TIME_MICROS: {
                            if (rep != 1) break;
                            long micros = g.getLong(i, 0);
                            o[i] = LocalTime.ofNanoOfDay(micros * 1000L);
                            break;
                        }
                        case TIMESTAMP_MILLIS: {
                            if (rep != 1) break;
                            long millis = g.getLong(i, 0);
                            o[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
                            break;
                        }
                        case TIMESTAMP_MICROS: {
                            if (rep != 1) break;
                            long micros = g.getLong(i, 0);
                            long second = micros / 1000000L;
                            int nano = (int)(micros % 1000000L) * 1000;
                            o[i] = LocalDateTime.ofEpochSecond(second, nano, ZoneOffset.UTC);
                        }
                    }
                    continue block28;
                }
                case INT96: {
                    if (rep != 1) continue block28;
                    ByteBuffer buf = g.getInt96(i, 0).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                    long nanoOfDay = buf.getLong();
                    int julianDay = buf.getInt();
                    LocalDate date = LocalDate.ofEpochDay(julianDay - 2440588);
                    LocalTime time = LocalTime.ofNanoOfDay(nanoOfDay);
                    o[i] = LocalDateTime.of(date, time);
                    continue block28;
                }
                case FLOAT: {
                    if (rep == 1) {
                        o[i] = Float.valueOf(g.getFloat(i, 0));
                        continue block28;
                    }
                    if (rep <= 1) continue block28;
                    float[] a = new float[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getFloat(i, j);
                    }
                    o[i] = a;
                    continue block28;
                }
                case DOUBLE: {
                    if (rep == 1) {
                        o[i] = g.getDouble(i, 0);
                        continue block28;
                    }
                    if (rep <= 1) continue block28;
                    double[] a = new double[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getDouble(i, j);
                    }
                    o[i] = a;
                    continue block28;
                }
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    int scale;
                    switch (field.type.id()) {
                        case String: {
                            if (rep == 1) {
                                o[i] = g.getString(i, 0);
                                continue block28;
                            }
                            if (rep <= 1) continue block28;
                            String[] a = new String[rep];
                            for (int j = 0; j < rep; ++j) {
                                a[j] = g.getString(i, j);
                            }
                            o[i] = a;
                            continue block28;
                        }
                        case Decimal: {
                            if (rep != 1) continue block28;
                            byte[] value = g.getBinary(i, 0).getBytes();
                            DecimalMetadata decimalMetadata = primitiveType.getDecimalMetadata();
                            scale = decimalMetadata.getScale();
                            o[i] = new BigDecimal(new BigInteger(value), scale);
                            continue block28;
                        }
                    }
                    if (rep < 1) continue block28;
                    o[i] = g.getBinary(i, 0).getBytes();
                }
            }
        }
        return o;
    }

    private static StructType toSmileSchema(MessageType schema) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (ColumnDescriptor column : schema.getColumns()) {
            fields.add(Parquet.toSmileField(column));
        }
        return DataTypes.struct(fields);
    }

    private static StructField toSmileField(ColumnDescriptor column) {
        String name = String.join((CharSequence)".", column.getPath());
        PrimitiveType primitiveType = column.getPrimitiveType();
        OriginalType originalType = primitiveType.getOriginalType();
        Type.Repetition repetition = primitiveType.getRepetition();
        switch (primitiveType.getPrimitiveTypeName()) {
            case BOOLEAN: {
                switch (repetition) {
                    case REQUIRED: {
                        return new StructField(name, (DataType)DataTypes.BooleanType);
                    }
                    case OPTIONAL: {
                        return new StructField(name, (DataType)DataTypes.BooleanObjectType);
                    }
                    case REPEATED: {
                        return new StructField(name, (DataType)DataTypes.BooleanArrayType);
                    }
                }
            }
            case INT32: {
                if (originalType == null) {
                    switch (repetition) {
                        case REQUIRED: {
                            return new StructField(name, (DataType)DataTypes.IntegerType);
                        }
                        case OPTIONAL: {
                            return new StructField(name, (DataType)DataTypes.IntegerObjectType);
                        }
                        case REPEATED: {
                            return new StructField(name, (DataType)DataTypes.IntegerArrayType);
                        }
                    }
                }
                switch (originalType) {
                    case INT_8: {
                        switch (repetition) {
                            case REQUIRED: {
                                return new StructField(name, (DataType)DataTypes.ByteType);
                            }
                            case OPTIONAL: {
                                return new StructField(name, (DataType)DataTypes.ByteObjectType);
                            }
                            case REPEATED: {
                                return new StructField(name, (DataType)DataTypes.ByteArrayType);
                            }
                        }
                    }
                    case UINT_8: 
                    case INT_16: {
                        switch (repetition) {
                            case REQUIRED: {
                                return new StructField(name, (DataType)DataTypes.ShortType);
                            }
                            case OPTIONAL: {
                                return new StructField(name, (DataType)DataTypes.ShortObjectType);
                            }
                            case REPEATED: {
                                return new StructField(name, (DataType)DataTypes.ShortArrayType);
                            }
                        }
                    }
                    case UINT_16: 
                    case INT_32: {
                        switch (repetition) {
                            case REQUIRED: {
                                return new StructField(name, (DataType)DataTypes.IntegerType);
                            }
                            case OPTIONAL: {
                                return new StructField(name, (DataType)DataTypes.IntegerObjectType);
                            }
                            case REPEATED: {
                                return new StructField(name, (DataType)DataTypes.IntegerArrayType);
                            }
                        }
                    }
                    case DECIMAL: {
                        return new StructField(name, (DataType)DataTypes.DecimalType);
                    }
                    case DATE: {
                        return new StructField(name, (DataType)DataTypes.DateType);
                    }
                    case TIME_MILLIS: {
                        return new StructField(name, (DataType)DataTypes.TimeType);
                    }
                }
                break;
            }
            case INT64: {
                if (originalType == null) {
                    switch (repetition) {
                        case REQUIRED: {
                            return new StructField(name, (DataType)DataTypes.LongType);
                        }
                        case OPTIONAL: {
                            return new StructField(name, (DataType)DataTypes.LongObjectType);
                        }
                        case REPEATED: {
                            return new StructField(name, (DataType)DataTypes.LongArrayType);
                        }
                    }
                }
                switch (originalType) {
                    case INT_64: {
                        switch (repetition) {
                            case REQUIRED: {
                                return new StructField(name, (DataType)DataTypes.LongType);
                            }
                            case OPTIONAL: {
                                return new StructField(name, (DataType)DataTypes.LongObjectType);
                            }
                            case REPEATED: {
                                return new StructField(name, (DataType)DataTypes.LongArrayType);
                            }
                        }
                    }
                    case DECIMAL: {
                        return new StructField(name, (DataType)DataTypes.DecimalType);
                    }
                    case TIME_MICROS: {
                        return new StructField(name, (DataType)DataTypes.TimeType);
                    }
                    case TIMESTAMP_MILLIS: 
                    case TIMESTAMP_MICROS: {
                        return new StructField(name, (DataType)DataTypes.DateTimeType);
                    }
                }
                break;
            }
            case INT96: {
                return new StructField(name, (DataType)DataTypes.DateTimeType);
            }
            case FLOAT: {
                switch (repetition) {
                    case REQUIRED: {
                        return new StructField(name, (DataType)DataTypes.FloatType);
                    }
                    case OPTIONAL: {
                        return new StructField(name, (DataType)DataTypes.FloatObjectType);
                    }
                    case REPEATED: {
                        return new StructField(name, (DataType)DataTypes.FloatArrayType);
                    }
                }
            }
            case DOUBLE: {
                switch (repetition) {
                    case REQUIRED: {
                        return new StructField(name, (DataType)DataTypes.DoubleType);
                    }
                    case OPTIONAL: {
                        return new StructField(name, (DataType)DataTypes.DoubleObjectType);
                    }
                    case REPEATED: {
                        return new StructField(name, (DataType)DataTypes.DoubleArrayType);
                    }
                }
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                if (originalType == null) {
                    return new StructField(name, (DataType)DataTypes.ByteArrayType);
                }
                switch (originalType) {
                    case UTF8: 
                    case JSON: {
                        return new StructField(name, (DataType)DataTypes.StringType);
                    }
                    case DECIMAL: {
                        return new StructField(name, (DataType)DataTypes.DecimalType);
                    }
                }
                return new StructField(name, (DataType)DataTypes.ByteArrayType);
            }
        }
        throw new UnsupportedOperationException("Unsupported OriginalType " + originalType + " for primitive type " + primitiveType);
    }
}

