/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.type.ArrayType;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.ObjectType;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.LongVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.Vector;
import smile.io.Input;

public class Arrow {
    private static final Logger logger = LoggerFactory.getLogger(Arrow.class);
    private static RootAllocator allocator;
    private int batch;

    public Arrow() {
        this(1000000);
    }

    public Arrow(int batch) {
        if (batch <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + batch);
        }
        this.batch = batch;
    }

    public static void allocate(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid RootAllocator limit: " + limit);
        }
        allocator = new RootAllocator(limit);
    }

    public DataFrame read(Path path) throws IOException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(Path path, int limit) throws IOException {
        return this.read(Files.newInputStream(path, new OpenOption[0]), limit);
    }

    public DataFrame read(String path) throws IOException, URISyntaxException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(String path, int limit) throws IOException, URISyntaxException {
        return this.read(Input.stream(path), limit);
    }

    public DataFrame read(InputStream input, int limit) throws IOException {
        if (allocator == null) {
            Arrow.allocate(Long.MAX_VALUE);
        }
        try (ArrowStreamReader reader = new ArrowStreamReader(input, (BufferAllocator)allocator);){
            List fieldVectors;
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            ArrayList<DataFrame> frames = new ArrayList<DataFrame>();
            for (int size = 0; reader.loadNextBatch() && size < limit; size += frames.size()) {
                fieldVectors = root.getFieldVectors();
                logger.info("read {} rows and {} columns", (Object)root.getRowCount(), (Object)fieldVectors.size());
                BaseVector[] vectors = new BaseVector[fieldVectors.size()];
                block35: for (int j = 0; j < fieldVectors.size(); ++j) {
                    FieldVector fieldVector = (FieldVector)fieldVectors.get(j);
                    ArrowType type = fieldVector.getField().getType();
                    switch (type.getTypeID()) {
                        case Int: {
                            ArrowType.Int itype = (ArrowType.Int)type;
                            int bitWidth = itype.getBitWidth();
                            switch (bitWidth) {
                                case 8: {
                                    vectors[j] = this.readByteField(fieldVector);
                                    continue block35;
                                }
                                case 16: {
                                    if (itype.getIsSigned()) {
                                        vectors[j] = this.readShortField(fieldVector);
                                        continue block35;
                                    }
                                    vectors[j] = this.readCharField(fieldVector);
                                    continue block35;
                                }
                                case 32: {
                                    vectors[j] = this.readIntField(fieldVector);
                                    continue block35;
                                }
                                case 64: {
                                    vectors[j] = this.readLongField(fieldVector);
                                    continue block35;
                                }
                            }
                            throw new UnsupportedOperationException("Unsupported integer bit width: " + bitWidth);
                        }
                        case FloatingPoint: {
                            FloatingPointPrecision precision = ((ArrowType.FloatingPoint)type).getPrecision();
                            switch (precision) {
                                case DOUBLE: {
                                    vectors[j] = this.readDoubleField(fieldVector);
                                    continue block35;
                                }
                                case SINGLE: {
                                    vectors[j] = this.readFloatField(fieldVector);
                                    continue block35;
                                }
                                case HALF: {
                                    throw new UnsupportedOperationException("Unsupported float precision: " + precision);
                                }
                            }
                            continue block35;
                        }
                        case Decimal: {
                            vectors[j] = this.readDecimalField(fieldVector);
                            continue block35;
                        }
                        case Bool: {
                            vectors[j] = this.readBitField(fieldVector);
                            continue block35;
                        }
                        case Date: {
                            vectors[j] = this.readDateField(fieldVector);
                            continue block35;
                        }
                        case Time: {
                            vectors[j] = this.readTimeField(fieldVector);
                            continue block35;
                        }
                        case Timestamp: {
                            vectors[j] = this.readDateTimeField(fieldVector);
                            continue block35;
                        }
                        case Binary: 
                        case FixedSizeBinary: {
                            vectors[j] = this.readByteArrayField(fieldVector);
                            continue block35;
                        }
                        case Utf8: {
                            vectors[j] = this.readStringField(fieldVector);
                            continue block35;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported column type: " + fieldVector.getMinorType());
                        }
                    }
                }
                DataFrame frame = DataFrame.of((BaseVector[])vectors);
                frames.add(frame);
            }
            if (frames.isEmpty()) {
                throw new IllegalStateException("No record batch");
            }
            if (frames.size() == 1) {
                fieldVectors = (DataFrame)frames.get(0);
                return fieldVectors;
            }
            DataFrame df = (DataFrame)frames.get(0);
            DataFrame dataFrame = df.union(frames.subList(1, frames.size()).toArray(new DataFrame[frames.size() - 1]));
            return dataFrame;
        }
    }

    public void write(DataFrame df, Path path) throws IOException {
        if (allocator == null) {
            Arrow.allocate(Long.MAX_VALUE);
        }
        Schema schema = this.toArrowSchema(df.schema());
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             OutputStream output = Files.newOutputStream(path, new OpenOption[0]);
             ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)provider, output);){
            writer.start();
            int size = df.size();
            int entries = size;
            for (int from = 0; from < size; from += this.batch) {
                int count = Math.min(this.batch, entries - from);
                root.setRowCount(count);
                block47: for (Field field : root.getSchema().getFields()) {
                    FieldVector vector = root.getVector(field.getName());
                    DataType type = df.schema().field((String)field.getName()).type;
                    switch (type.id()) {
                        case Integer: {
                            this.writeIntField(df, vector, from, count);
                            continue block47;
                        }
                        case Long: {
                            this.writeLongField(df, vector, from, count);
                            continue block47;
                        }
                        case Double: {
                            this.writeDoubleField(df, vector, from, count);
                            continue block47;
                        }
                        case Float: {
                            this.writeFloatField(df, vector, from, count);
                            continue block47;
                        }
                        case Boolean: {
                            this.writeBooleanField(df, vector, from, count);
                            continue block47;
                        }
                        case Byte: {
                            this.writeByteField(df, vector, from, count);
                            continue block47;
                        }
                        case Short: {
                            this.writeShortField(df, vector, from, count);
                            continue block47;
                        }
                        case Char: {
                            this.writeCharField(df, vector, from, count);
                            continue block47;
                        }
                        case String: {
                            this.writeStringField(df, vector, from, count);
                            continue block47;
                        }
                        case Date: {
                            this.writeDateField(df, vector, from, count);
                            continue block47;
                        }
                        case Time: {
                            this.writeTimeField(df, vector, from, count);
                            continue block47;
                        }
                        case DateTime: {
                            this.writeDateTimeField(df, vector, from, count);
                            continue block47;
                        }
                        case Object: {
                            Class clazz = ((ObjectType)type).getObjectClass();
                            if (clazz == Integer.class) {
                                this.writeIntObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == Long.class) {
                                this.writeLongObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == Double.class) {
                                this.writeDoubleObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == Float.class) {
                                this.writeFloatObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == Boolean.class) {
                                this.writeBooleanObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == Byte.class) {
                                this.writeByteObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == Short.class) {
                                this.writeShortObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == Character.class) {
                                this.writeCharObjectField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == BigDecimal.class) {
                                this.writeDecimalField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == String.class) {
                                this.writeStringField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == LocalDate.class) {
                                this.writeDateField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == LocalTime.class) {
                                this.writeTimeField(df, vector, from, count);
                                continue block47;
                            }
                            if (clazz == LocalDateTime.class) {
                                this.writeDateTimeField(df, vector, from, count);
                                continue block47;
                            }
                            throw new UnsupportedOperationException("Unsupported type: " + type);
                        }
                        case Array: {
                            DataType etype = ((ArrayType)type).getComponentType();
                            switch (etype.id()) {
                                case Byte: {
                                    this.writeByteArrayField(df, vector, from, count);
                                    continue block47;
                                }
                            }
                            throw new UnsupportedOperationException("Unsupported type: " + type);
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported type: " + type);
                }
                writer.writeBatch();
                logger.info("write {} rows", (Object)count);
            }
        }
    }

    private BaseVector readBitField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        BitVector vector = (BitVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            boolean[] a = new boolean[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i) != 0;
            }
            return BooleanVector.of((String)fieldVector.getField().getName(), (boolean[])a);
        }
        Object[] a = new Boolean[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Boolean.valueOf(vector.get(i) != 0);
        }
        return Vector.of((String)fieldVector.getField().getName(), Boolean.class, (Object[])a);
    }

    private BaseVector readByteField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            byte[] a = new byte[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return ByteVector.of((String)fieldVector.getField().getName(), (byte[])a);
        }
        Object[] a = new Byte[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Byte.valueOf(vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), Byte.class, (Object[])a);
    }

    private BaseVector readCharField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            char[] a = new char[count];
            for (int i = 0; i < count; ++i) {
                a[i] = (char)vector.get(i);
            }
            return CharVector.of((String)fieldVector.getField().getName(), (char[])a);
        }
        Object[] a = new Character[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Character.valueOf((char)vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), Character.class, (Object[])a);
    }

    private BaseVector readShortField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            short[] a = new short[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return ShortVector.of((String)fieldVector.getField().getName(), (short[])a);
        }
        Object[] a = new Short[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Short.valueOf(vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), Short.class, (Object[])a);
    }

    private BaseVector readIntField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        IntVector vector = (IntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            int[] a = new int[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return smile.data.vector.IntVector.of((String)fieldVector.getField().getName(), (int[])a);
        }
        Object[] a = new Integer[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Integer.valueOf(vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), Integer.class, (Object[])a);
    }

    private BaseVector readLongField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        BigIntVector vector = (BigIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            long[] a = new long[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return LongVector.of((String)fieldVector.getField().getName(), (long[])a);
        }
        Object[] a = new Long[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Long.valueOf(vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), Long.class, (Object[])a);
    }

    private BaseVector readFloatField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Float4Vector vector = (Float4Vector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            float[] a = new float[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return FloatVector.of((String)fieldVector.getField().getName(), (float[])a);
        }
        Object[] a = new Float[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Float.valueOf(vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), Float.class, (Object[])a);
    }

    private BaseVector readDoubleField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Float8Vector vector = (Float8Vector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            double[] a = new double[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return DoubleVector.of((String)fieldVector.getField().getName(), (double[])a);
        }
        Object[] a = new Double[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Double.valueOf(vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), Double.class, (Object[])a);
    }

    private BaseVector readDecimalField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Object[] a = new BigDecimal[count];
        DecimalVector vector = (DecimalVector)fieldVector;
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : vector.getObject(i);
        }
        return Vector.of((String)fieldVector.getField().getName(), (DataType)DataTypes.DecimalType, (Object[])a);
    }

    private BaseVector readDateField(FieldVector fieldVector) {
        Object[] a;
        block3: {
            ZoneOffset zone;
            int count;
            block2: {
                count = fieldVector.getValueCount();
                a = new LocalDate[count];
                zone = OffsetDateTime.now().getOffset();
                if (!(fieldVector instanceof DateDayVector)) break block2;
                DateDayVector vector = (DateDayVector)fieldVector;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalDate.ofEpochDay(vector.get(i));
                }
                break block3;
            }
            if (!(fieldVector instanceof DateMilliVector)) break block3;
            DateMilliVector vector = (DateMilliVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone).toLocalDate();
            }
        }
        return Vector.of((String)fieldVector.getField().getName(), (DataType)DataTypes.DateType, (Object[])a);
    }

    private BaseVector readTimeField(FieldVector fieldVector) {
        Object[] a;
        block5: {
            int count;
            block7: {
                block6: {
                    block4: {
                        count = fieldVector.getValueCount();
                        a = new LocalTime[count];
                        if (!(fieldVector instanceof TimeNanoVector)) break block4;
                        TimeNanoVector vector = (TimeNanoVector)fieldVector;
                        for (int i = 0; i < count; ++i) {
                            a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i));
                        }
                        break block5;
                    }
                    if (!(fieldVector instanceof TimeMilliVector)) break block6;
                    TimeMilliVector vector = (TimeMilliVector)fieldVector;
                    for (int i = 0; i < count; ++i) {
                        a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i) * 1000000);
                    }
                    break block5;
                }
                if (!(fieldVector instanceof TimeMicroVector)) break block7;
                TimeMicroVector vector = (TimeMicroVector)fieldVector;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i) * 1000L);
                }
                break block5;
            }
            if (!(fieldVector instanceof TimeSecVector)) break block5;
            TimeSecVector vector = (TimeSecVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalTime.ofSecondOfDay(vector.get(i));
            }
        }
        return Vector.of((String)fieldVector.getField().getName(), (DataType)DataTypes.TimeType, (Object[])a);
    }

    private BaseVector readDateTimeField(FieldVector fieldVector) {
        Object[] a;
        block5: {
            ZoneOffset zone;
            TimeStampVector vector;
            int count;
            block7: {
                block6: {
                    block4: {
                        count = fieldVector.getValueCount();
                        a = new LocalDateTime[count];
                        vector = (TimeStampVector)fieldVector;
                        String timezone = ((ArrowType.Timestamp)fieldVector.getField().getType()).getTimezone();
                        ZoneOffset zoneOffset = zone = timezone == null ? OffsetDateTime.now().getOffset() : ZoneOffset.of(timezone);
                        if (!(fieldVector instanceof TimeStampMilliVector)) break block4;
                        for (int i = 0; i < count; ++i) {
                            a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone);
                        }
                        break block5;
                    }
                    if (!(fieldVector instanceof TimeStampNanoVector)) break block6;
                    for (int i = 0; i < count; ++i) {
                        a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000000L), zone);
                    }
                    break block5;
                }
                if (!(fieldVector instanceof TimeStampMicroVector)) break block7;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000L), zone);
                }
                break block5;
            }
            if (!(fieldVector instanceof TimeStampSecVector)) break block5;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalDateTime.ofEpochSecond(vector.get(i), 0, zone);
            }
        }
        return Vector.of((String)fieldVector.getField().getName(), (DataType)DataTypes.DateTimeType, (Object[])a);
    }

    private BaseVector readByteArrayField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        byte[][] a = new byte[count][];
        if (fieldVector instanceof VarBinaryVector) {
            VarBinaryVector vector = (VarBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else if (fieldVector instanceof FixedSizeBinaryVector) {
            FixedSizeBinaryVector vector = (FixedSizeBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported binary vector: " + fieldVector);
        }
        return Vector.of((String)fieldVector.getField().getName(), (DataType)DataTypes.ByteArrayType, (Object[])a);
    }

    private BaseVector readStringField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        VarCharVector vector = (VarCharVector)fieldVector;
        Object[] a = new String[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : new String(vector.get(i));
        }
        return Vector.of((String)fieldVector.getField().getName(), (DataType)DataTypes.StringType, (Object[])a);
    }

    private void writeIntField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        smile.data.vector.IntVector column = df.intVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getInt(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeIntObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Integer x = (Integer)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.intValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeBooleanField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        BooleanVector column = df.booleanVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getInt(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeBooleanObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Boolean x = (Boolean)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x != false ? 1 : 0);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeCharField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        CharVector column = df.charVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getChar(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeCharObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Character x = (Character)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.charValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        ByteVector column = df.byteVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getByte(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Byte x = (Byte)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.byteValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeShortField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        ShortVector column = df.shortVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getShort(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeShortObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Short x = (Short)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.shortValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeLongField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        LongVector column = df.longVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getLong(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeLongObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Long x = (Long)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.longValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeFloatField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        FloatVector column = df.floatVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getFloat(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeFloatObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Float x = (Float)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.floatValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDoubleField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        DoubleVector column = df.doubleVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getDouble(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDoubleObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Double x = (Double)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.doubleValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeStringField(DataFrame df, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarCharVector vector = (VarCharVector)fieldVector;
        StringVector column = df.stringVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            String x = (String)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.getBytes("UTF-8"));
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDecimalField(DataFrame df, FieldVector fieldVector, int from, int count) throws UnsupportedEncodingException {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DecimalVector vector = (DecimalVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            BigDecimal x = (BigDecimal)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDateField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DateDayVector vector = (DateDayVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDate x = (LocalDate)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, (int)x.toEpochDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeTimeField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeNanoVector vector = (TimeNanoVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalTime x = (LocalTime)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toNanoOfDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDateTimeField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeStampMilliTZVector vector = (TimeStampMilliTZVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDateTime x = (LocalDateTime)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toInstant(OffsetDateTime.now().getOffset()).toEpochMilli());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteArrayField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarBinaryVector vector = (VarBinaryVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            byte[] bytes = (byte[])column.get(j);
            if (bytes == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, bytes);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private Schema toArrowSchema(StructType schema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (StructField field : schema.fields()) {
            fields.add(this.toArrowField(field));
        }
        return new Schema(fields, null);
    }

    private StructType toSmileSchema(Schema schema) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (Field field : schema.getFields()) {
            fields.add(this.toSmileField(field));
        }
        return DataTypes.struct(fields);
    }

    private Field toArrowField(StructField field) {
        switch (field.type.id()) {
            case Integer: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null);
            }
            case Long: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null);
            }
            case Double: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null);
            }
            case Float: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null);
            }
            case Boolean: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null);
            }
            case Byte: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(8, true), null), null);
            }
            case Short: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(16, true), null), null);
            }
            case Char: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(16, false), null), null);
            }
            case Decimal: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Decimal(28, 10)), null);
            }
            case String: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
            }
            case Date: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)), null);
            }
            case Time: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)), null);
            }
            case DateTime: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, ZoneOffset.UTC.getId())), null);
            }
            case Object: {
                Class clazz = ((ObjectType)field.type).getObjectClass();
                if (clazz == Integer.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
                }
                if (clazz == Long.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), null);
                }
                if (clazz == Double.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), null);
                }
                if (clazz == Float.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), null);
                }
                if (clazz == Boolean.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Bool()), null);
                }
                if (clazz == Byte.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), null);
                }
                if (clazz == Short.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null);
                }
                if (clazz != Character.class) break;
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(16, false)), null);
            }
            case Array: {
                DataType etype = ((ArrayType)field.type).getComponentType();
                switch (etype.id()) {
                    case Integer: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Arrays.asList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null)));
                    }
                    case Long: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Arrays.asList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null)));
                    }
                    case Double: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Arrays.asList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null)));
                    }
                    case Float: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Arrays.asList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null)));
                    }
                    case Boolean: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Arrays.asList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null)));
                    }
                    case Byte: {
                        return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Binary()), null);
                    }
                    case Short: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Arrays.asList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(16, true), null), null)));
                    }
                    case Char: {
                        return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
                    }
                }
                break;
            }
            case Struct: {
                StructType children = (StructType)field.type;
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Struct(), null), Arrays.stream(children.fields()).map(this::toArrowField).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException("Unsupported smile to arrow type conversion: " + field.type);
    }

    private StructField toSmileField(Field field) {
        String name = field.getName();
        ArrowType type = field.getType();
        boolean nullable = field.isNullable();
        switch (type.getTypeID()) {
            case Int: {
                ArrowType.Int itype = (ArrowType.Int)type;
                int bitWidth = itype.getBitWidth();
                switch (bitWidth) {
                    case 8: {
                        return new StructField(name, (DataType)(nullable ? DataTypes.ByteObjectType : DataTypes.ByteType));
                    }
                    case 16: {
                        if (itype.getIsSigned()) {
                            return new StructField(name, (DataType)(nullable ? DataTypes.ShortObjectType : DataTypes.ShortType));
                        }
                        return new StructField(name, (DataType)(nullable ? DataTypes.CharObjectType : DataTypes.CharType));
                    }
                    case 32: {
                        return new StructField(name, (DataType)(nullable ? DataTypes.IntegerObjectType : DataTypes.IntegerType));
                    }
                    case 64: {
                        return new StructField(name, (DataType)(nullable ? DataTypes.LongObjectType : DataTypes.LongType));
                    }
                }
                throw new UnsupportedOperationException("Unsupported integer bit width: " + bitWidth);
            }
            case FloatingPoint: {
                FloatingPointPrecision precision = ((ArrowType.FloatingPoint)type).getPrecision();
                switch (precision) {
                    case DOUBLE: {
                        return new StructField(name, (DataType)(nullable ? DataTypes.DoubleObjectType : DataTypes.DoubleType));
                    }
                    case SINGLE: {
                        return new StructField(name, (DataType)(nullable ? DataTypes.FloatObjectType : DataTypes.FloatType));
                    }
                    case HALF: {
                        throw new UnsupportedOperationException("Unsupported float precision: " + precision);
                    }
                }
            }
            case Bool: {
                return new StructField(name, (DataType)(nullable ? DataTypes.BooleanObjectType : DataTypes.BooleanType));
            }
            case Decimal: {
                return new StructField(name, (DataType)DataTypes.DecimalType);
            }
            case Utf8: {
                return new StructField(name, (DataType)DataTypes.StringType);
            }
            case Date: {
                return new StructField(name, (DataType)DataTypes.DateType);
            }
            case Time: {
                return new StructField(name, (DataType)DataTypes.TimeType);
            }
            case Timestamp: {
                return new StructField(name, (DataType)DataTypes.DateTimeType);
            }
            case Binary: 
            case FixedSizeBinary: {
                return new StructField(name, (DataType)DataTypes.ByteArrayType);
            }
            case List: 
            case FixedSizeList: {
                List child = field.getChildren();
                if (child.size() != 1) {
                    throw new IllegalStateException(String.format("List type has %d child fields.", child.size()));
                }
                return new StructField(name, (DataType)DataTypes.array((DataType)this.toSmileField((Field)((Field)child.get((int)0))).type));
            }
            case Struct: {
                List children = field.getChildren().stream().map(this::toSmileField).collect(Collectors.toList());
                return new StructField(name, (DataType)DataTypes.struct(children));
            }
        }
        throw new UnsupportedOperationException("Unsupported arrow to smile type conversion: " + type);
    }
}

