/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.Serializable;
import smile.linalg.Transpose;
import smile.math.MathEx;
import smile.tensor.DenseMatrix;
import smile.tensor.Vector;

public record SVD(int m, int n, Vector s, DenseMatrix U, DenseMatrix Vt) implements Serializable
{
    public SVD(int m, int n, Vector s) {
        this(m, n, s, null, null);
    }

    public SVD(Vector s, DenseMatrix U, DenseMatrix Vt) {
        this(U.m, Vt.n, s, U, Vt);
    }

    public DenseMatrix diag() {
        DenseMatrix S = this.s.zeros(this.m, this.n);
        int size = this.s.size();
        for (int i = 0; i < size; ++i) {
            S.set(i, i, this.s.get(i));
        }
        return S;
    }

    public double norm() {
        return this.s.get(0);
    }

    private double rcond() {
        return 0.5 * Math.sqrt(this.m + this.n + 1) * this.s.get(0) * MathEx.EPSILON;
    }

    public int rank() {
        if (this.s.size() != Math.min(this.m, this.n)) {
            throw new UnsupportedOperationException("The rank() operation cannot be called on a partial SVD.");
        }
        int r = 0;
        int size = this.s.size();
        double tol = this.rcond();
        for (int i = 0; i < size; ++i) {
            if (!(this.s.get(i) > tol)) continue;
            ++r;
        }
        return r;
    }

    public int nullity() {
        return Math.min(this.m, this.n) - this.rank();
    }

    public double condition() {
        if (this.s.size() != Math.min(this.m, this.n)) {
            throw new UnsupportedOperationException("The operation cannot be called on a partial SVD.");
        }
        double s0 = this.s.get(0);
        double s1 = this.s.get(this.s.size() - 1);
        return s0 <= 0.0 || s1 <= 0.0 ? Double.POSITIVE_INFINITY : s0 / s1;
    }

    public DenseMatrix range() {
        if (this.s.size() != Math.min(this.m, this.n)) {
            throw new UnsupportedOperationException("The operation cannot be called on a partial SVD.");
        }
        if (this.U == null) {
            throw new IllegalStateException("The left singular vectors are not available.");
        }
        int r = this.rank();
        if (r == 0) {
            return null;
        }
        DenseMatrix R = this.U.zeros(this.m, r);
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < this.m; ++i) {
                R.set(i, j, this.U.get(i, j));
            }
        }
        return R;
    }

    public DenseMatrix nullspace() {
        if (this.s.size() != Math.min(this.m, this.n)) {
            throw new UnsupportedOperationException("The operation cannot be called on a partial SVD.");
        }
        if (this.Vt == null) {
            throw new IllegalStateException("The right singular vectors are not available.");
        }
        int nr = this.nullity();
        if (nr == 0) {
            return null;
        }
        DenseMatrix N = this.Vt.zeros(this.n, nr);
        for (int j = 0; j < nr; ++j) {
            for (int i = 0; i < this.n; ++i) {
                N.set(i, j, this.Vt.get(this.n - j - 1, i));
            }
        }
        return N;
    }

    public DenseMatrix pinv() {
        if (this.U == null || this.Vt == null) {
            throw new IllegalStateException("The singular vectors are not available.");
        }
        int k = this.s.size();
        Vector sigma = this.s.zeros(k);
        int r = this.rank();
        for (int i = 0; i < r; ++i) {
            sigma.set(i, 1.0 / this.s.get(i));
        }
        return SVD.adb(Transpose.TRANSPOSE, this.Vt, sigma, Transpose.TRANSPOSE, this.U);
    }

    public Vector solve(double[] b) {
        if (this.U == null || this.Vt == null) {
            throw new IllegalStateException("The singular vectors are not available.");
        }
        return this.solve(this.U.vector(b));
    }

    public Vector solve(float[] b) {
        if (this.U == null || this.Vt == null) {
            throw new IllegalStateException("The singular vectors are not available.");
        }
        return this.solve(this.U.vector(b));
    }

    public Vector solve(Vector b) {
        if (this.U == null || this.Vt == null) {
            throw new IllegalStateException("The singular vectors are not available.");
        }
        if (b.size() < this.m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x 1", this.m, this.n, b.size()));
        }
        int r = this.rank();
        DenseMatrix Ur = r == this.U.ncol() ? this.U : this.U.submatrix(0, 0, this.m, r);
        DenseMatrix Vr = r == this.Vt.nrow() ? this.Vt : this.Vt.submatrix(0, 0, r, this.n);
        Vector Utb = Ur.vector(r);
        Ur.tv(b, Utb);
        for (int i = 0; i < r; ++i) {
            Utb.set(i, Utb.get(i) / this.s.get(i));
        }
        return Vr.tv(Utb);
    }

    private static DenseMatrix adb(Transpose transA, DenseMatrix A, Vector D, Transpose transB, DenseMatrix B) {
        DenseMatrix AD;
        int m = A.m;
        int n = A.n;
        if (transA == Transpose.NO_TRANSPOSE) {
            AD = A.zeros(m, n);
            for (int j = 0; j < n; ++j) {
                double dj = D.get(j);
                for (int i = 0; i < m; ++i) {
                    AD.set(i, j, dj * A.get(i, j));
                }
            }
        } else {
            AD = A.zeros(n, m);
            for (int j = 0; j < m; ++j) {
                double dj = D.get(j);
                for (int i = 0; i < n; ++i) {
                    AD.set(i, j, dj * A.get(j, i));
                }
            }
        }
        return transB == Transpose.NO_TRANSPOSE ? AD.mm(B) : AD.mt(B);
    }
}

