/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.foreign.MemorySegment;
import smile.tensor.BandMatrix;
import smile.tensor.ScalarType;

class BandMatrix32
extends BandMatrix
implements Serializable {
    final float[] ab;

    private BandMatrix32() {
        this.ab = null;
    }

    public BandMatrix32(int m, int n, int kl, int ku, float[] ab) {
        super(MemorySegment.ofArray(ab), m, n, kl, ku);
        this.ab = ab;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.memory = MemorySegment.ofArray(this.ab);
    }

    @Override
    public ScalarType scalarType() {
        return ScalarType.Float32;
    }

    @Override
    public long length() {
        return this.ab.length;
    }

    @Override
    public double get(int i, int j) {
        if (Math.max(0, j - this.ku) <= i && i <= Math.min(this.m - 1, j + this.kl)) {
            return this.ab[j * this.ld + this.ku + i - j];
        }
        return 0.0;
    }

    @Override
    public void set(int i, int j, double x) {
        if (Math.max(0, j - this.ku) > i || i > Math.min(this.m - 1, j + this.kl)) {
            throw new UnsupportedOperationException(String.format("Set element at (%d, %d)", i, j));
        }
        this.ab[j * this.ld + this.ku + i - j] = (float)x;
    }

    @Override
    public void add(int i, int j, double x) {
        if (Math.max(0, j - this.ku) > i || i > Math.min(this.m - 1, j + this.kl)) {
            throw new UnsupportedOperationException(String.format("Add element at (%d, %d)", i, j));
        }
        int n = j * this.ld + this.ku + i - j;
        this.ab[n] = this.ab[n] + (float)x;
    }

    @Override
    public void sub(int i, int j, double x) {
        if (Math.max(0, j - this.ku) > i || i > Math.min(this.m - 1, j + this.kl)) {
            throw new UnsupportedOperationException(String.format("Sub element at (%d, %d)", i, j));
        }
        int n = j * this.ld + this.ku + i - j;
        this.ab[n] = this.ab[n] - (float)x;
    }

    @Override
    public void mul(int i, int j, double x) {
        if (Math.max(0, j - this.ku) > i || i > Math.min(this.m - 1, j + this.kl)) {
            throw new UnsupportedOperationException(String.format("Mul element at (%d, %d)", i, j));
        }
        int n = j * this.ld + this.ku + i - j;
        this.ab[n] = this.ab[n] * (float)x;
    }

    @Override
    public void div(int i, int j, double x) {
        if (Math.max(0, j - this.ku) > i || i > Math.min(this.m - 1, j + this.kl)) {
            throw new UnsupportedOperationException(String.format("Div element at (%d, %d)", i, j));
        }
        int n = j * this.ld + this.ku + i - j;
        this.ab[n] = this.ab[n] / (float)x;
    }

    @Override
    public BandMatrix copy() {
        BandMatrix32 matrix = new BandMatrix32(this.m, this.n, this.kl, this.ku, (float[])this.ab.clone());
        if (this.m == this.n && this.kl == this.ku) {
            matrix.withUplo(this.uplo);
        }
        return matrix;
    }

    @Override
    MemorySegment lua() {
        int lda = this.lda();
        float[] work = new float[lda * this.n];
        for (int k = 0; k < this.ab.length; ++k) {
            int i = k % this.ld;
            int j = k / this.ld;
            work[j * lda + i + this.kl] = this.ab[k];
        }
        return MemorySegment.ofArray(work);
    }
}

