/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.util.Arrays;
import java.util.stream.Collectors;
import smile.math.MathEx;
import smile.stat.distribution.DiscreteDistribution;
import smile.util.IntSet;

public class EmpiricalDistribution
extends DiscreteDistribution {
    private static final long serialVersionUID = 2L;
    public final double[] p;
    private final IntSet x;
    private final double[] cdf;
    private double mean;
    private final double variance;
    private final double sd;
    private double entropy;
    private int[] a;
    private double[] q;

    public EmpiricalDistribution(double[] prob) {
        this(prob, IntSet.of(prob.length));
    }

    public EmpiricalDistribution(double[] prob, IntSet x) {
        if (prob.length == 0) {
            throw new IllegalArgumentException("Empty probability set.");
        }
        this.x = x;
        this.p = new double[prob.length];
        this.cdf = new double[prob.length];
        this.mean = 0.0;
        double mean2 = 0.0;
        this.entropy = 0.0;
        this.cdf[0] = prob[0];
        for (int i = 0; i < prob.length; ++i) {
            if (prob[i] < 0.0 || prob[i] > 1.0) {
                throw new IllegalArgumentException("Invalid probability " + this.p[i]);
            }
            this.p[i] = prob[i];
            if (i > 0) {
                this.cdf[i] = this.cdf[i - 1] + this.p[i];
            }
            int xi = x.valueOf(i);
            this.mean += (double)xi * this.p[i];
            mean2 += (double)(xi * xi) * this.p[i];
            this.entropy -= this.p[i] * MathEx.log2(this.p[i]);
        }
        this.variance = mean2 - this.mean * this.mean;
        this.sd = Math.sqrt(this.variance);
        if (Math.abs(this.cdf[this.cdf.length - 1] - 1.0) > 1.0E-7) {
            throw new IllegalArgumentException("The sum of probabilities is not 1.");
        }
    }

    public static EmpiricalDistribution fit(int[] data) {
        return EmpiricalDistribution.fit(data, IntSet.of(data));
    }

    public static EmpiricalDistribution fit(int[] data, IntSet x) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Empty dataset.");
        }
        int k = x.size();
        double[] p = new double[k];
        for (int xi : data) {
            int n = x.indexOf(xi);
            p[n] = p[n] + 1.0;
        }
        int n = data.length;
        int i = 0;
        while (i < k) {
            int n2 = i++;
            p[n2] = p[n2] / (double)n;
        }
        return new EmpiricalDistribution(p, x);
    }

    @Override
    public int length() {
        return this.p.length;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double sd() {
        return this.sd;
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return Arrays.stream(this.p).mapToObj(pi -> String.format("%.2f", pi)).collect(Collectors.joining(", ", "Empirical Distribution(", ")"));
    }

    @Override
    public double rand() {
        int k;
        if (this.a == null) {
            this.initRand();
        }
        double rU = MathEx.random() * (double)this.p.length;
        if ((rU -= (double)(k = (int)rU)) < this.q[k]) {
            return this.x.valueOf(k);
        }
        return this.x.valueOf(this.a[k]);
    }

    @Override
    public int[] randi(int n) {
        if (this.a == null) {
            this.initRand();
        }
        int[] ans = new int[n];
        for (int i = 0; i < n; ++i) {
            int k;
            double rU = MathEx.random() * (double)this.p.length;
            ans[i] = (rU -= (double)(k = (int)rU)) < this.q[k] ? this.x.valueOf(k) : this.x.valueOf(this.a[k]);
        }
        return ans;
    }

    private synchronized void initRand() {
        int i;
        this.q = new double[this.p.length];
        for (i = 0; i < this.p.length; ++i) {
            this.q[i] = this.p[i] * (double)this.p.length;
        }
        this.a = new int[this.p.length];
        for (i = 0; i < this.p.length; ++i) {
            this.a[i] = i;
        }
        int[] HL = new int[this.p.length];
        int head = 0;
        int tail = this.p.length - 1;
        for (int i2 = 0; i2 < this.p.length; ++i2) {
            if (this.q[i2] >= 1.0) {
                HL[head++] = i2;
                continue;
            }
            HL[tail--] = i2;
        }
        while (head != 0 && tail != this.p.length - 1) {
            int k;
            int j = HL[tail + 1];
            this.a[j] = k = HL[head - 1];
            int n = k;
            this.q[n] = this.q[n] + (this.q[j] - 1.0);
            ++tail;
            if (!(this.q[k] < 1.0)) continue;
            HL[tail--] = k;
            --head;
        }
    }

    @Override
    public double p(int k) {
        if (k < this.x.min || k > this.x.max) {
            return 0.0;
        }
        return this.p[this.x.indexOf(k)];
    }

    @Override
    public double logp(int k) {
        if (k < this.x.min || k > this.x.max) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.p[this.x.indexOf(k)]);
    }

    @Override
    public double cdf(double k) {
        if (k < (double)this.x.min) {
            return 0.0;
        }
        if (k >= (double)this.x.max) {
            return 1.0;
        }
        return this.cdf[this.x.indexOf((int)Math.floor(k))];
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        int k = Arrays.binarySearch(this.cdf, p);
        if (k < 0) {
            return this.x.valueOf(-k - 1);
        }
        return this.x.valueOf(k);
    }
}

