/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import smile.sort.Sort;

public class IntHeapSelect {
    private final int k;
    private final int[] heap;
    private int n;
    private boolean sorted;

    public IntHeapSelect(int k) {
        this.heap = new int[k + 1];
        this.k = k;
        this.n = 0;
        this.sorted = false;
    }

    public void add(int datum) {
        this.sorted = false;
        if (this.n < this.k) {
            this.heap[++this.n] = datum;
            Sort.siftUp(this.heap, this.n);
        } else {
            ++this.n;
            if (datum < this.heap[1]) {
                this.heap[1] = datum;
                Sort.siftDown(this.heap, 1, this.k);
            }
        }
    }

    public int peek() {
        return this.heap[1];
    }

    public int get(int i) {
        int len = Math.min(this.k, this.n);
        if (i > len - 1) {
            throw new IllegalArgumentException("HeapSelect i is greater than the number of data received so far.");
        }
        if (i == len - 1) {
            return this.heap[1];
        }
        this.sort();
        return this.heap[len - i];
    }

    public void sort() {
        if (!this.sorted) {
            IntHeapSelect.sort(this.heap, 1, Math.min(this.k, this.n));
            this.sorted = true;
        }
    }

    private static void heapify(int[] arr, int n) {
        for (int i = n / 2; i >= 1; --i) {
            Sort.siftDown(arr, i, n);
        }
    }

    private static void sort(int[] a, int l, int r) {
        int h = 1;
        while (h <= (r - l) / 9) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = l + h; i <= r; ++i) {
                int j = i;
                int v = a[i];
                while (j >= l + h && a[j - h] < v) {
                    a[j] = a[j - h];
                    a[j -= h] = v;
                }
            }
            h /= 3;
        }
    }
}

