/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor.lsh;

import java.util.Arrays;
import smile.neighbor.lsh.Bucket;
import smile.neighbor.lsh.Hash;
import smile.tensor.Vector;

public class MultiProbeHash
extends Hash {
    private static final long serialVersionUID = 2L;
    final double[] umin;
    final double[] umax;

    public MultiProbeHash(int d, int k, double w, int H) {
        super(d, k, w, H);
        this.umin = new double[k];
        this.umax = new double[k];
        Arrays.fill(this.umin, Double.POSITIVE_INFINITY);
        Arrays.fill(this.umax, Double.NEGATIVE_INFINITY);
    }

    private int mphash(double[] x) {
        Vector h = this.a.mv(x);
        long g = 0L;
        for (int i = 0; i < this.k; ++i) {
            double hi = (h.get(i) + this.b[i]) / this.w;
            this.umin[i] = Math.min(this.umin[i], hi);
            this.umax[i] = Math.max(this.umax[i], hi);
            g += (long)this.c[i] * (long)Math.floor(hi);
        }
        int gint = (int)(g % Integer.MAX_VALUE);
        return gint >= 0 ? gint : gint + Integer.MAX_VALUE;
    }

    @Override
    public void add(int index, double[] x) {
        int bucket = this.mphash(x);
        int i = bucket % this.H;
        if (this.table[i] == null) {
            this.table[i] = new Bucket(bucket);
        }
        this.table[i].add(index);
    }
}

