/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.DotProductKernel;

public class Polynomial
implements DotProductKernel {
    private static final long serialVersionUID = 2L;
    final int degree;
    final double scale;
    final double offset;
    final double[] lo;
    final double[] hi;

    public Polynomial(int degree, double scale, double offset, double[] lo, double[] hi) {
        if (degree <= 0) {
            throw new IllegalArgumentException("Non-positive polynomial degree: " + degree);
        }
        if (offset < 0.0) {
            throw new IllegalArgumentException("Negative offset: the kernel does not satisfy Mercer's condition: " + offset);
        }
        this.degree = degree;
        this.scale = scale;
        this.offset = offset;
        this.lo = lo;
        this.hi = hi;
    }

    public int degree() {
        return this.degree;
    }

    public double scale() {
        return this.scale;
    }

    public double offset() {
        return this.offset;
    }

    public String toString() {
        return String.format("PolynomialKernel(%d, %.4f, %.4f)", this.degree, this.scale, this.offset);
    }

    @Override
    public double k(double dot) {
        return Math.pow(this.scale * dot + this.offset, this.degree);
    }

    @Override
    public double[] kg(double dot) {
        double[] g = new double[3];
        double pow = Math.pow(this.scale * dot + this.offset, this.degree - 1);
        g[0] = Math.pow(this.scale * dot + this.offset, this.degree);
        g[1] = dot * pow;
        g[2] = pow;
        return g;
    }
}

