/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.HyperbolicTangent;
import smile.math.kernel.MercerKernel;

public class HyperbolicTangentKernel
extends HyperbolicTangent
implements MercerKernel<double[]> {
    public HyperbolicTangentKernel() {
        this(1.0, 0.0);
    }

    public HyperbolicTangentKernel(double scale, double offset) {
        this(scale, offset, new double[]{0.01, 1.0E-5}, new double[]{100.0, 100000.0});
    }

    public HyperbolicTangentKernel(double scale, double offset, double[] lo, double[] hi) {
        super(scale, offset, lo, hi);
    }

    @Override
    public double k(double[] x, double[] y) {
        return this.k(MathEx.dot(x, y));
    }

    @Override
    public double[] kg(double[] x, double[] y) {
        return this.kg(MathEx.dot(x, y));
    }

    public HyperbolicTangentKernel of(double[] params) {
        return new HyperbolicTangentKernel(params[0], params[1], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.scale, this.offset};
    }

    @Override
    public double[] lo() {
        return this.lo;
    }

    @Override
    public double[] hi() {
        return this.hi;
    }
}

