/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.tensor.Matrix;
import smile.tensor.Vector;

public interface PageRank {
    public static final Logger logger = LoggerFactory.getLogger(PageRank.class);

    public static Vector of(Matrix A) {
        int n = A.nrow();
        Vector v = A.vector(n);
        v.fill(1.0 / (double)n);
        return PageRank.of(A, v);
    }

    public static Vector of(Matrix A, Vector v) {
        return PageRank.of(A, v, 0.85, 1.0E-7, 57);
    }

    public static Vector of(Matrix A, Vector v, double damping, double tol, int maxIter) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException("Matrix is not square.");
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int n = A.nrow();
        tol = Math.max(tol, MathEx.EPSILON * (double)n);
        Vector z = A.vector(n);
        Vector p = v.copy(0, n);
        for (int iter = 1; iter <= maxIter; ++iter) {
            A.mv(p, z);
            double beta = 1.0 - damping * z.norm1();
            double delta = 0.0;
            for (int i = 0; i < n; ++i) {
                double q = damping * z.get(i) + beta * v.get(i);
                delta += Math.abs(q - p.get(i));
                p.set(i, q);
            }
            if (iter % 10 == 0 || delta < tol) {
                logger.info("PageRank residual after {} power iterations: {}", (Object)iter, (Object)delta);
            }
            if (!(delta < tol)) continue;
            return p;
        }
        logger.error("PageRank iteration exceeded the maximum number of iterations.");
        return p;
    }
}

