/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.math.MathEx;

public class ShepardInterpolation {
    private final double[][] x;
    private final double[] y;
    private final double p;

    public ShepardInterpolation(double[][] x, double[] y) {
        this(x, y, 2.0);
    }

    public ShepardInterpolation(double[][] x, double[] y, double p) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        if (p <= 0.0) {
            throw new IllegalArgumentException("Invalid p = " + p);
        }
        this.x = x;
        this.y = y;
        this.p = -p;
    }

    public double interpolate(double ... x) {
        if (x.length != this.x[0].length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.x[0].length));
        }
        double weight = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.x.length; ++i) {
            double r = MathEx.squaredDistance(x, this.x[i]);
            if (r == 0.0) {
                return this.y[i];
            }
            double w = Math.pow(r, this.p / 2.0);
            weight += w;
            sum += w * this.y[i];
        }
        return sum / weight;
    }

    public String toString() {
        return String.format("Shepard Interpolation(p = %.4f)", -this.p);
    }
}

