/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation;
import smile.linalg.UPLO;
import smile.math.rbf.GaussianRadialBasis;
import smile.math.rbf.RadialBasisFunction;
import smile.tensor.Cholesky;
import smile.tensor.DenseMatrix;
import smile.tensor.LU;
import smile.tensor.ScalarType;

public class RBFInterpolation1D
implements Interpolation {
    private final double[] x;
    private final double[] w;
    private final RadialBasisFunction rbf;
    private final boolean normalized;

    public RBFInterpolation1D(double[] x, double[] y, RadialBasisFunction rbf) {
        this(x, y, rbf, false);
    }

    public RBFInterpolation1D(double[] x, double[] y, RadialBasisFunction rbf, boolean normalized) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        this.x = x;
        this.rbf = rbf;
        this.normalized = normalized;
        int n = x.length;
        DenseMatrix G = DenseMatrix.zeros(ScalarType.Float64, n, n);
        double[] rhs = new double[n];
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j <= i; ++j) {
                double r = rbf.f(Math.abs(x[i] - x[j]));
                G.set(i, j, r);
                G.set(j, i, r);
                sum += 2.0 * r;
            }
            rhs[i] = normalized ? sum * y[i] : y[i];
        }
        if (rbf instanceof GaussianRadialBasis) {
            G.withUplo(UPLO.LOWER);
            Cholesky cholesky = G.cholesky();
            cholesky.solve(rhs);
        } else {
            LU lu = G.lu();
            lu.solve(rhs);
        }
        this.w = rhs;
    }

    @Override
    public double interpolate(double x) {
        double sum = 0.0;
        double sumw = 0.0;
        for (int i = 0; i < this.x.length; ++i) {
            double f = this.rbf.f(Math.abs(x - this.x[i]));
            sumw += this.w[i] * f;
            sum += f;
        }
        return this.normalized ? sumw / sum : sumw;
    }

    public String toString() {
        return String.format("RBF Interpolation(%s)", this.rbf);
    }
}

