/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.io.Paths;
import smile.io.Read;

public record PenDigits(DataFrame data, Formula formula) {
    public PenDigits() throws IOException {
        this(Paths.getTestData("classification/pendigits.txt"));
    }

    public PenDigits(Path path) throws IOException {
        this(PenDigits.load(path), Formula.lhs("class"));
    }

    private static DataFrame load(Path path) throws IOException {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        IntStream.range(1, 17).forEach(i -> fields.add(new StructField("V" + i, DataTypes.DoubleType)));
        fields.add(new StructField("class", DataTypes.ByteType));
        StructType schema = new StructType(fields);
        CSVFormat format = CSVFormat.Builder.create().setDelimiter('\t').get();
        return Read.csv(path, format, schema);
    }

    public double[][] x() {
        return this.formula.x(this.data).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public int[] y() {
        return this.formula.y(this.data).toIntArray();
    }
}

