/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import smile.data.type.StructField;
import smile.data.vector.AbstractVector;
import smile.math.MathEx;

public abstract class NullablePrimitiveVector
extends AbstractVector {
    BitSet nullMask;

    public NullablePrimitiveVector(StructField field, BitSet nullMask) {
        super(field);
        this.nullMask = nullMask;
    }

    public double mean() {
        return this.doubleStream().filter(Double::isFinite).average().orElse(0.0);
    }

    public double stdev() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.stdev(data);
    }

    public double min() {
        return this.doubleStream().filter(Double::isFinite).min().orElse(0.0);
    }

    public double max() {
        return this.doubleStream().filter(Double::isFinite).max().orElse(0.0);
    }

    public double median() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.median(data);
    }

    public double q1() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.q1(data);
    }

    public double q3() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.q3(data);
    }

    public void fillna(double value) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.isNullAt(i)) continue;
            this.set(i, value);
        }
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isNullAt(int i) {
        return this.nullMask.get(i);
    }

    @Override
    public int getNullCount() {
        return this.nullMask.cardinality();
    }

    public void setNullMask(BitSet mask) {
        this.nullMask = mask;
    }

    public BitSet getNullMask() {
        return this.nullMask;
    }
}

