/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.DoubleStream;
import smile.data.measure.CategoricalMeasure;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.PrimitiveVector;
import smile.math.MathEx;
import smile.util.Index;

public class FloatVector
extends PrimitiveVector {
    private final float[] vector;

    public FloatVector(String name, float[] vector) {
        this(new StructField(name, DataTypes.FloatType), vector);
    }

    public FloatVector(StructField field, float[] vector) {
        if (field.dtype() != DataTypes.FloatType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        if (field.measure() instanceof CategoricalMeasure) {
            throw new IllegalArgumentException("Invalid measure: " + String.valueOf(field.measure()));
        }
        super(field);
        this.vector = vector;
    }

    public void fillna(float value) {
        for (int i = 0; i < this.vector.length; ++i) {
            if (!Float.isNaN(this.vector[i]) && !Float.isInfinite(this.vector[i])) continue;
            this.vector[i] = value;
        }
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public FloatVector withName(String name) {
        return new FloatVector(this.field.withName(name), this.vector);
    }

    @Override
    public DoubleStream doubleStream() {
        return this.index().mapToDouble(i -> this.vector[i]);
    }

    @Override
    public void set(int i, Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        Number n = (Number)value;
        this.vector[i] = n.floatValue();
    }

    @Override
    public FloatVector get(Index index) {
        int n = index.size();
        float[] data = new float[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.vector[index.apply(i)];
        }
        return new FloatVector(this.field, data);
    }

    @Override
    public boolean isNullAt(int i) {
        return Float.isNaN(this.vector[i]);
    }

    @Override
    public Float get(int i) {
        return Float.valueOf(this.vector[i]);
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return MathEx.isZero(this.vector[i]);
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return (int)this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return (long)this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

