/*
 * Decompiled with CFR 0.152.
 */
package smile.data.measure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import smile.data.measure.Measure;
import smile.data.type.DataType;
import smile.data.type.DataTypes;

public abstract class CategoricalMeasure
implements Measure {
    final int[] values;
    final String[] levels;
    final Map<Number, String> value2level;
    final Map<String, Number> level2value;
    final boolean factor;

    public CategoricalMeasure(String ... levels) {
        this(IntStream.range(0, levels.length).toArray(), levels);
    }

    public CategoricalMeasure(List<String> levels) {
        this(levels.toArray(new String[0]));
    }

    public CategoricalMeasure(int[] values) {
        this(values, (String[])Arrays.stream(values).mapToObj(Integer::toString).toArray(String[]::new));
    }

    public CategoricalMeasure(int[] values, String[] levels) {
        if (values.length != levels.length) {
            throw new IllegalArgumentException("The size of values and levels don't match");
        }
        this.values = values;
        this.levels = levels;
        this.value2level = new HashMap<Number, String>();
        this.level2value = new HashMap<String, Number>();
        if (levels.length <= 128) {
            for (i = 0; i < values.length; ++i) {
                this.value2level.put(values[i], levels[i]);
                this.level2value.put(levels[i], (byte)values[i]);
            }
        } else if (levels.length <= 32768) {
            for (i = 0; i < values.length; ++i) {
                this.value2level.put(values[i], levels[i]);
                this.level2value.put(levels[i], (short)values[i]);
            }
        } else {
            for (i = 0; i < values.length; ++i) {
                this.value2level.put(values[i], levels[i]);
                this.level2value.put(levels[i], values[i]);
            }
        }
        boolean factor = true;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == i) continue;
            factor = false;
            break;
        }
        this.factor = factor;
    }

    static int[] values(Class<? extends Enum<?>> clazz) {
        return Arrays.stream(clazz.getEnumConstants()).mapToInt(Enum::ordinal).toArray();
    }

    static String[] levels(Class<? extends Enum<?>> clazz) {
        return (String[])Arrays.stream(clazz.getEnumConstants()).map(Object::toString).toArray(String[]::new);
    }

    public int size() {
        return this.levels.length;
    }

    public int[] values() {
        return this.values;
    }

    public String[] levels() {
        return this.levels;
    }

    public String level(int value) {
        return this.value2level.get(value);
    }

    public int factor(int value) {
        if (this.factor) {
            return value;
        }
        for (int j = 0; j < this.values.length; ++j) {
            if (this.values[j] != value) continue;
            return j;
        }
        throw new IllegalArgumentException("Invalid level: " + value);
    }

    public DataType type() {
        if (this.levels.length <= 128) {
            return DataTypes.ByteType;
        }
        if (this.levels.length <= 32768) {
            return DataTypes.ShortType;
        }
        return DataTypes.IntType;
    }

    public String toString(int value) {
        return this.level(value);
    }

    @Override
    public String toString(Object o) {
        return this.level(((Number)o).intValue());
    }

    @Override
    public Number valueOf(String s) {
        return this.level2value.get(s);
    }

    public boolean equals(Object o) {
        if (o instanceof CategoricalMeasure) {
            CategoricalMeasure measure = (CategoricalMeasure)o;
            return Arrays.equals(this.levels, measure.levels) && Arrays.equals(this.values, measure.values);
        }
        return false;
    }
}

