/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Round
extends AbstractFunction {
    public Round(Term x) {
        super("round", x);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final Feature feature : this.x.bind(schema)) {
            final StructField xfield = feature.field();
            DataType type = xfield.dtype();
            if (!type.isDouble() && !type.isFloat()) {
                throw new IllegalStateException(String.format("Invalid expression: round(%s)", type));
            }
            features.add(new Feature(){
                final StructField field;
                {
                    Objects.requireNonNull(this$0);
                    this.field = new StructField(String.format("round(%s)", xfield.name()), xfield.dtype(), xfield.measure());
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Object apply(Tuple o) {
                    Object y;
                    Object object = y = feature.apply(o);
                    int n = 0;
                    return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Float.class}, (Object)object, n)) {
                        case -1 -> null;
                        case 0 -> {
                            Double v = (Double)object;
                            yield Math.round(v);
                        }
                        case 1 -> {
                            Float v = (Float)object;
                            yield Float.valueOf(Math.abs(v.floatValue()));
                        }
                        default -> throw new IllegalArgumentException("Invalid argument for abs(): " + String.valueOf(y));
                    };
                }

                @Override
                public float applyAsFloat(Tuple o) {
                    return Math.round(feature.applyAsFloat(o));
                }

                @Override
                public double applyAsDouble(Tuple o) {
                    return Math.round(feature.applyAsDouble(o));
                }
            });
        }
        return features;
    }
}

