/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SampleInstance;
import smile.data.SimpleDataset;
import smile.data.Tuple;
import smile.data.measure.NominalScale;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class BinarySparseSequenceDataset
extends SimpleDataset<int[][], int[]> {
    private static final Logger logger = LoggerFactory.getLogger(BinarySparseSequenceDataset.class);
    private final int p;
    private final int k;
    private final Tuple[][] seq;
    private final int[][] tag;

    public BinarySparseSequenceDataset(int p, int k, List<SampleInstance<int[][], int[]>> data) {
        super(data);
        this.p = p;
        this.k = k;
        int length = ((int[][])data.getFirst().x())[0].length;
        int[] base = new int[length];
        StructType schema = new StructType((StructField[])IntStream.range(0, length).mapToObj(i -> {
            int[] values = data.stream().flatMapToInt(instance -> Arrays.stream((int[][])instance.x()).mapToInt(xj -> xj[i])).distinct().toArray();
            Arrays.sort(values);
            base[i] = values[0];
            NominalScale scale = new NominalScale((String[])IntStream.range(0, values.length).mapToObj(String::valueOf).toArray(String[]::new));
            return new StructField("V" + (i + 1), DataTypes.IntType, scale);
        }).toArray(StructField[]::new));
        int n = data.size();
        this.seq = new Tuple[n][];
        this.tag = new int[n][];
        for (int i2 = 0; i2 < n; ++i2) {
            int[][] xi = (int[][])data.get(i2).x();
            this.tag[i2] = (int[])data.get(i2).y();
            this.seq[i2] = new Tuple[xi.length];
            for (int j = 0; j < xi.length; ++j) {
                this.seq[i2][j] = BinarySparseSequenceDataset.tuple(schema, xi[j], base);
            }
        }
    }

    public int p() {
        return this.p;
    }

    public int k() {
        return this.k;
    }

    public Tuple[][] seq() {
        return this.seq;
    }

    public int[][] tag() {
        return this.tag;
    }

    public int[][] x() {
        return (int[][])this.instances.stream().map(SampleInstance::x).flatMap(Arrays::stream).toArray(x$0 -> new int[x$0][]);
    }

    public int[] y() {
        return this.instances.stream().map(SampleInstance::y).flatMapToInt(Arrays::stream).toArray();
    }

    public static BinarySparseSequenceDataset load(Path path) throws IOException {
        try (BufferedReader input = Files.newBufferedReader(path);){
            String line;
            ArrayList<SampleInstance<int[][], int[]>> instances = new ArrayList<SampleInstance<int[][], int[]>>();
            ArrayList<int[]> seq = new ArrayList<int[]>();
            ArrayList<Integer> tag = new ArrayList<Integer>();
            int currentSeqID = 0;
            String[] words = input.readLine().split(" ");
            int size = Integer.parseInt(words[0]);
            int k = Integer.parseInt(words[1]);
            int p = Integer.parseInt(words[2]);
            logger.info("Loading {} sequences, {} classes, {} features", new Object[]{size, k, p});
            while ((line = input.readLine()) != null) {
                words = line.split(" ");
                int seqID = Integer.parseInt(words[0]);
                int pos = Integer.parseInt(words[1]);
                int len = Integer.parseInt(words[2]);
                int[] feature = new int[len];
                for (int i = 0; i < len; ++i) {
                    feature[i] = Integer.parseInt(words[i + 3]);
                }
                if (seqID != currentSeqID) {
                    currentSeqID = seqID;
                    if (!seq.isEmpty()) {
                        int[][] x = (int[][])seq.toArray((T[])new int[seq.size()][]);
                        int[] y = tag.stream().mapToInt(yi -> yi).toArray();
                        SampleInstance<int[][], int[]> instance = new SampleInstance<int[][], int[]>(x, y);
                        instances.add(instance);
                        seq.clear();
                        tag.clear();
                    }
                }
                seq.add(feature);
                tag.add(Integer.valueOf(words[len + 3]));
            }
            int[][] x = (int[][])seq.toArray((T[])new int[seq.size()][]);
            int[] y = tag.stream().mapToInt(yi -> yi).toArray();
            SampleInstance<int[][], int[]> instance = new SampleInstance<int[][], int[]>(x, y);
            instances.add(instance);
            BinarySparseSequenceDataset binarySparseSequenceDataset = new BinarySparseSequenceDataset(p, k, instances);
            return binarySparseSequenceDataset;
        }
    }

    private static Tuple tuple(final StructType schema, int[] x, int[] base) {
        int n = x.length;
        final int[] data = new int[n];
        for (int i = 0; i < n; ++i) {
            data[i] = x[i] - base[i];
        }
        return new Tuple(){

            @Override
            public StructType schema() {
                return schema;
            }

            @Override
            public Object get(int j) {
                return data[j];
            }

            @Override
            public int getInt(int j) {
                return data[j];
            }

            public String toString() {
                return Arrays.toString(data);
            }
        };
    }
}

