/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SampleInstance;
import smile.data.SimpleDataset;
import smile.math.MathEx;
import smile.tensor.SparseMatrix;

public class BinarySparseDataset<T>
extends SimpleDataset<int[], T> {
    private static final Logger logger = LoggerFactory.getLogger(BinarySparseDataset.class);
    private int n;
    private final int ncol;
    private final int[] colSize;

    public BinarySparseDataset(Collection<SampleInstance<int[], T>> data) {
        super(data);
        int p = 0;
        for (SampleInstance instance : this.instances) {
            p = Math.max(p, MathEx.max((int[])instance.x()));
        }
        this.ncol = p + 1;
        this.colSize = new int[this.ncol];
        for (SampleInstance instance : this.instances) {
            int[] x = (int[])instance.x();
            Arrays.sort(x);
            int prev = -1;
            for (int xi : x) {
                if (xi < 0) {
                    throw new IllegalArgumentException(String.format("Negative index of nonzero element: %d", xi));
                }
                if (xi == prev) {
                    logger.warn("Ignore duplicated indices: {} in {}", (Object)xi, (Object)Arrays.toString(x));
                    continue;
                }
                int n = xi;
                this.colSize[n] = this.colSize[n] + 1;
                ++this.n;
                prev = xi;
            }
        }
    }

    public int length() {
        return this.n;
    }

    public int ncol() {
        return this.ncol;
    }

    public int get(int i, int j) {
        if (i < 0 || i >= this.size()) {
            throw new IllegalArgumentException("Invalid index: i = " + i);
        }
        int[] x = (int[])this.get(i).x();
        if (x.length == 0) {
            return 0;
        }
        int low = 0;
        int high = x.length - 1;
        int mid = (low + high) / 2;
        while (j != x[mid] && low <= high) {
            mid = (low + high) / 2;
            if (j < x[mid]) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (j == x[mid]) {
            return 1;
        }
        return 0;
    }

    public SparseMatrix toMatrix() {
        int[] pos = new int[this.ncol];
        int[] colIndex = new int[this.ncol + 1];
        for (int i = 0; i < this.ncol; ++i) {
            colIndex[i + 1] = colIndex[i] + this.colSize[i];
        }
        int nrow = this.instances.size();
        int[] rowIndex = new int[this.n];
        double[] x = new double[this.n];
        for (int i = 0; i < nrow; ++i) {
            for (int j : (int[])((SampleInstance)this.instances.get(i)).x()) {
                int k = colIndex[j] + pos[j];
                rowIndex[k] = i;
                x[k] = 1.0;
                int n = j;
                pos[n] = pos[n] + 1;
            }
        }
        return new SparseMatrix(nrow, this.ncol, x, rowIndex, colIndex);
    }

    public static BinarySparseDataset<Void> of(int[][] data) {
        return new BinarySparseDataset<Void>(Arrays.stream(data).map(x -> new SampleInstance<int[], Object>((int[])x, null)).toList());
    }

    public static BinarySparseDataset<Void> from(Path path) throws IOException, NumberFormatException {
        try (Stream<String> stream = Files.lines(path);){
            List rows = stream.map(line -> {
                String[] s = line.split("\\s+");
                int[] index = new int[s.length];
                for (int i = 0; i < s.length; ++i) {
                    index[i] = Integer.parseInt(s[i]);
                }
                return new SampleInstance<int[], Object>(index, null);
            }).toList();
            BinarySparseDataset<Void> binarySparseDataset = new BinarySparseDataset<Void>(rows);
            return binarySparseDataset;
        }
    }
}

