/* Copyright 2013 Samuel Halliday (generated Java and C).
 * Copyright 2003-2007 Keith Seymour (Fortran to Java translation).
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 *
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <jni.h>
#include <netlib-jni.h>
#include <arpack.h>
#include <com_github_fommil_netlib_NativeRefARPACK.h>

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dnaupd (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jdoublew tol, jdoubleArray resid, jint ncv, jdoubleArray v, jint ldv, jintArray iparam, jintArray ipntr, jdoubleArray workd, jdoubleArray workl, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "D");
  jdouble jni_tol = (*env)->GetDoubleField(env, tol, jni_tolId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dnaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetDoubleField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dnaupd_1offsets (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jdoublew tol, jdoubleArray resid, jint _resid_offset, jint ncv, jdoubleArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jdoubleArray workd, jint _workd_offset, jdoubleArray workl, jint _workl_offset, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "D");
  jdouble jni_tol = (*env)->GetDoubleField(env, tol, jni_tolId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dnaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetDoubleField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dneupd (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jdoubleArray dr, jdoubleArray di, jdoubleArray z, jint ldz, jdouble sigmar, jdouble sigmai, jdoubleArray workev, jstring bmat, jint n, jstring which, jintw nev, jdouble tol, jdoubleArray resid, jint ncv, jdoubleArray v, jint ldv, jintArray iparam, jintArray ipntr, jdoubleArray workd, jdoubleArray workl, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_dr = NULL;
  if (dr != NULL) {
    jni_dr = (*env)->GetPrimitiveArrayCritical(env, dr, JNI_FALSE);
    check_memory(env, jni_dr);
  }
  jdouble * jni_di = NULL;
  if (di != NULL) {
    jni_di = (*env)->GetPrimitiveArrayCritical(env, di, JNI_FALSE);
    check_memory(env, jni_di);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_workev = NULL;
  if (workev != NULL) {
    jni_workev = (*env)->GetPrimitiveArrayCritical(env, workev, JNI_FALSE);
    check_memory(env, jni_workev);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dneupd_(&jni_rvec, jni_howmny, jni_select, jni_dr, jni_di, jni_z, &ldz, &sigmar, &sigmai, jni_workev, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (workev != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workev, jni_workev, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (di != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, di, jni_di, 0);
  }
  if (dr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dr, jni_dr, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dneupd_1offsets (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jint _select_offset, jdoubleArray dr, jint _dr_offset, jdoubleArray di, jint _di_offset, jdoubleArray z, jint _z_offset, jint ldz, jdouble sigmar, jdouble sigmai, jdoubleArray workev, jint _workev_offset, jstring bmat, jint n, jstring which, jintw nev, jdouble tol, jdoubleArray resid, jint _resid_offset, jint ncv, jdoubleArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jdoubleArray workd, jint _workd_offset, jdoubleArray workl, jint _workl_offset, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_dr = NULL;
  if (dr != NULL) {
    jni_dr = (*env)->GetPrimitiveArrayCritical(env, dr, JNI_FALSE);
    check_memory(env, jni_dr);
  }
  jdouble * jni_di = NULL;
  if (di != NULL) {
    jni_di = (*env)->GetPrimitiveArrayCritical(env, di, JNI_FALSE);
    check_memory(env, jni_di);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jdouble * jni_workev = NULL;
  if (workev != NULL) {
    jni_workev = (*env)->GetPrimitiveArrayCritical(env, workev, JNI_FALSE);
    check_memory(env, jni_workev);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dneupd_(&jni_rvec, jni_howmny, jni_select + _select_offset, jni_dr + _dr_offset, jni_di + _di_offset, jni_z + _z_offset, &ldz, &sigmar, &sigmai, jni_workev + _workev_offset, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (workev != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workev, jni_workev, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (di != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, di, jni_di, 0);
  }
  if (dr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dr, jni_dr, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dsaupd (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jdoublew tol, jdoubleArray resid, jint ncv, jdoubleArray v, jint ldv, jintArray iparam, jintArray ipntr, jdoubleArray workd, jdoubleArray workl, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "D");
  jdouble jni_tol = (*env)->GetDoubleField(env, tol, jni_tolId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dsaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetDoubleField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dsaupd_1offsets (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jdoublew tol, jdoubleArray resid, jint _resid_offset, jint ncv, jdoubleArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jdoubleArray workd, jint _workd_offset, jdoubleArray workl, jint _workl_offset, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "D");
  jdouble jni_tol = (*env)->GetDoubleField(env, tol, jni_tolId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dsaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetDoubleField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dseupd (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jdoubleArray d, jdoubleArray z, jint ldz, jdouble sigma, jstring bmat, jint n, jstring which, jintw nev, jdouble tol, jdoubleArray resid, jint ncv, jdoubleArray v, jint ldv, jintArray iparam, jintArray ipntr, jdoubleArray workd, jdoubleArray workl, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dseupd_(&jni_rvec, jni_howmny, jni_select, jni_d, jni_z, &ldz, &sigma, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_dseupd_1offsets (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jint _select_offset, jdoubleArray d, jint _d_offset, jdoubleArray z, jint _z_offset, jint ldz, jdouble sigma, jstring bmat, jint n, jstring which, jintw nev, jdouble tol, jdoubleArray resid, jint _resid_offset, jint ncv, jdoubleArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jdoubleArray workd, jint _workd_offset, jdoubleArray workl, jint _workl_offset, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jdouble * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jdouble * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jdouble * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jdouble * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jdouble * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jdouble * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
dseupd_(&jni_rvec, jni_howmny, jni_select + _select_offset, jni_d + _d_offset, jni_z + _z_offset, &ldz, &sigma, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_snaupd (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jfloatw tol, jfloatArray resid, jint ncv, jfloatArray v, jint ldv, jintArray iparam, jintArray ipntr, jfloatArray workd, jfloatArray workl, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "F");
  jfloat jni_tol = (*env)->GetFloatField(env, tol, jni_tolId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
snaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetFloatField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_snaupd_1offsets (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jfloatw tol, jfloatArray resid, jint _resid_offset, jint ncv, jfloatArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jfloatArray workd, jint _workd_offset, jfloatArray workl, jint _workl_offset, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "F");
  jfloat jni_tol = (*env)->GetFloatField(env, tol, jni_tolId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
snaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetFloatField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_sneupd (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jfloatArray dr, jfloatArray di, jfloatArray z, jint ldz, jfloat sigmar, jfloat sigmai, jfloatArray workev, jstring bmat, jint n, jstring which, jintw nev, jfloat tol, jfloatArray resid, jint ncv, jfloatArray v, jint ldv, jintArray iparam, jintArray ipntr, jfloatArray workd, jfloatArray workl, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jfloat * jni_dr = NULL;
  if (dr != NULL) {
    jni_dr = (*env)->GetPrimitiveArrayCritical(env, dr, JNI_FALSE);
    check_memory(env, jni_dr);
  }
  jfloat * jni_di = NULL;
  if (di != NULL) {
    jni_di = (*env)->GetPrimitiveArrayCritical(env, di, JNI_FALSE);
    check_memory(env, jni_di);
  }
  jfloat * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jfloat * jni_workev = NULL;
  if (workev != NULL) {
    jni_workev = (*env)->GetPrimitiveArrayCritical(env, workev, JNI_FALSE);
    check_memory(env, jni_workev);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
sneupd_(&jni_rvec, jni_howmny, jni_select, jni_dr, jni_di, jni_z, &ldz, &sigmar, &sigmai, jni_workev, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (workev != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workev, jni_workev, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (di != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, di, jni_di, 0);
  }
  if (dr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dr, jni_dr, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_sneupd_1offsets (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jint _select_offset, jfloatArray dr, jint _dr_offset, jfloatArray di, jint _di_offset, jfloatArray z, jint _z_offset, jint ldz, jfloat sigmar, jfloat sigmai, jfloatArray workev, jint _workev_offset, jstring bmat, jint n, jstring which, jintw nev, jfloat tol, jfloatArray resid, jint _resid_offset, jint ncv, jfloatArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jfloatArray workd, jint _workd_offset, jfloatArray workl, jint _workl_offset, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jfloat * jni_dr = NULL;
  if (dr != NULL) {
    jni_dr = (*env)->GetPrimitiveArrayCritical(env, dr, JNI_FALSE);
    check_memory(env, jni_dr);
  }
  jfloat * jni_di = NULL;
  if (di != NULL) {
    jni_di = (*env)->GetPrimitiveArrayCritical(env, di, JNI_FALSE);
    check_memory(env, jni_di);
  }
  jfloat * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  jfloat * jni_workev = NULL;
  if (workev != NULL) {
    jni_workev = (*env)->GetPrimitiveArrayCritical(env, workev, JNI_FALSE);
    check_memory(env, jni_workev);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
sneupd_(&jni_rvec, jni_howmny, jni_select + _select_offset, jni_dr + _dr_offset, jni_di + _di_offset, jni_z + _z_offset, &ldz, &sigmar, &sigmai, jni_workev + _workev_offset, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (workev != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workev, jni_workev, 0);
  }
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (di != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, di, jni_di, 0);
  }
  if (dr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, dr, jni_dr, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_ssaupd (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jfloatw tol, jfloatArray resid, jint ncv, jfloatArray v, jint ldv, jintArray iparam, jintArray ipntr, jfloatArray workd, jfloatArray workl, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "F");
  jfloat jni_tol = (*env)->GetFloatField(env, tol, jni_tolId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
ssaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetFloatField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_ssaupd_1offsets (JNIEnv * env, jobject calling_obj, jintw ido, jstring bmat, jint n, jstring which, jint nev, jfloatw tol, jfloatArray resid, jint _resid_offset, jint ncv, jfloatArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jfloatArray workd, jint _workd_offset, jfloatArray workl, jint _workl_offset, jint lworkl, jintw info) {
  jclass jni_idoClass = (*env)->GetObjectClass(env, ido);
  jfieldID jni_idoId = (*env)->GetFieldID(env, jni_idoClass, "val", "I");
  jint jni_ido = (*env)->GetIntField(env, ido, jni_idoId);
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
  jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "F");
  jfloat jni_tol = (*env)->GetFloatField(env, tol, jni_tolId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
ssaupd_(&jni_ido, jni_bmat, &n, jni_which, &nev, &jni_tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetFloatField(env, tol, jni_tolId, jni_tol);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  (*env)->SetIntField(env, ido, jni_idoId, jni_ido);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_sseupd (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jfloatArray d, jfloatArray z, jint ldz, jfloat sigma, jstring bmat, jint n, jstring which, jintw nev, jfloat tol, jfloatArray resid, jint ncv, jfloatArray v, jint ldv, jintArray iparam, jintArray ipntr, jfloatArray workd, jfloatArray workl, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
sseupd_(&jni_rvec, jni_howmny, jni_select, jni_d, jni_z, &ldz, &sigma, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid, &ncv, jni_v, &ldv, jni_iparam, jni_ipntr, jni_workd, jni_workl, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}

JNIEXPORT void JNICALL Java_com_github_fommil_netlib_NativeRefARPACK_sseupd_1offsets (JNIEnv * env, jobject calling_obj, jboolean rvec, jstring howmny, jbooleanArray select, jint _select_offset, jfloatArray d, jint _d_offset, jfloatArray z, jint _z_offset, jint ldz, jfloat sigma, jstring bmat, jint n, jstring which, jintw nev, jfloat tol, jfloatArray resid, jint _resid_offset, jint ncv, jfloatArray v, jint _v_offset, jint ldv, jintArray iparam, jint _iparam_offset, jintArray ipntr, jint _ipntr_offset, jfloatArray workd, jint _workd_offset, jfloatArray workl, jint _workl_offset, jint lworkl, jintw info) {
  int jni_rvec = jboolean2int(rvec);
  char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
  jboolean * jni_select_raw = NULL;
  jint jni_select_size = 0;
  int* jni_select = NULL;
  if (select != NULL) {
    jni_select_raw = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
    check_memory(env, jni_select_raw);
    jni_select_size = (*env)->GetArrayLength(env, select);
    jni_select = jbooleanArray2intArray(env, jni_select_raw, jni_select_size);
  }
  jfloat * jni_d = NULL;
  if (d != NULL) {
    jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
    check_memory(env, jni_d);
  }
  jfloat * jni_z = NULL;
  if (z != NULL) {
    jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
    check_memory(env, jni_z);
  }
  char * jni_bmat = (char *)(*env)->GetStringUTFChars(env, bmat, JNI_FALSE);
  char * jni_which = (char *)(*env)->GetStringUTFChars(env, which, JNI_FALSE);
  jclass jni_nevClass = (*env)->GetObjectClass(env, nev);
  jfieldID jni_nevId = (*env)->GetFieldID(env, jni_nevClass, "val", "I");
  jint jni_nev = (*env)->GetIntField(env, nev, jni_nevId);
  jfloat * jni_resid = NULL;
  if (resid != NULL) {
    jni_resid = (*env)->GetPrimitiveArrayCritical(env, resid, JNI_FALSE);
    check_memory(env, jni_resid);
  }
  jfloat * jni_v = NULL;
  if (v != NULL) {
    jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
    check_memory(env, jni_v);
  }
  jint * jni_iparam = NULL;
  if (iparam != NULL) {
    jni_iparam = (*env)->GetPrimitiveArrayCritical(env, iparam, JNI_FALSE);
    check_memory(env, jni_iparam);
  }
  jint * jni_ipntr = NULL;
  if (ipntr != NULL) {
    jni_ipntr = (*env)->GetPrimitiveArrayCritical(env, ipntr, JNI_FALSE);
    check_memory(env, jni_ipntr);
  }
  jfloat * jni_workd = NULL;
  if (workd != NULL) {
    jni_workd = (*env)->GetPrimitiveArrayCritical(env, workd, JNI_FALSE);
    check_memory(env, jni_workd);
  }
  jfloat * jni_workl = NULL;
  if (workl != NULL) {
    jni_workl = (*env)->GetPrimitiveArrayCritical(env, workl, JNI_FALSE);
    check_memory(env, jni_workl);
  }
  jclass jni_infoClass = (*env)->GetObjectClass(env, info);
  jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
  jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
sseupd_(&jni_rvec, jni_howmny, jni_select + _select_offset, jni_d + _d_offset, jni_z + _z_offset, &ldz, &sigma, jni_bmat, &n, jni_which, &jni_nev, &tol, jni_resid + _resid_offset, &ncv, jni_v + _v_offset, &ldv, jni_iparam + _iparam_offset, jni_ipntr + _ipntr_offset, jni_workd + _workd_offset, jni_workl + _workl_offset, &lworkl, &jni_info);
  (*env)->SetIntField(env, info, jni_infoId, jni_info);
  if (workl != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workl, jni_workl, 0);
  }
  if (workd != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, workd, jni_workd, 0);
  }
  if (ipntr != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, ipntr, jni_ipntr, 0);
  }
  if (iparam != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, iparam, jni_iparam, 0);
  }
  if (v != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
  }
  if (resid != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, resid, jni_resid, 0);
  }
  (*env)->SetIntField(env, nev, jni_nevId, jni_nev);
  (*env)->ReleaseStringUTFChars(env, which, jni_which);
  (*env)->ReleaseStringUTFChars(env, bmat, jni_bmat);
  if (z != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
  }
  if (d != NULL) {
    (*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
  }
  if (select != NULL) {
    intArray2jbooleanArray(jni_select, jni_select_raw, jni_select_size);
    free(jni_select);
    (*env)->ReleasePrimitiveArrayCritical(env, select, jni_select_raw, 0);
  }
  (*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
}