/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.dot.style;

import com.google.common.base.Joiner;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class StyleKey {
    private static final int NUM_ELEMENTS = 7;
    private final String groupId;
    private final String artifactId;
    private final String scope;
    private final String type;
    private final String version;
    private final String classifier;
    private final String optional;

    private StyleKey(String[] parts) {
        int i;
        if (parts.length > 7) {
            throw new IllegalArgumentException("Too many parts. Expecting '<groupId>:<artifactId>:<version>:<scope>:<type>:<classifier>:<true|false>'");
        }
        String[] expanded = new String[7];
        for (i = 0; i < expanded.length; ++i) {
            expanded[i] = "";
        }
        for (i = 0; i < parts.length; ++i) {
            expanded[i] = (String)StringUtils.defaultIfEmpty((CharSequence)parts[i], (CharSequence)"");
        }
        this.groupId = expanded[0];
        this.artifactId = expanded[1];
        this.scope = expanded[2];
        this.type = expanded[3];
        this.version = expanded[4];
        this.classifier = expanded[5];
        this.optional = expanded[6];
    }

    public static StyleKey fromString(String keyString) {
        String[] parts = keyString.split(",");
        return new StyleKey(parts);
    }

    public static StyleKey create(String groupId, String artifactId, String scope, String type, String version, String classifier, Boolean isOptional) {
        return new StyleKey(new String[]{groupId, artifactId, scope, type, version, classifier, isOptional != null ? isOptional.toString() : null});
    }

    public boolean matches(StyleKey other) {
        return StyleKey.wildcardMatch(this.groupId, other.groupId) && StyleKey.wildcardMatch(this.artifactId, other.artifactId) && StyleKey.match(this.scope, other.scope) && StyleKey.match(this.type, other.type) && StyleKey.wildcardMatch(this.version, other.version) && StyleKey.wildcardMatch(this.classifier, other.classifier) && StyleKey.match(this.optional, other.optional);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StyleKey)) {
            return false;
        }
        StyleKey other = (StyleKey)obj;
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.scope, other.scope) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.optional, other.optional);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.scope, this.type, this.version, this.classifier, this.optional);
    }

    public String toString() {
        return Joiner.on((String)",").join((Object)this.groupId, (Object)this.artifactId, new Object[]{this.scope, this.type, this.version, this.classifier, this.optional});
    }

    private static boolean wildcardMatch(String value1, String value2) {
        if (StringUtils.endsWith((CharSequence)value1, (CharSequence)"*")) {
            return StringUtils.startsWith((CharSequence)value2, (CharSequence)value1.substring(0, value1.length() - 1));
        }
        return StyleKey.match(value1, value2);
    }

    private static boolean match(String value1, String value2) {
        return value1.isEmpty() || value1.equals(value2);
    }
}

