/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.AutoDisposableWindowsPrincipal;
import waffle.servlet.NegotiateRequestWrapper;
import waffle.servlet.WindowsPrincipal;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.servlet.spi.SecurityFilterProviderCollection;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class NegotiateSecurityFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NegotiateSecurityFilter.class);
    private PrincipalFormat principalFormat = PrincipalFormat.FQN;
    private PrincipalFormat roleFormat = PrincipalFormat.FQN;
    private SecurityFilterProviderCollection providers;
    private IWindowsAuthProvider auth;
    private boolean allowGuestLogin = true;
    private boolean impersonate;
    private static final String PRINCIPALSESSIONKEY = NegotiateSecurityFilter.class.getName() + ".PRINCIPAL";

    public NegotiateSecurityFilter() {
        LOGGER.debug("[waffle.servlet.NegotiateSecurityFilter] loaded");
    }

    public void destroy() {
        LOGGER.info("[waffle.servlet.NegotiateSecurityFilter] stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)sreq;
        HttpServletResponse response = (HttpServletResponse)sres;
        LOGGER.debug("{} {}, contentlength: {}", new Object[]{request.getMethod(), request.getRequestURI(), request.getContentLength()});
        if (this.doFilterPrincipal(request, response, chain)) {
            return;
        }
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        if (!authorizationHeader.isNull()) {
            IWindowsIdentity windowsIdentity;
            try {
                windowsIdentity = this.providers.doFilter(request, response);
                if (windowsIdentity == null) {
                    return;
                }
            }
            catch (IOException e) {
                LOGGER.warn("error logging in user: {}", (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                this.sendUnauthorized(response, true);
                return;
            }
            IWindowsImpersonationContext ctx = null;
            try {
                if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
                    LOGGER.warn("guest login disabled: {}", (Object)windowsIdentity.getFqn());
                    this.sendUnauthorized(response, true);
                    return;
                }
                LOGGER.debug("logged in user: {} ({})", (Object)windowsIdentity.getFqn(), (Object)windowsIdentity.getSidString());
                HttpSession session = request.getSession(true);
                if (session == null) {
                    throw new ServletException("Expected HttpSession");
                }
                Subject subject = (Subject)session.getAttribute("javax.security.auth.subject");
                if (subject == null) {
                    subject = new Subject();
                }
                WindowsPrincipal windowsPrincipal = null;
                windowsPrincipal = this.impersonate ? new AutoDisposableWindowsPrincipal(windowsIdentity, this.principalFormat, this.roleFormat) : new WindowsPrincipal(windowsIdentity, this.principalFormat, this.roleFormat);
                LOGGER.debug("roles: {}", (Object)windowsPrincipal.getRolesString());
                subject.getPrincipals().add(windowsPrincipal);
                session.setAttribute("javax.security.auth.subject", (Object)subject);
                LOGGER.info("successfully logged in user: {}", (Object)windowsIdentity.getFqn());
                request.getSession().setAttribute(PRINCIPALSESSIONKEY, (Object)windowsPrincipal);
                NegotiateRequestWrapper requestWrapper = new NegotiateRequestWrapper(request, windowsPrincipal);
                if (this.impersonate) {
                    LOGGER.debug("impersonating user");
                    ctx = windowsIdentity.impersonate();
                }
                chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
            }
            finally {
                if (this.impersonate && ctx != null) {
                    LOGGER.debug("terminating impersonation");
                    ctx.revertToSelf();
                } else {
                    windowsIdentity.dispose();
                }
            }
            return;
        }
        LOGGER.debug("authorization required");
        this.sendUnauthorized(response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFilterPrincipal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        Principal principal = request.getUserPrincipal();
        if (principal == null && (session = request.getSession(false)) != null) {
            principal = (Principal)session.getAttribute(PRINCIPALSESSIONKEY);
        }
        if (principal == null) {
            return false;
        }
        if (this.providers.isPrincipalException(request)) {
            return false;
        }
        if (principal instanceof WindowsPrincipal) {
            LOGGER.debug("previously authenticated Windows user: {}", (Object)principal.getName());
            WindowsPrincipal windowsPrincipal = (WindowsPrincipal)principal;
            if (this.impersonate && windowsPrincipal.getIdentity() == null) {
                return false;
            }
            NegotiateRequestWrapper requestWrapper = new NegotiateRequestWrapper(request, windowsPrincipal);
            IWindowsImpersonationContext ctx = null;
            if (this.impersonate) {
                LOGGER.debug("re-impersonating user");
                ctx = windowsPrincipal.getIdentity().impersonate();
            }
            try {
                chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
            }
            finally {
                if (this.impersonate && ctx != null) {
                    LOGGER.debug("terminating impersonation");
                    ctx.revertToSelf();
                }
            }
        } else {
            LOGGER.debug("previously authenticated user: {}", (Object)principal.getName());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        return true;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        HashMap<String, String> implParameters = new HashMap<String, String>();
        String authProvider = null;
        String[] providerNames = null;
        if (filterConfig != null) {
            Enumeration parameterNames = filterConfig.getInitParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                String parameterValue = filterConfig.getInitParameter(parameterName);
                LOGGER.debug("{}={}", (Object)parameterName, (Object)parameterValue);
                if (parameterName.equals("principalFormat")) {
                    this.principalFormat = PrincipalFormat.valueOf(parameterValue.toUpperCase(Locale.ENGLISH));
                    continue;
                }
                if (parameterName.equals("roleFormat")) {
                    this.roleFormat = PrincipalFormat.valueOf(parameterValue.toUpperCase(Locale.ENGLISH));
                    continue;
                }
                if (parameterName.equals("allowGuestLogin")) {
                    this.allowGuestLogin = Boolean.parseBoolean(parameterValue);
                    continue;
                }
                if (parameterName.equals("impersonate")) {
                    this.impersonate = Boolean.parseBoolean(parameterValue);
                    continue;
                }
                if (parameterName.equals("securityFilterProviders")) {
                    providerNames = parameterValue.split("\\s+");
                    continue;
                }
                if (parameterName.equals("authProvider")) {
                    authProvider = parameterValue;
                    continue;
                }
                implParameters.put(parameterName, parameterValue);
            }
        }
        if (authProvider != null) {
            try {
                this.auth = (IWindowsAuthProvider)Class.forName(authProvider).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("error loading '{}': {}", authProvider, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("error loading '{}': {}", authProvider, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error("error loading '{}': {}", authProvider, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("error loading '{}': {}", authProvider, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("error loading '{}': {}", authProvider, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("error loading '{}': {}", authProvider, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("error loading '{}': {}", authProvider, (Object)e.getMessage());
                LOGGER.trace("{}", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
        if (this.auth == null) {
            this.auth = new WindowsAuthProviderImpl();
        }
        if (providerNames != null) {
            this.providers = new SecurityFilterProviderCollection(providerNames, this.auth);
        }
        if (this.providers == null) {
            LOGGER.debug("initializing default security filter providers");
            this.providers = new SecurityFilterProviderCollection(this.auth);
        }
        for (Map.Entry implParameter : implParameters.entrySet()) {
            String[] classAndParameter = ((String)implParameter.getKey()).split("/", 2);
            if (classAndParameter.length == 2) {
                try {
                    LOGGER.debug("setting {}, {}={}", new Object[]{classAndParameter[0], classAndParameter[1], implParameter.getValue()});
                    SecurityFilterProvider provider = this.providers.getByClassName(classAndParameter[0]);
                    provider.initParameter(classAndParameter[1], (String)implParameter.getValue());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("invalid class: {} in {}", (Object)classAndParameter[0], implParameter.getKey());
                    throw new ServletException((Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error("{}: error setting '{}': {}", new Object[]{classAndParameter[0], classAndParameter[1], e.getMessage()});
                    LOGGER.trace("{}", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            }
            LOGGER.error("Invalid parameter: {}", implParameter.getKey());
            throw new ServletException("Invalid parameter: " + (String)implParameter.getKey());
        }
        LOGGER.info("[waffle.servlet.NegotiateSecurityFilter] started");
    }

    public void setPrincipalFormat(String format) {
        this.principalFormat = PrincipalFormat.valueOf(format.toUpperCase(Locale.ENGLISH));
        LOGGER.info("principal format: {}", (Object)this.principalFormat);
    }

    public PrincipalFormat getPrincipalFormat() {
        return this.principalFormat;
    }

    public void setRoleFormat(String format) {
        this.roleFormat = PrincipalFormat.valueOf(format.toUpperCase(Locale.ENGLISH));
        LOGGER.info("role format: {}", (Object)this.roleFormat);
    }

    public PrincipalFormat getRoleFormat() {
        return this.roleFormat;
    }

    private void sendUnauthorized(HttpServletResponse response, boolean close) {
        try {
            this.providers.sendUnauthorized(response);
            if (close) {
                response.setHeader("Connection", "close");
            } else {
                response.setHeader("Connection", "keep-alive");
            }
            response.sendError(401);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IWindowsAuthProvider getAuth() {
        return this.auth;
    }

    public void setAuth(IWindowsAuthProvider provider) {
        this.auth = provider;
    }

    public boolean isAllowGuestLogin() {
        return this.allowGuestLogin;
    }

    public void setImpersonate(boolean value) {
        this.impersonate = value;
    }

    public boolean isImpersonate() {
        return this.impersonate;
    }

    public SecurityFilterProviderCollection getProviders() {
        return this.providers;
    }
}

