
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzml.jaxb;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * Structure allowing the use of a controlled (cvParam) or uncontrolled vocabulary (userParam), or a
 * reference to a predefined set of these in this mzML file (paramGroupRef).
 *
 * <p>Java class for ParamGroupType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="ParamGroupType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="referenceableParamGroupRef" type="{http://psi.hupo.org/ms/mzml}ReferenceableParamGroupRefType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="cvParam" type="{http://psi.hupo.org/ms/mzml}CVParamType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="userParam" type="{http://psi.hupo.org/ms/mzml}UserParamType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ParamGroupType", propOrder = {
    "referenceableParamGroupRef",
    "cvParam",
    "userParam"
})
@XmlSeeAlso({
    SoftwareType.class,
    RunType.class,
    ScanSettingsType.class,
    SourceFileType.class,
    ScanListType.class,
    ComponentType.class,
    BinaryDataArrayType.class,
    ChromatogramType.class,
    ScanType.class,
    ProcessingMethodType.class,
    SampleType.class,
    SpectrumType.class,
    InstrumentConfigurationType.class
})
public class ParamGroupType {

  protected List<ReferenceableParamGroupRefType> referenceableParamGroupRef;
  protected List<CVParamType> cvParam;
  protected List<UserParamType> userParam;

  /**
   * Gets the value of the referenceableParamGroupRef property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the referenceableParamGroupRef property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getReferenceableParamGroupRef().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link ReferenceableParamGroupRefType
   * }
   */
  public List<ReferenceableParamGroupRefType> getReferenceableParamGroupRef() {
    if (referenceableParamGroupRef == null) {
      referenceableParamGroupRef = new ArrayList<ReferenceableParamGroupRefType>();
    }
    return this.referenceableParamGroupRef;
  }

  /**
   * Gets the value of the cvParam property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the cvParam property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getCvParam().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link CVParamType }
   */
  public List<CVParamType> getCvParam() {
    if (cvParam == null) {
      cvParam = new ArrayList<CVParamType>();
    }
    return this.cvParam;
  }

  /**
   * Gets the value of the userParam property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the userParam property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getUserParam().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link UserParamType }
   */
  public List<UserParamType> getUserParam() {
    if (userParam == null) {
      userParam = new ArrayList<UserParamType>();
    }
    return this.userParam;
  }

}
