
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;


/**
 * Represents bibliographic references.
 *
 * <p>Java class for BibliographicReferenceType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="BibliographicReferenceType">
 *   &lt;complexContent>
 *     &lt;extension base="{http://psidev.info/psi/pi/mzIdentML/1.2}IdentifiableType">
 *       &lt;attribute name="authors" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="publication" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="publisher" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="editor" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="year" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="volume" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="issue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="title" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="doi" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BibliographicReferenceType")
public class BibliographicReferenceType
    extends IdentifiableType {

  @XmlAttribute(name = "authors")
  protected String authors;
  @XmlAttribute(name = "publication")
  protected String publication;
  @XmlAttribute(name = "publisher")
  protected String publisher;
  @XmlAttribute(name = "editor")
  protected String editor;
  @XmlAttribute(name = "year")
  protected Integer year;
  @XmlAttribute(name = "volume")
  protected String volume;
  @XmlAttribute(name = "issue")
  protected String issue;
  @XmlAttribute(name = "pages")
  protected String pages;
  @XmlAttribute(name = "title")
  protected String title;
  @XmlAttribute(name = "doi")
  protected String doi;

  /**
   * Gets the value of the authors property.
   *
   * @return possible object is {@link String }
   */
  public String getAuthors() {
    return authors;
  }

  /**
   * Sets the value of the authors property.
   *
   * @param value allowed object is {@link String }
   */
  public void setAuthors(String value) {
    this.authors = value;
  }

  /**
   * Gets the value of the publication property.
   *
   * @return possible object is {@link String }
   */
  public String getPublication() {
    return publication;
  }

  /**
   * Sets the value of the publication property.
   *
   * @param value allowed object is {@link String }
   */
  public void setPublication(String value) {
    this.publication = value;
  }

  /**
   * Gets the value of the publisher property.
   *
   * @return possible object is {@link String }
   */
  public String getPublisher() {
    return publisher;
  }

  /**
   * Sets the value of the publisher property.
   *
   * @param value allowed object is {@link String }
   */
  public void setPublisher(String value) {
    this.publisher = value;
  }

  /**
   * Gets the value of the editor property.
   *
   * @return possible object is {@link String }
   */
  public String getEditor() {
    return editor;
  }

  /**
   * Sets the value of the editor property.
   *
   * @param value allowed object is {@link String }
   */
  public void setEditor(String value) {
    this.editor = value;
  }

  /**
   * Gets the value of the year property.
   *
   * @return possible object is {@link Integer }
   */
  public Integer getYear() {
    return year;
  }

  /**
   * Sets the value of the year property.
   *
   * @param value allowed object is {@link Integer }
   */
  public void setYear(Integer value) {
    this.year = value;
  }

  /**
   * Gets the value of the volume property.
   *
   * @return possible object is {@link String }
   */
  public String getVolume() {
    return volume;
  }

  /**
   * Sets the value of the volume property.
   *
   * @param value allowed object is {@link String }
   */
  public void setVolume(String value) {
    this.volume = value;
  }

  /**
   * Gets the value of the issue property.
   *
   * @return possible object is {@link String }
   */
  public String getIssue() {
    return issue;
  }

  /**
   * Sets the value of the issue property.
   *
   * @param value allowed object is {@link String }
   */
  public void setIssue(String value) {
    this.issue = value;
  }

  /**
   * Gets the value of the pages property.
   *
   * @return possible object is {@link String }
   */
  public String getPages() {
    return pages;
  }

  /**
   * Sets the value of the pages property.
   *
   * @param value allowed object is {@link String }
   */
  public void setPages(String value) {
    this.pages = value;
  }

  /**
   * Gets the value of the title property.
   *
   * @return possible object is {@link String }
   */
  public String getTitle() {
    return title;
  }

  /**
   * Sets the value of the title property.
   *
   * @param value allowed object is {@link String }
   */
  public void setTitle(String value) {
    this.title = value;
  }

  /**
   * Gets the value of the doi property.
   *
   * @return possible object is {@link String }
   */
  public String getDoi() {
    return doi;
  }

  /**
   * Sets the value of the doi property.
   *
   * @param value allowed object is {@link String }
   */
  public void setDoi(String value) {
    this.doi = value;
  }

}
