/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public final class DBFCharsetHelper {
    private DBFCharsetHelper() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static Charset getCharsetByByte(int b) {
        switch (b) {
            case 1: {
                return DBFCharsetHelper.forName("IBM437");
            }
            case 2: {
                return DBFCharsetHelper.forName("IBM850");
            }
            case 3: {
                return DBFCharsetHelper.forName("windows-1252");
            }
            case 4: {
                return DBFCharsetHelper.forName("MacRoman");
            }
            case 87: {
                return DBFCharsetHelper.forName("windows-1252");
            }
            case 89: {
                return DBFCharsetHelper.forName("windows-1252");
            }
            case 100: {
                return DBFCharsetHelper.forName("IBM852");
            }
            case 101: {
                return DBFCharsetHelper.forName("IBM866");
            }
            case 102: {
                return DBFCharsetHelper.forName("IBM865");
            }
            case 103: {
                return DBFCharsetHelper.forName("IBM861");
            }
            case 106: {
                return DBFCharsetHelper.forName("x-IBM737");
            }
            case 107: {
                return DBFCharsetHelper.forName("IBM857");
            }
            case 120: {
                return DBFCharsetHelper.forName("windows-950");
            }
            case 121: {
                return Charset.forName("windows-949");
            }
            case 122: {
                return DBFCharsetHelper.forName("GBK");
            }
            case 123: {
                return DBFCharsetHelper.forName("windows-932");
            }
            case 124: {
                return DBFCharsetHelper.forName("windows-874");
            }
            case 125: {
                return DBFCharsetHelper.forName("windows-1255");
            }
            case 126: {
                return DBFCharsetHelper.forName("windows-1256");
            }
            case 150: {
                return DBFCharsetHelper.forName("x-MacCyrillic");
            }
            case 151: {
                return DBFCharsetHelper.forName("x-MacCentralEurope");
            }
            case 152: {
                return DBFCharsetHelper.forName("x-MacGreek");
            }
            case 200: {
                return DBFCharsetHelper.forName("windows-1250");
            }
            case 201: {
                return DBFCharsetHelper.forName("windows-1251");
            }
            case 202: {
                return DBFCharsetHelper.forName("windows-1254");
            }
            case 203: {
                return DBFCharsetHelper.forName("windows-1253");
            }
        }
        return null;
    }

    private static Charset forName(String name) {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    public static int getDBFCodeForCharset(Charset charset) {
        if (charset == null) {
            return 0;
        }
        String charsetName = charset.toString();
        if ("ibm437".equalsIgnoreCase(charsetName)) {
            return 1;
        }
        if ("ibm850".equalsIgnoreCase(charsetName)) {
            return 2;
        }
        if ("windows-1252".equalsIgnoreCase(charsetName)) {
            return 3;
        }
        if ("iso-8859-1".equalsIgnoreCase(charsetName)) {
            return 3;
        }
        if ("MacRoman".equalsIgnoreCase(charsetName)) {
            return 4;
        }
        if ("IBM852".equalsIgnoreCase(charsetName)) {
            return 100;
        }
        if ("IBM865".equalsIgnoreCase(charsetName)) {
            return 102;
        }
        if ("IBM866".equalsIgnoreCase(charsetName)) {
            return 101;
        }
        if ("IBM861".equalsIgnoreCase(charsetName)) {
            return 103;
        }
        if ("IBM737".equalsIgnoreCase(charsetName)) {
            return 106;
        }
        if ("IBM857".equalsIgnoreCase(charsetName)) {
            return 107;
        }
        if ("windows-950".equalsIgnoreCase(charsetName)) {
            return 120;
        }
        if ("windows-949".equalsIgnoreCase(charsetName)) {
            return 121;
        }
        if ("gbk".equalsIgnoreCase(charsetName)) {
            return 122;
        }
        if ("windows-932".equalsIgnoreCase(charsetName)) {
            return 123;
        }
        if ("windows-874".equalsIgnoreCase(charsetName)) {
            return 124;
        }
        if ("windows-1255".equalsIgnoreCase(charsetName)) {
            return 125;
        }
        if ("windows-1256".equalsIgnoreCase(charsetName)) {
            return 126;
        }
        if ("x-MacCyrillic".equalsIgnoreCase(charsetName)) {
            return 150;
        }
        if ("x-MacCentralEurope".equalsIgnoreCase(charsetName)) {
            return 151;
        }
        if ("x-MacGreek".equalsIgnoreCase(charsetName)) {
            return 152;
        }
        if ("windows-1250".equalsIgnoreCase(charsetName)) {
            return 200;
        }
        if ("windows-1251".equalsIgnoreCase(charsetName)) {
            return 201;
        }
        if ("windows-1254".equalsIgnoreCase(charsetName)) {
            return 202;
        }
        if ("windows-1253".equalsIgnoreCase(charsetName)) {
            return 203;
        }
        return 0;
    }
}

