/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence.entity;

import com.franciaflex.magalie.persistence.entity.AbstractJpaArticle;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Location;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;

@Entity
public class Article
extends AbstractJpaArticle {
    private static final long serialVersionUID = 1L;

    public boolean isFixedLocation(Location location) {
        boolean isFixedLocation = false;
        Set<Location> fixedLocations = this.getFixedLocations();
        if (fixedLocations != null) {
            isFixedLocation = fixedLocations.contains(location);
        }
        return isFixedLocation;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("code", (Object)this.code).add("description", (Object)this.description).add("id", (Object)this.id).toString();
    }

    public Set<Location> getFixedLocationsInBuilding(Building building) {
        HashSet fixedLocationsInBuilding = Sets.newHashSet();
        if (this.getFixedLocations() != null) {
            for (Location location : this.getFixedLocations()) {
                if (!location.getWarehouse().getBuilding().equals(building)) continue;
                fixedLocationsInBuilding.add(location);
            }
        }
        return fixedLocationsInBuilding;
    }
}

