/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence;

import com.franciaflex.magalie.persistence.Articles;
import com.franciaflex.magalie.persistence.Locations;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.persistence.entity.Supplier;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.apache.commons.collections.comparators.BooleanComparator;

public class StoredArticles {
    public static Ordering<StoredArticle> receptionPriorityComparator() {
        return Ordering.natural().onResultOf(StoredArticles.getReceptionPriority());
    }

    public static Function<StoredArticle, String> getReceptionPriority() {
        return new GetReceptionPriority();
    }

    public static Comparator<StoredArticle> locationWithHighestQuantityFirst() {
        return new LocationWithHighestQuantityFirst();
    }

    public static Comparator<StoredArticle> locationWithLowestQuantityFirstComparator() {
        return Ordering.from(StoredArticles.locationWithHighestQuantityFirst()).reverse();
    }

    public static Comparator<StoredArticle> accessibleLocationFirstComparator(MagalieUser magalieUser) {
        return new AccessibleLocationFirst(magalieUser);
    }

    public static Comparator<StoredArticle> fixedLocationForArticleComparator() {
        return new FixedLocationForArticle();
    }

    public static Function<StoredArticle, Location> getLocationFunction() {
        return new GetLocationFunction();
    }

    public static Predicate<StoredArticle> articleStoredInAccessibleLocationPredicate(MagalieUser magalieUser) {
        Predicate predicate = Predicates.compose(Locations.accessibleLocationPredicate(magalieUser), StoredArticles.getLocationFunction());
        return predicate;
    }

    public static Comparator<StoredArticle> articleStoredInLocationsRequiringDriverLicenseFirstComparator() {
        return new ArticleStoredInLocationsRequiringDriverLicenseFirstComparator();
    }

    public static Predicate<StoredArticle> notEmpty() {
        return new NotEmptyPredicate();
    }

    public static Function<StoredArticle, Article> getArticleFunction() {
        return new GetArticleFunction();
    }

    public static Function<StoredArticle, Supplier> getArticleSupplierFunction() {
        return Functions.compose((Function)Articles.getSupplierFunction(), StoredArticles.getArticleFunction());
    }

    public static Predicate<StoredArticle> locationBarcodeEquals(String originLocationBarcode) {
        return Predicates.compose(Locations.barcodeEquals(originLocationBarcode), StoredArticles.getLocationFunction());
    }

    protected static class GetReceptionPriority
    implements Function<StoredArticle, String> {
        protected GetReceptionPriority() {
        }

        public String apply(StoredArticle input) {
            return input.getReceptionPriority();
        }
    }

    protected static class GetArticleFunction
    implements Function<StoredArticle, Article> {
        protected GetArticleFunction() {
        }

        public Article apply(StoredArticle storedArticle) {
            return storedArticle.getArticle();
        }
    }

    protected static class NotEmptyPredicate
    implements Predicate<StoredArticle> {
        protected NotEmptyPredicate() {
        }

        public boolean apply(StoredArticle input) {
            return input.getQuantity() > 0.0;
        }
    }

    protected static class ArticleStoredInLocationsRequiringDriverLicenseFirstComparator
    implements Comparator<StoredArticle> {
        protected ArticleStoredInLocationsRequiringDriverLicenseFirstComparator() {
        }

        @Override
        public int compare(StoredArticle o1, StoredArticle o2) {
            return Locations.locationRequiringDriverLicenseFirstComparator().compare(o1.getLocation(), o2.getLocation());
        }
    }

    protected static class GetLocationFunction
    implements Function<StoredArticle, Location> {
        protected GetLocationFunction() {
        }

        public Location apply(StoredArticle storedArticle) {
            return storedArticle.getLocation();
        }
    }

    protected static class AccessibleLocationFirst
    implements Comparator<StoredArticle> {
        protected Predicate<StoredArticle> articleStoredInAccessibleLocationPredicate;

        public AccessibleLocationFirst(MagalieUser magalieUser) {
            this.articleStoredInAccessibleLocationPredicate = StoredArticles.articleStoredInAccessibleLocationPredicate(magalieUser);
        }

        @Override
        public int compare(StoredArticle o1, StoredArticle o2) {
            boolean isLocation1Accessible = this.articleStoredInAccessibleLocationPredicate.apply((Object)o1);
            boolean isLocation2Accessible = this.articleStoredInAccessibleLocationPredicate.apply((Object)o2);
            if (isLocation1Accessible && !isLocation2Accessible) {
                return -1;
            }
            if (!isLocation1Accessible && isLocation2Accessible) {
                return 1;
            }
            return 0;
        }
    }

    protected static class LocationWithHighestQuantityFirst
    implements Comparator<StoredArticle> {
        protected LocationWithHighestQuantityFirst() {
        }

        @Override
        public int compare(StoredArticle o1, StoredArticle o2) {
            int compare = Double.compare(o2.getQuantity(), o1.getQuantity());
            return compare;
        }
    }

    protected static class FixedLocationForArticle
    implements Comparator<StoredArticle> {
        protected FixedLocationForArticle() {
        }

        @Override
        public int compare(StoredArticle x, StoredArticle y) {
            Article article = x.getArticle();
            Preconditions.checkArgument((boolean)article.equals(y.getArticle()));
            boolean xIsInFixedLocation = article.isFixedLocation(x.getLocation());
            boolean yIsInFixedLocation = article.isFixedLocation(y.getLocation());
            int compare = BooleanComparator.getBooleanComparator((boolean)article.isFixedLocationsFirst()).compare(Boolean.valueOf(xIsInFixedLocation), Boolean.valueOf(yIsInFixedLocation));
            return compare;
        }
    }
}

