/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence;

import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Comparator;

public class Locations {
    public static Predicate<Location> accessibleLocationPredicate(MagalieUser magalieUser) {
        return new AccessibleLocationPredicate(magalieUser);
    }

    public static Predicate<Location> inaccessibleLocationPredicate(MagalieUser magalieUser) {
        return Predicates.not(Locations.accessibleLocationPredicate(magalieUser));
    }

    public static Comparator<Location> locationRequiringDriverLicenseFirstComparator() {
        return new LocationRequiringDriverLicenseFirstComparator();
    }

    public static String codeForWarehouseWithoutLocations() {
        return "    SANS";
    }

    public static String codeForReceptionLocations() {
        return "     REC";
    }

    public static Predicate<Location> isNotReceptionLocation() {
        return Predicates.not((Predicate)new IsReceptionLocation());
    }

    public static Predicate<Location> isNotFullLocation() {
        return Predicates.not((Predicate)new IsFullLocation());
    }

    public static Predicate<Location> barcodeEquals(String originLocationBarcode) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)originLocationBarcode), Locations.getBarcodeFunction());
    }

    public static Function<Location, String> getBarcodeFunction() {
        return new GetBarcode();
    }

    protected static class GetBarcode
    implements Function<Location, String> {
        protected GetBarcode() {
        }

        public String apply(Location location) {
            return location.getBarcode();
        }
    }

    protected static class LocationRequiringDriverLicenseFirstComparator
    implements Comparator<Location> {
        protected LocationRequiringDriverLicenseFirstComparator() {
        }

        @Override
        public int compare(Location location1, Location location2) {
            return location2.getRequiredAccreditationLevel() - location1.getRequiredAccreditationLevel();
        }
    }

    protected static class AccessibleLocationPredicate
    implements Predicate<Location> {
        protected MagalieUser magalieUser;

        public AccessibleLocationPredicate(MagalieUser magalieUser) {
            this.magalieUser = magalieUser;
        }

        public boolean apply(Location location) {
            boolean isLocationAccessible = this.magalieUser.getAccreditationLevel() >= location.getRequiredAccreditationLevel() && (this.magalieUser.isCraneMan() || !location.isRequiredCraneMan());
            return isLocationAccessible;
        }
    }

    protected static class IsFullLocation
    implements Predicate<Location> {
        protected IsFullLocation() {
        }

        public boolean apply(Location location) {
            return location.isFullLocation();
        }
    }

    protected static class IsReceptionLocation
    implements Predicate<Location> {
        protected IsReceptionLocation() {
        }

        public boolean apply(Location location) {
            return Locations.codeForReceptionLocations().equals(location.getCode());
        }
    }
}

