/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.reader;

import com.exasol.parquetio.data.Row;
import com.exasol.parquetio.reader.RowReadSupport;
import java.io.IOException;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;

public class RowParquetReader {
    private RowParquetReader() {
    }

    public static Builder builder(InputFile file) {
        return new Builder(file);
    }

    public static MessageType getSchema(InputFile file) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)file);){
            MessageType messageType = reader.getFileMetaData().getSchema();
            return messageType;
        }
    }

    public static class Builder
    extends ParquetReader.Builder<Row> {
        protected Builder(InputFile file) {
            super(file);
        }

        protected ReadSupport<Row> getReadSupport() {
            return new RowReadSupport();
        }
    }
}

