/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor;

import dorkbox.executor.ShellExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class JvmExecutor
extends ShellExecutor {
    private String javaLocation = JvmExecutor.getJvmPath();
    private String mainClass;
    private int initialHeapSizeInMegabytes = 0;
    private int maximumHeapSizeInMegabytes = 0;
    private List<String> jvmOptions = new ArrayList<String>();
    private List<String> classpathEntries = new ArrayList<String>();
    private List<String> mainClassArguments = new ArrayList<String>();
    private String jarFile;

    public static String getVersion() {
        return "1.0";
    }

    public static String getJvmPath() {
        String jvmPath = JvmExecutor.checkJvmPath(System.getProperty("java.home"));
        if (jvmPath == null) {
            System.err.println("Unable to find java JVM [java.home=" + System.getProperty("java.home") + "]!");
            jvmPath = "java";
        }
        if (isMacOsX) {
            try {
                File binDir = new File("/usr/bin");
                File javaParentDir = new File(jvmPath).getParentFile().getCanonicalFile();
                if (javaParentDir.equals(binDir)) {
                    jvmPath = "/usr/bin/java";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jvmPath;
    }

    private static String checkJvmPath(String jvmLocation) {
        String vmbase = jvmLocation + File.separator + "bin" + File.separator;
        String vmpath = vmbase + "java";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        vmpath = vmbase + "java.exe";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        return null;
    }

    public JvmExecutor() {
        super(null, null, null);
    }

    public JvmExecutor(InputStream in, PrintStream out, PrintStream err) {
        super(in, out, err);
    }

    public final void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public final void setInitialHeapSizeInMegabytes(int startingHeapSizeInMegabytes) {
        this.initialHeapSizeInMegabytes = startingHeapSizeInMegabytes;
    }

    public final void setMaximumHeapSizeInMegabytes(int maximumHeapSizeInMegabytes) {
        this.maximumHeapSizeInMegabytes = maximumHeapSizeInMegabytes;
    }

    public final void addJvmClasspath(String classpathEntry) {
        this.classpathEntries.add(classpathEntry);
    }

    public final void addJvmClasspath(List<String> paths) {
        this.classpathEntries.addAll(paths);
    }

    public final void addJvmOption(String argument) {
        this.jvmOptions.add(argument);
    }

    public final void addJvmOptions(List<String> paths) {
        this.jvmOptions.addAll(paths);
    }

    public final void setJarFile(String jarFile) {
        this.jarFile = jarFile;
    }

    private String getClasspath() {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        int totalSize = this.classpathEntries.size();
        String pathseparator = File.pathSeparator;
        for (String classpathEntry : this.classpathEntries) {
            try {
                classpathEntry = classpathEntry.replaceAll(" ", "\\ ");
                classpathEntry = new File(classpathEntry).getAbsolutePath();
                builder.append(classpathEntry);
                ++count;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (count >= totalSize) continue;
            builder.append(pathseparator);
        }
        return builder.toString();
    }

    public void setJava(String javaLocation) {
        this.javaLocation = javaLocation;
    }

    @Override
    public int start() {
        this.setExecutable(this.javaLocation);
        ArrayList origArguments = new ArrayList(this.arguments.size());
        origArguments.addAll(this.arguments);
        this.arguments = new ArrayList(0);
        if (this.initialHeapSizeInMegabytes != 0) {
            this.arguments.add("-Xms" + this.initialHeapSizeInMegabytes + "M");
        }
        if (this.maximumHeapSizeInMegabytes != 0) {
            this.arguments.add("-Xmx" + this.maximumHeapSizeInMegabytes + "M");
        }
        this.arguments.add("-server");
        for (String option : this.jvmOptions) {
            this.arguments.add(option);
        }
        String classpath = this.getClasspath();
        if (this.jarFile != null) {
            this.arguments.add("-jar");
            this.arguments.add(this.jarFile);
            if (!classpath.isEmpty()) {
                throw new IllegalArgumentException("WHOOPS.  You CANNOT have a classpath specified on the commandline when using JARs,    It must be set in the JARs MANIFEST instead.");
            }
        } else if (this.mainClass != null) {
            if (!classpath.isEmpty()) {
                this.arguments.add("-classpath");
                this.arguments.add(classpath);
            }
            this.arguments.add(this.mainClass);
        } else {
            throw new IllegalArgumentException("You must specify a jar or main class when running a java process!");
        }
        for (String arg : this.mainClassArguments) {
            if (arg.contains(" ")) {
                String[] split;
                for (String s : split = arg.split(" ")) {
                    this.arguments.add(s);
                }
                continue;
            }
            this.arguments.add(arg);
        }
        this.arguments.addAll(origArguments);
        return super.start();
    }
}

