/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.api;

import com.docusign.webforms.client.ApiClient;
import com.docusign.webforms.client.ApiException;
import com.docusign.webforms.client.ApiResponse;
import com.docusign.webforms.client.Configuration;
import com.docusign.webforms.client.Pair;
import com.docusign.webforms.model.WebForm;
import com.docusign.webforms.model.WebFormSummaryList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class FormManagementApi {
    private ApiClient apiClient;

    public FormManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FormManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WebForm getForm(String accountId, String formId) throws ApiException {
        return this.getForm(accountId, formId, null);
    }

    public WebForm getForm(String accountId, String formId, GetFormOptions options) throws ApiException {
        ApiResponse<WebForm> localVarResponse = this.getFormWithHttpInfo(accountId, formId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<WebForm> getFormWithHttpInfo(String accountId, String formId, GetFormOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getForm");
        }
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling getForm");
        }
        String localVarPath = "/v1.1/accounts/{accountId}/forms/{formId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{formId\\}", this.apiClient.escapeString(formId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", options.state));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WebForm> localVarReturnType = new GenericType<WebForm>(){};
        WebForm localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WebForm>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WebFormSummaryList listForms(String accountId) throws ApiException {
        return this.listForms(accountId, null);
    }

    public WebFormSummaryList listForms(String accountId, ListFormsOptions options) throws ApiException {
        ApiResponse<WebFormSummaryList> localVarResponse = this.listFormsWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<WebFormSummaryList> listFormsWithHttpInfo(String accountId, ListFormsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listForms");
        }
        String localVarPath = "/v1.1/accounts/{accountId}/forms".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_filter", options.userFilter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_standalone", options.isStandalone));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_published", options.isPublished));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort_by", options.sortBy));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search", options.search));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WebFormSummaryList> localVarReturnType = new GenericType<WebFormSummaryList>(){};
        WebFormSummaryList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WebFormSummaryList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class ListFormsOptions {
        private String userFilter = null;
        private Boolean isStandalone = null;
        private Boolean isPublished = null;
        private String sortBy = null;
        private String search = null;
        private String startPosition = null;
        private String count = null;

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setIsStandalone(Boolean isStandalone) {
            this.isStandalone = isStandalone;
        }

        public Boolean getIsStandalone() {
            return this.isStandalone;
        }

        public void setIsPublished(Boolean isPublished) {
            this.isPublished = isPublished;
        }

        public Boolean getIsPublished() {
            return this.isPublished;
        }

        public void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public String getSortBy() {
            return this.sortBy;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public String getSearch() {
            return this.search;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }
    }

    public class GetFormOptions {
        private String state = null;

        public void setState(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }
    }
}

