/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.util.Debug;
import java.io.Serializable;

public class Length
implements Serializable {
    public static final Length MILE = new Length("mile", "miles", 24901.460807187756);
    public static final Length FEET = new Length("feet", "ft", 1.3147971306195135E8);
    public static final Length YARD = new Length("yards", "yd", 4.3826571020650454E7);
    public static final Length METER = new Length("meter", "m", 4.007501668557849E7);
    public static final Length KM = new Length("kilometer", "km", 40075.016685578485);
    public static final Length NM = new Length("nautical mile", "nm", 21600.0);
    public static final Length DECIMAL_DEGREE = new Length("decimal degree", "deg", 360.0);
    public static final Length DM = new Length("datamile", "dm", 21913.285510325226);
    public static final Length RADIAN = new Length("radian", "rad", Math.PI * 2){

        public float toRadians(float numUnits) {
            return numUnits;
        }

        public double toRadians(double numUnits) {
            return numUnits;
        }

        public float fromRadians(float numRadians) {
            return numRadians;
        }

        public double fromRadians(double numRadians) {
            return numRadians;
        }
    };
    protected final double constant;
    protected final String name;
    protected final String abbr;
    protected double unitEquatorCircumference;
    protected transient I18n i18n = Environment.getI18n();

    public Length(String name, String abbr, double unitEquatorCircumference) {
        this.name = this.i18n.get(this, abbr + ".name", name).toLowerCase().intern();
        this.unitEquatorCircumference = unitEquatorCircumference;
        this.constant = unitEquatorCircumference / (Math.PI * 2);
        this.abbr = abbr.toLowerCase().intern();
    }

    public float toRadians(float numUnits) {
        if (Debug.debugging("length")) {
            Debug.output("Translating " + this.name + " from radians");
        }
        return numUnits / (float)this.constant;
    }

    public double toRadians(double numUnits) {
        if (Debug.debugging("length")) {
            Debug.output("Translating " + this.name + " from radians");
        }
        return numUnits / this.constant;
    }

    public float fromRadians(float numRadians) {
        if (Debug.debugging("length")) {
            Debug.output("Translating radians from " + this.name);
        }
        return numRadians * (float)this.constant;
    }

    public double fromRadians(double numRadians) {
        if (Debug.debugging("length")) {
            Debug.output("Translating radians from " + this.name);
        }
        return numRadians * this.constant;
    }

    public String toString() {
        return this.name;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public static Length[] getAvailable() {
        return new Length[]{METER, KM, FEET, YARD, MILE, DM, NM, DECIMAL_DEGREE};
    }

    public static Length get(String name) {
        Length[] choices = Length.getAvailable();
        if (name != null) {
            name = name.toLowerCase();
            for (Length choice : choices) {
                if (!name.equals(choice.toString()) && !name.equals(choice.getAbbr())) continue;
                return choice;
            }
        }
        return null;
    }
}

