/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.grid.ElevationColors;
import com.bbn.openmap.omGraphics.grid.SimpleColorGenerator;
import com.bbn.openmap.proj.Length;

public class ElevationBandGenerator
extends SimpleColorGenerator {
    public static final int DEFAULT_BANDHEIGHT = 100;
    public static final int DEFAULT_ADJUST = 3;
    protected int[] colors;
    protected int adjust = 3;
    protected int bandHeight = 100;
    protected Length dataUnits = Length.METER;
    protected Length displayUnits = Length.METER;

    public ElevationBandGenerator() {
        this.setColortable(this.createGreyscaleColors(216, 255));
    }

    public int calibratePointValue(int source) {
        if (source < -500) {
            return 0;
        }
        if (source == 0) {
            return this.colors[0];
        }
        if (this.displayUnits != this.dataUnits) {
            source = (int)this.displayUnits.fromRadians(this.dataUnits.toRadians(source));
        }
        int assignment = source / this.bandHeight % (10 - 2 * (3 - this.adjust)) * (this.colors.length / (10 - 2 * (3 - this.adjust))) + 6;
        return this.colors[assignment];
    }

    public void setColortable(int[] colors) {
        this.colors = colors;
    }

    public int[] getColortable() {
        return this.colors;
    }

    public void setColors(ElevationColors ec) {
        this.setColortable(ec.getColortable());
    }

    public void setBandHeight(int height) {
        if (height <= 0) {
            height = 100;
        }
        this.bandHeight = height;
    }

    public int getBandHeight() {
        return this.bandHeight;
    }

    public void setAdjust(int value) {
        if (value <= 0 || value > 5) {
            value = 3;
        }
        this.adjust = value;
    }

    public int getAdjust() {
        return this.adjust;
    }

    public Length getDataUnits() {
        return this.dataUnits;
    }

    public void setDataUnits(Length units) {
        this.dataUnits = units;
    }

    public Length getDisplayUnits() {
        return this.displayUnits;
    }

    public void setDisplayUnits(Length displayUnits) {
        this.displayUnits = displayUnits;
    }
}

