/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.util.HandleError;
import com.bbn.openmap.util.PropUtils;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public class URLRasterLocation
extends Location {
    public int SPACING = 0;

    public URLRasterLocation() {
    }

    public URLRasterLocation(double latitude, double longitude, String name, String iconURL) {
        super(latitude, longitude, name, (OMGraphic)URLRasterLocation.getIconRaster(latitude, longitude, iconURL));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public URLRasterLocation(double latitude, double longitude, String name, URL iconURL) {
        super(latitude, longitude, name, (OMGraphic)URLRasterLocation.getIconRaster(latitude, longitude, iconURL));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public URLRasterLocation(int x, int y, String name, String iconURL) {
        super(x, y, name, (OMGraphic)URLRasterLocation.getIconRaster(x, y, iconURL));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public URLRasterLocation(int x, int y, String name, URL iconURL) {
        super(x, y, name, (OMGraphic)URLRasterLocation.getIconRaster(x, y, iconURL));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public URLRasterLocation(double latitude, double longitude, int xOffset, int yOffset, String name, String iconURL) {
        super(latitude, longitude, xOffset, yOffset, name, URLRasterLocation.getIconRaster(latitude, longitude, xOffset, yOffset, iconURL));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public URLRasterLocation(double latitude, double longitude, int xOffset, int yOffset, String name, URL iconURL) {
        super(latitude, longitude, xOffset, yOffset, name, URLRasterLocation.getIconRaster(latitude, longitude, xOffset, yOffset, iconURL));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public static OMRaster getIconRaster(double lat, double lon, String iconURL) {
        URL url = URLRasterLocation.getIconRasterURL(iconURL);
        if (url == null) {
            return null;
        }
        return URLRasterLocation.getIconRaster(lat, lon, url);
    }

    public static OMRaster getIconRaster(double lat, double lon, URL iconURL) {
        ImageIcon icon = new ImageIcon(iconURL);
        if (icon == null) {
            return null;
        }
        int offX = icon.getIconWidth() / 2;
        int offY = icon.getIconHeight() / 2;
        return new OMRaster(lat, lon, -offX, -offY, icon);
    }

    public static OMRaster getIconRaster(int x, int y, String iconURL) {
        URL url = URLRasterLocation.getIconRasterURL(iconURL);
        if (url == null) {
            return null;
        }
        return URLRasterLocation.getIconRaster(x, y, url);
    }

    public static OMRaster getIconRaster(int x, int y, URL iconURL) {
        ImageIcon icon = new ImageIcon(iconURL);
        if (icon == null) {
            return null;
        }
        int offX = icon.getIconWidth() / 2;
        int offY = icon.getIconHeight() / 2;
        return new OMRaster(x - offX, y - offY, icon);
    }

    public static OMRaster getIconRaster(double lat, double lon, int x, int y, String iconURL) {
        URL url = URLRasterLocation.getIconRasterURL(iconURL);
        if (url == null) {
            return null;
        }
        return URLRasterLocation.getIconRaster(lat, lon, x, y, url);
    }

    public static OMRaster getIconRaster(double lat, double lon, int x, int y, URL iconURL) {
        ImageIcon icon = new ImageIcon(iconURL);
        if (icon == null) {
            return null;
        }
        int offX = icon.getIconWidth() / 2;
        int offY = icon.getIconHeight() / 2;
        return new OMRaster(lat, lon, x - offX, y - offY, icon);
    }

    public static URL getIconRasterURL(String iconURL) {
        try {
            return PropUtils.getResourceOrFileOrURL(null, iconURL);
        }
        catch (MalformedURLException mue) {
            throw new HandleError(mue);
        }
    }

    public void setGraphicLocations(double latitude, double longitude) {
        if (this.location instanceof OMRaster) {
            OMRaster ras = (OMRaster)this.location;
            ras.setLat(latitude);
            ras.setLon(longitude);
            this.label.setLat(latitude);
            this.label.setLon(longitude);
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public void setGraphicLocations(int x, int y) {
        if (this.location instanceof OMRaster) {
            OMRaster ras = (OMRaster)this.location;
            ras.setX(x);
            ras.setY(y);
            this.label.setX(x);
            this.label.setY(y);
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public void setGraphicLocations(double latitude, double longitude, int offsetX, int offsetY) {
        if (this.location instanceof OMRaster) {
            OMRaster ras = (OMRaster)this.location;
            ras.setLat(latitude);
            ras.setLon(longitude);
            ras.setX(offsetX);
            ras.setY(offsetY);
            this.label.setLat(latitude);
            this.label.setLon(longitude);
            this.label.setX(offsetX);
            this.label.setY(offsetY);
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }
}

