/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import java.awt.image.PixelGrabber;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageHelper {
    public static final Logger logger = Logger.getLogger("com.bbn.openmap.image.ImageHelper");

    public static int[] grabPixels(PixelGrabber pg) {
        try {
            pg.startGrabbing();
            boolean grabbed = pg.grabPixels();
            if (!grabbed) {
                logger.fine("Error in loading image, no pixels grabbed");
                return null;
            }
            int framebitCount = 0;
            while (true) {
                int status = pg.getStatus();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("pixelgrabber status = " + status);
                }
                if ((status & 0x20) != 0) break;
                if ((status & 0x10) != 0) {
                    if (framebitCount >= 20) break;
                    ++framebitCount;
                    break;
                }
                if ((status & 0x40) != 0) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Error in loading image, ImageObserver error");
                    }
                    return null;
                }
                Thread.sleep(100L);
            }
            return (int[])pg.getPixels();
        }
        catch (InterruptedException ie) {
            return null;
        }
    }
}

