/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.Layer;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropertyStringFormatException;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropUtils {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.util.PropUtils");
    public static final String DUMMY_MARKER_NAME = "DUMMY_MARKER_NAME";
    public static final String keyValueSeparators = "=: \t\r\n\f";
    public static final String strictKeyValueSeparators = "=:";
    public static final String whiteSpaceChars = " \t\r\n\f";
    public static final String propertySeparators = "&";

    public static Vector<String> parseSpacedMarkers(String markerList) {
        return PropUtils.parseMarkers(markerList, " ");
    }

    public static Vector<String> parseMarkers(String markerList, String delim) {
        Vector<String> vector = null;
        if (markerList == null) {
            logger.fine("marker list null!");
            return new Vector<String>(0);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("parsing marker list |" + markerList + "|");
        }
        markerList = markerList.replace('\"', '\u0000');
        StringTokenizer tokens = new StringTokenizer(markerList, delim);
        vector = new Vector<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().trim();
            vector.addElement(name);
        }
        return vector;
    }

    public static Properties parsePropertyList(String list) throws PropertyStringFormatException {
        return PropUtils.parsePropertyList(list, propertySeparators, keyValueSeparators);
    }

    public static Properties parsePropertyList(String list, String propertySeparators, String keyValueSeparators) throws PropertyStringFormatException {
        Properties props = new Properties();
        Vector<String> keyValuePairs = PropUtils.parseMarkers(list, propertySeparators);
        for (int i = 0; i < keyValuePairs.size(); ++i) {
            StringTokenizer tokens = new StringTokenizer(keyValuePairs.elementAt(i), keyValueSeparators);
            try {
                String key = tokens.nextToken().trim();
                String value = tokens.nextToken().trim();
                props.put(key, value);
                continue;
            }
            catch (NoSuchElementException nsee) {
                throw new PropertyStringFormatException(list);
            }
        }
        return props;
    }

    public static void copyProperties(Properties from, Properties to) {
        Enumeration<Object> keys = from.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            to.put(key, from.getProperty(key));
        }
    }

    public static boolean loadProperties(Properties props, String dir, String file) {
        File propsFile = new File(dir, file);
        try {
            FileInputStream propsStream = new FileInputStream(propsFile);
            props.load(propsStream);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found " + propsFile);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("File not found -  \"" + propsFile + "\"");
            }
        }
        catch (IOException e) {
            logger.warning("Caught IO Exception reading \"" + propsFile + "\"");
            e.printStackTrace();
        }
        catch (AccessControlException ace) {
            // empty catch block
        }
        return false;
    }

    public static boolean loadProperties(Properties properties, InputStream propsIn) {
        try {
            properties.load(propsIn);
            return true;
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.warning("Caught IOException loading properties from InputStream.");
            }
            return false;
        }
    }

    public static Properties promptUserForProperties() {
        JFileChooser fileChooser = new JFileChooser();
        int retvalue = fileChooser.showOpenDialog(null);
        Properties props = new Properties();
        if (retvalue != 0) {
            return props;
        }
        try {
            FileInputStream inputStream = new FileInputStream(fileChooser.getSelectedFile());
            props.load(inputStream);
            return props;
        }
        catch (Exception ioe) {
            System.err.println("PropUtils.promptUserForProperties: Exception reading properties file.");
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
            return props;
        }
    }

    public static String getScopedPropertyPrefix(PropertyConsumer pc) {
        return PropUtils.getScopedPropertyPrefix(pc.getPropertyPrefix());
    }

    public static String getScopedPropertyPrefix(String pre) {
        if (pre == null || pre.length() == 0) {
            return "";
        }
        if (pre.endsWith(".")) {
            return pre;
        }
        return pre + ".";
    }

    public static String getDummyMarkerForPropertyInfo(String realComponentPropertyPrefix, String anyDesiredScoper) {
        return DUMMY_MARKER_NAME + (anyDesiredScoper != null ? anyDesiredScoper : "") + "." + (realComponentPropertyPrefix != null ? realComponentPropertyPrefix : "");
    }

    public static String decodeDummyMarkerFromPropertyInfo(String possibleDummyMarker) {
        int lastDot;
        if (possibleDummyMarker != null && possibleDummyMarker.startsWith(DUMMY_MARKER_NAME) && (lastDot = possibleDummyMarker.lastIndexOf(".")) != -1) {
            possibleDummyMarker = possibleDummyMarker.substring(lastDot + 1);
        }
        return possibleDummyMarker;
    }

    public static String unnull(Object prop) {
        if (prop == null) {
            return "";
        }
        return prop.toString();
    }

    public static String[] initPathsFromProperties(Properties p, String propName) {
        return PropUtils.initPathsFromProperties(p, propName, null);
    }

    public static String[] initPathsFromProperties(Properties p, String propName, String[] defaultPaths) {
        String[] ret = PropUtils.stringArrayFromProperties(p, propName, ";");
        if (ret == null) {
            ret = defaultPaths;
        }
        return ret;
    }

    public static char charFromProperties(Properties p, String propName, char defaultValue) {
        char ret = defaultValue;
        String charString = p.getProperty(propName);
        if (charString != null && charString.length() > 0) {
            return charString.charAt(0);
        }
        return ret;
    }

    public static int intFromProperties(Properties p, String propName, int defaultValue) {
        int ret = defaultValue;
        String intString = p.getProperty(propName);
        if (intString != null) {
            try {
                ret = Integer.parseInt(intString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static float floatFromProperties(Properties p, String propName, float defaultValue) {
        float ret = defaultValue;
        String floatString = p.getProperty(propName);
        if (floatString != null) {
            try {
                ret = Float.parseFloat(floatString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static boolean booleanFromProperties(Properties p, String propName, boolean defaultValue) {
        boolean ret = defaultValue;
        String booleanString = p.getProperty(propName);
        if (booleanString != null) {
            ret = booleanString.trim().equalsIgnoreCase("true");
        }
        return ret;
    }

    public static Object objectFromProperties(Properties p, String propName) {
        Object ret = null;
        String objectName = p.getProperty(propName);
        if (objectName != null) {
            ret = ComponentFactory.create(objectName);
        }
        return ret;
    }

    public static String[] stringArrayFromProperties(Properties p, String propName, String tok) {
        String[] ret = null;
        String raw = p.getProperty(propName);
        if (raw != null && raw.length() > 0) {
            try {
                StringTokenizer token = new StringTokenizer(raw, tok);
                int numPaths = token.countTokens();
                ret = new String[numPaths];
                for (int i = 0; i < numPaths; ++i) {
                    ret[i] = token.nextToken();
                }
                return ret;
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static double doubleFromProperties(Properties p, String propName, double defaultValue) {
        double ret = defaultValue;
        String doubleString = p.getProperty(propName);
        if (doubleString != null) {
            try {
                ret = Double.parseDouble(doubleString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static long longFromProperties(Properties p, String propName, long defaultValue) {
        long ret = defaultValue;
        String longString = p.getProperty(propName);
        if (longString != null) {
            try {
                ret = Long.parseLong(longString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static Color parseColorFromProperties(Properties p, String propName, String dfault) throws NumberFormatException {
        return ColorFactory.parseColorFromProperties(p, propName, dfault, false);
    }

    public static Color parseColorFromProperties(Properties p, String propName, String dfault, boolean forceAlpha) throws NumberFormatException {
        return ColorFactory.parseColorFromProperties(p, propName, dfault, forceAlpha);
    }

    public static Paint parseColorFromProperties(Properties p, String propName, Paint dfault) {
        return ColorFactory.parseColorFromProperties(p, propName, dfault);
    }

    public static Color parseColor(String colorString, boolean forceAlpha) throws NumberFormatException {
        return ColorFactory.parseColor(colorString, forceAlpha);
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        return ColorFactory.parseColor(colorString, false);
    }

    public static String getProperty(Color color) {
        StringBuffer hexstring = new StringBuffer(Integer.toHexString(color.getRGB()));
        while (hexstring.length() < 8) {
            hexstring.insert(0, '0');
        }
        return hexstring.toString();
    }

    public static String[] getPropertiesAsStringArray(Properties props) {
        int size = props.size();
        String[] ret = new String[size * 2];
        int count = 0;
        Enumeration<?> things = props.propertyNames();
        while (things.hasMoreElements()) {
            ret[count] = (String)things.nextElement();
            ret[count + 1] = props.getProperty(ret[count]);
            count += 2;
        }
        return ret;
    }

    public static URL getResourceOrFileOrURL(String name) throws MalformedURLException {
        return PropUtils.getResourceOrFileOrURL(null, name);
    }

    public static URL getResourceOrFileOrURL(Object askingClass, String name) throws MalformedURLException {
        return PropUtils.getResourceOrFileOrURL(askingClass.getClass(), name);
    }

    public static URL getResourceOrFileOrURL(Class<? extends Object> askingClass, String name) throws MalformedURLException {
        boolean DEBUG = logger.isLoggable(Level.FINE);
        if (name == null) {
            if (DEBUG) {
                logger.fine("null file name");
            }
            return null;
        }
        URL retval = null;
        if (DEBUG) {
            logger.fine("looking for " + name);
        }
        if (askingClass != null) {
            if (DEBUG) {
                logger.fine("checking as resource");
            }
            retval = askingClass.getResource(name);
        }
        if (retval == null) {
            if (DEBUG) {
                logger.fine("checking in general classpath");
            }
            retval = Thread.currentThread().getContextClassLoader().getResource(name);
        }
        if (retval == null && Environment.isApplet()) {
            if (DEBUG) {
                logger.fine("checking with URLClassLoader");
            }
            URL[] cba = new URL[]{Environment.getApplet().getCodeBase()};
            URLClassLoader ucl = URLClassLoader.newInstance(cba);
            retval = ucl.getResource(name);
        }
        if (retval == null) {
            if (DEBUG) {
                logger.fine("not found as resource");
            }
            try {
                File file = new File(name);
                if (file.exists()) {
                    retval = file.toURI().toURL();
                    if (DEBUG) {
                        logger.fine("found as file :)");
                    }
                } else {
                    if (DEBUG) {
                        logger.fine("Not a file, checking as URL");
                    }
                    retval = new URL(name);
                    InputStream is = retval.openStream();
                    is.close();
                    if (DEBUG) {
                        logger.fine("OK as URL :)");
                    }
                }
            }
            catch (IOException ioe) {
                retval = null;
            }
            catch (AccessControlException ace) {
                logger.warning("AccessControlException trying to access " + name);
                retval = null;
            }
            catch (Exception e) {
                logger.warning("caught exception " + e.getMessage());
                retval = null;
            }
        }
        if (DEBUG) {
            if (retval != null) {
                logger.fine("Resource " + name + "=" + retval.toString());
            } else {
                logger.fine("Resource " + name + " can't be found...");
            }
        }
        return retval;
    }

    public static Properties setI18NPropertyInfo(I18n i18n, Properties info, Class<? extends Object> classToSetFor, String propertyName, String label, String tooltip, String editor) {
        if (info == null) {
            info = new Properties();
        }
        if (i18n != null) {
            String internString;
            if (tooltip != null) {
                internString = i18n.get(classToSetFor, propertyName, 3, tooltip);
                info.put(propertyName, internString);
            }
            if (label != null) {
                internString = i18n.get(classToSetFor, propertyName, label);
                info.put(propertyName + ".label", internString);
            }
            if (editor != null) {
                info.put(propertyName + ".editor", editor);
            }
        }
        return info;
    }

    public static void putDataPrefixToLayerList(Layer layer, Properties props, String layerListProperty) {
        String dataPrefix = (String)layer.getAttribute("dataPathPrefix");
        if (dataPrefix != null && dataPrefix.length() > 0) {
            PropUtils.putDataPrefixToLayerList(dataPrefix, props, layerListProperty);
        }
    }

    public static void putDataPrefixToLayerList(String dataPrefix, Properties props, String layerListProperty) {
        Vector<String> layersValue = PropUtils.parseSpacedMarkers(props.getProperty(layerListProperty));
        Iterator<String> it = layersValue.iterator();
        while (it.hasNext()) {
            String markerName = PropUtils.getScopedPropertyPrefix(it.next());
            props.setProperty(markerName + "dataPathPrefix", dataPrefix);
        }
    }

    public static List<?> objectsFromProperties(Properties p, String markerListProperty, String definingProperty) {
        return PropUtils.objectsFromScopedProperties(p, markerListProperty, definingProperty, null);
    }

    public static List<?> objectsFromScopedProperties(Properties p, String markerListProperty, String definingProperty, String parentMarker) {
        String markerList = p.getProperty(markerListProperty);
        LinkedList<Object> ret = new LinkedList<Object>();
        parentMarker = PropUtils.getScopedPropertyPrefix(parentMarker);
        if (markerList != null) {
            Vector<String> markerNames = PropUtils.parseSpacedMarkers(markerList);
            for (String markerName : markerNames) {
                Object obj;
                String classname = p.getProperty(parentMarker + markerName + "." + definingProperty);
                if (classname == null || (obj = ComponentFactory.create(classname, markerName, p)) == null) continue;
                ret.add(obj);
            }
        }
        return ret;
    }

    public static <T> void putIfNotDefault(Properties props, String propertyName, T value) {
        PropUtils.putIfNotDefault(props, propertyName, value, null);
    }

    public static <T> void putIfNotDefault(Properties props, String propertyName, T value, T def) {
        if (value != null) {
            String valString = value.toString().trim();
            if ((def == null || def != null && !def.toString().trim().equals(valString)) && valString.length() != 0) {
                props.put(propertyName, valString);
            }
        }
    }
}

