/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.tools.beanbox.BeanPanel;
import com.bbn.openmap.tools.beanbox.MessageHeader;
import com.bbn.openmap.util.Debug;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.util.Hashtable;

public class JarInfo {
    private String[] beanNames;
    private BeanInfo[] beanInfos;
    private Class[] beanClasses;
    private boolean[] fromPrototype;
    private MessageHeader[] manifestData;
    private String jarName;
    private static Hashtable beanToJar = new Hashtable();

    public JarInfo(String jarName, String[] beanNames, boolean[] fromPrototype, MessageHeader[] manifestData) {
        if (beanNames.length != fromPrototype.length) {
            throw new Error("beanNames and fromPrototype need to have the same length");
        }
        this.jarName = jarName;
        this.beanNames = beanNames;
        this.fromPrototype = fromPrototype;
        this.manifestData = manifestData;
        this.beanInfos = new BeanInfo[beanNames.length];
        this.beanClasses = new Class[beanNames.length];
        for (int i = 0; i < beanNames.length; ++i) {
            BeanInfo bi;
            Class<?> c;
            beanToJar.put(beanNames[i], jarName);
            if (fromPrototype[i]) continue;
            try {
                this.beanClasses[i] = c = Class.forName(beanNames[i]);
            }
            catch (Exception ex) {
                System.err.println("Could not load " + beanNames[i] + " from " + jarName);
                continue;
            }
            catch (Error er) {
                System.out.println(er);
                System.err.println("Could not load " + beanNames[i] + " in " + jarName);
                continue;
            }
            try {
                bi = BeanPanel.findBeanInfo(beanNames[i]);
            }
            catch (Exception ex) {
                System.err.println("JarInfo: couldn't find BeanInfo for " + c + "; caught " + ex);
                continue;
            }
            catch (Error er) {
                System.out.println(er.getMessage());
                er.printStackTrace();
                System.err.println("Could not load beanInfo for " + beanNames[i] + " in " + jarName);
                continue;
            }
            if (bi == null) continue;
            this.beanInfos[i] = bi;
        }
    }

    public static String getJarName(String beanName) {
        return (String)beanToJar.get(beanName);
    }

    public String getJarName() {
        return this.jarName;
    }

    public int getCount() {
        return this.beanNames.length;
    }

    Class getBeanClass(int i) {
        return this.beanClasses[i];
    }

    BeanInfo getBeanInfo(int i) {
        if (this.beanInfos[i] != null) {
            return this.beanInfos[i];
        }
        Object b = this.getInstance(this.beanNames[i]);
        if (b != null) {
            BeanInfo bi;
            Class<?> c = b.getClass();
            try {
                bi = Introspector.getBeanInfo(c);
            }
            catch (Exception ex) {
                System.err.println("JarInfo: couldn't find BeanInfo for " + c + "; caught " + ex);
                return null;
            }
            this.beanInfos[i] = bi;
            return bi;
        }
        return null;
    }

    String getName(int i) {
        return this.beanNames[i];
    }

    public boolean isFromPrototype(String name) {
        return this.fromPrototype[this.indexForName(name)];
    }

    public MessageHeader getManifestData(String name) {
        return this.manifestData[this.indexForName(name)];
    }

    public Object getInstance(String name) {
        try {
            return Beans.instantiate(null, name);
        }
        catch (Throwable th) {
            if (Debug.debugging("beanbox")) {
                System.err.println(th);
                th.printStackTrace();
                if (name.indexOf(92) >= 0) {
                    System.err.println("    Note that file names in manifests must use forward slashes \"/\" \n    rather than back-slashes \"\\\"");
                }
            }
            return null;
        }
    }

    private int indexForName(String name) {
        for (int i = 0; i < this.beanNames.length; ++i) {
            if (!this.beanNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }
}

