/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.rule;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RuleOp {
    EQUALS("equals", "equals"){

        public boolean compare(int kvcr) {
            return kvcr == 0;
        }
    }
    ,
    LESS_THAN("less than", "lt"){

        public boolean compare(int kvcr) {
            return kvcr > 0;
        }
    }
    ,
    LESS_THAN_EQUALS("less than or equals", "lte"){

        public boolean compare(int kvcr) {
            return kvcr == 0 || kvcr > 0;
        }
    }
    ,
    GREATER_THAN("greater than", "gt"){

        public boolean compare(int kvcr) {
            return kvcr < 0;
        }
    }
    ,
    GREATER_THAN_EQUALS("greater than or equals", "gte"){

        public boolean compare(int kvcr) {
            return kvcr == 0 || kvcr < 0;
        }
    }
    ,
    NOT_EQUALS("not equals", "ne"){

        public boolean compare(int kvcr) {
            return kvcr != 0;
        }
    }
    ,
    NONE("no-op", "noop"){

        public boolean compare(int kvcr) {
            return false;
        }
    }
    ,
    ALL("all", "all"){

        public boolean compare(int kvcr) {
            return true;
        }
    }
    ,
    STARTS_WITH("starts with", "starts"){

        public boolean compare(int kvcr) {
            return kvcr == 0;
        }

        public boolean evaluate(Object key, Object val) {
            return val.toString().startsWith(key.toString());
        }
    }
    ,
    ENDS_WITH("ends with", "ends"){

        public boolean compare(int kvcr) {
            return kvcr == 0;
        }

        public boolean evaluate(Object key, Object val) {
            return val.toString().endsWith(key.toString());
        }
    };

    protected String description;
    protected String propertyNotation;

    private RuleOp(String desc, String propNotation) {
        this.description = desc;
        this.propertyNotation = propNotation;
    }

    public boolean evaluate(Object key, Object val) {
        if (key == null) {
            return this.compare(-1);
        }
        if (val instanceof Number) {
            if (!(key instanceof Double)) {
                DecimalFormat df = new DecimalFormat();
                DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
                df.setDecimalFormatSymbols(dfs);
                try {
                    key = new Double(df.parse(key.toString()).doubleValue());
                }
                catch (ParseException pe) {
                    return this.compare(-1);
                }
            }
            return this.compare(((Double)key).compareTo(((Number)val).doubleValue()));
        }
        return this.compare(key.toString().compareTo(val.toString()));
    }

    public abstract boolean compare(int var1);

    public static RuleOp resolve(String opString) {
        if (opString != null) {
            for (RuleOp op : RuleOp.values()) {
                if (!op.propertyNotation.equalsIgnoreCase(opString)) continue;
                return op;
            }
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPropertyNotation() {
        return this.propertyNotation;
    }
}

