/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfCoverage;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfCoverageManager {
    protected int currentLineType = 2;
    protected RpfFrameProvider frameProvider;

    public RpfCoverageManager(RpfFrameProvider rfp) {
        this.frameProvider = rfp;
    }

    protected void getCatalogCoverage(double ullat, double ullon, double lrlat, double lrlon, Projection proj, String chartSeries, Map<RpfProductInfo, RpfCoverage.RpfCoverageControl> coverages) {
        Debug.message("rpfcov", "RpfCoverageManager: Getting catalog coverage from RpfFrameProvider");
        if (proj == null || this.frameProvider == null) {
            return;
        }
        CADRG cadrg = proj instanceof CADRG ? (CADRG)proj : new CADRG(proj.getCenter(new LatLonPoint.Float()), proj.getScale(), proj.getWidth(), proj.getHeight());
        ArrayList<RpfCoverageBox> hemisphereData = new ArrayList<RpfCoverageBox>();
        if (ProjMath.isCrossingDateline(ullon, lrlon, proj.getScale())) {
            hemisphereData.addAll(this.frameProvider.getCatalogCoverage(ullat, ullon, lrlat, 180.0, cadrg, chartSeries));
            hemisphereData.addAll(this.frameProvider.getCatalogCoverage(ullat, -180.0, lrlat, lrlon, cadrg, chartSeries));
        } else {
            hemisphereData.addAll(this.frameProvider.getCatalogCoverage(ullat, ullon, lrlat, lrlon, cadrg, chartSeries));
        }
        boolean checkSeries = chartSeries != null && !chartSeries.equals("ANY") && !chartSeries.equals("ALL");
        for (RpfCoverageBox box : hemisphereData) {
            RpfCoverage.RpfCoverageControl control;
            OMRect rect = new OMRect(box.nw_lat, box.nw_lon, box.se_lat, box.se_lon, this.currentLineType);
            RpfProductInfo rpi = RpfProductInfo.get(box.chartCode);
            if (rpi == null || checkSeries && !rpi.seriesCode.equalsIgnoreCase(chartSeries) || (control = coverages.get(rpi)) == null) continue;
            control.add(rect);
            rect.generate(proj);
        }
    }
}

