/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.layer.DeclutterMatrix;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.policy.BufferedImageRenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationLayer
extends OMGraphicHandlerLayer {
    protected DeclutterMatrix declutterMatrix = null;
    protected boolean useDeclutterMatrix = false;
    protected boolean allowPartials = true;
    protected final CopyOnWriteArrayList<LocationHandler> dataHandlers = new CopyOnWriteArrayList();
    public static final String recenter = "Re-center map";
    public static final String cancel = "Cancel";
    public static final String UseDeclutterMatrixProperty = "useDeclutter";
    public static final String DeclutterMatrixClassProperty = "declutterMatrix";
    public static final String AllowPartialsProperty = "allowPartials";
    public static final String LocationHandlerListProperty = "locationHandlers";
    protected Box box = null;
    protected JCheckBox declutterButton = null;

    public LocationLayer() {
        this.setRenderPolicy(new BufferedImageRenderPolicy(this));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String realPrefix = "";
        if (prefix != null) {
            realPrefix = prefix + ".";
        }
        this.setLocationHandlers(realPrefix, properties);
        this.declutterMatrix = (DeclutterMatrix)PropUtils.objectFromProperties(properties, realPrefix + DeclutterMatrixClassProperty);
        this.allowPartials = PropUtils.booleanFromProperties(properties, realPrefix + AllowPartialsProperty, true);
        if (this.declutterMatrix != null) {
            this.useDeclutterMatrix = PropUtils.booleanFromProperties(properties, realPrefix + UseDeclutterMatrixProperty, this.useDeclutterMatrix);
            this.declutterMatrix.setAllowPartials(this.allowPartials);
            Debug.message("location", "LocationLayer: Found DeclutterMatrix to use");
        } else {
            this.useDeclutterMatrix = false;
        }
    }

    public void setDeclutterMatrix(DeclutterMatrix dm) {
        this.declutterMatrix = dm;
    }

    public DeclutterMatrix getDeclutterMatrix() {
        return this.declutterMatrix;
    }

    public void setUseDeclutterMatrix(boolean set) {
        this.useDeclutterMatrix = set;
        if (this.declutterButton != null) {
            this.declutterButton.setSelected(this.useDeclutterMatrix);
        }
    }

    public boolean getUseDeclutterMatrix() {
        return this.useDeclutterMatrix;
    }

    public void reloadData() {
        if (this.dataHandlers != null) {
            for (LocationHandler dataHandler : this.dataHandlers) {
                dataHandler.reloadData();
            }
        }
    }

    @Override
    public synchronized OMGraphicList prepare() {
        OMGraphicList omGraphicList = new OMGraphicList();
        omGraphicList.setTraverseMode(1);
        Projection projection = this.getProjection();
        if (projection == null) {
            if (Debug.debugging("location")) {
                Debug.output(this.getName() + "|LocationLayer.prepare(): null projection, layer not ready.");
            }
            return omGraphicList;
        }
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "|LocationLayer.prepare(): doing it");
        }
        if (this.useDeclutterMatrix && this.declutterMatrix != null) {
            this.declutterMatrix.setWidth(projection.getWidth());
            this.declutterMatrix.setHeight(projection.getHeight());
            this.declutterMatrix.create();
        }
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "|LocationLayer.prepare(): " + "calling prepare with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        Object ul = projection.getUpperLeft();
        Object lr = projection.getLowerRight();
        if (Debug.debugging("location")) {
            double delta = ((Point2D)lr).getX() - ((Point2D)ul).getX();
            Debug.output(this.getName() + "|LocationLayer.prepare(): " + " ul.lon =" + ((Point2D)ul).getX() + " lr.lon = " + ((Point2D)lr).getY() + " delta = " + delta);
        }
        if (this.dataHandlers != null) {
            for (LocationHandler dataHandler : this.dataHandlers) {
                dataHandler.get((float)((Point2D)ul).getY(), (float)((Point2D)ul).getX(), (float)((Point2D)lr).getY(), (float)((Point2D)lr).getX(), omGraphicList);
            }
        }
        int size = 0;
        if (omGraphicList != null) {
            size = omGraphicList.size();
            if (Debug.debugging("basic")) {
                Debug.output(this.getName() + "|LocationLayer.prepare(): finished with " + size + " graphics");
            }
            for (OMGraphic thingy : omGraphicList) {
                if (this.useDeclutterMatrix && thingy instanceof Location) {
                    ((Location)thingy).generate(projection, this.declutterMatrix);
                    continue;
                }
                thingy.generate(projection);
            }
        } else if (Debug.debugging("basic")) {
            Debug.output(this.getName() + "|LocationLayer.prepare(): finished with null graphics list");
        }
        return omGraphicList;
    }

    @Override
    public void paint(Graphics g) {
        OMGraphicList omgList;
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "|LocationLayer.paint()");
        }
        if ((omgList = this.getList()) != null) {
            for (OMGraphic omg : omgList) {
                if (omg instanceof Location) {
                    ((Location)omg).renderLocation(g);
                    continue;
                }
                omg.render(g);
            }
            for (OMGraphic omg : omgList) {
                if (!(omg instanceof Location)) continue;
                ((Location)omg).renderName(g);
            }
        } else if (Debug.debugging("location")) {
            Debug.error(this.getName() + "|LocationLayer: paint(): Null list...");
        }
    }

    protected void setLocationHandlers(String prefix, Properties p) {
        String sPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String handlersValue = p.getProperty(sPrefix + LocationHandlerListProperty);
        if (Debug.debugging("location")) {
            Debug.output(this.getName() + "| handlers = \"" + handlersValue + "\"");
        }
        if (handlersValue == null) {
            if (Debug.debugging("location")) {
                Debug.output("No property \"" + prefix + LocationHandlerListProperty + "\" found in application properties.");
            }
            return;
        }
        Vector<String> handlerNames = PropUtils.parseSpacedMarkers(handlersValue);
        for (String handlerName : handlerNames) {
            String classProperty = handlerName + ".class";
            String className = p.getProperty(classProperty);
            if (className == null) {
                Debug.error("Failed to locate property \"" + classProperty + "\"\nSkipping handler \"" + handlerName + "\"");
                continue;
            }
            try {
                Object obj;
                if (Debug.debugging("location")) {
                    Debug.output("OpenMap.getHandlers():instantiating handler \"" + className + "\"");
                }
                if (!((obj = Class.forName(className).newInstance()) instanceof LocationHandler)) continue;
                LocationHandler lh = (LocationHandler)obj;
                lh.setProperties(handlerName, p);
                lh.setLayer(this);
                this.dataHandlers.add(lh);
            }
            catch (ClassNotFoundException e) {
                Debug.error("Handler class not found: \"" + className + "\"\nSkipping handler \"" + handlerName + "\"");
            }
            catch (IOException e) {
                Debug.error("IO Exception instantiating class \"" + className + "\"\nSkipping handler \"" + handlerName + "\"");
            }
            catch (Exception e) {
                Debug.error("Exception instantiating class \"" + className + "\": " + e);
            }
        }
    }

    @Override
    public void removed(Container cont) {
        if (this.dataHandlers != null) {
            for (LocationHandler dataHandler : this.dataHandlers) {
                dataHandler.removed(cont);
            }
        }
    }

    public void setLocationHandlers(LocationHandler[] handlers) {
        for (LocationHandler handler : this.dataHandlers) {
            handler.removed(null);
        }
        this.dataHandlers.clear();
        for (LocationHandler dataHandler : handlers) {
            dataHandler.setLayer(this);
            this.dataHandlers.add(dataHandler);
        }
        this.resetPalette();
    }

    public LocationHandler[] getLocationHandlers() {
        return this.dataHandlers.toArray(new LocationHandler[this.dataHandlers.size()]);
    }

    @Override
    protected void resetPalette() {
        this.box = null;
        super.resetPalette();
    }

    @Override
    protected WindowSupport createWindowSupport() {
        return new WindowSupport(this.getGUI(), this.getName());
    }

    @Override
    public Component getGUI() {
        if (this.box == null) {
            this.box = Box.createVerticalBox();
            int nHandlers = 0;
            if (this.dataHandlers != null) {
                nHandlers = this.dataHandlers.size();
            }
            Box box2 = Box.createVerticalBox();
            for (LocationHandler dataHandler : this.dataHandlers) {
                Component guiComponent = dataHandler.getGUI();
                if (guiComponent == null) continue;
                JPanel panel = PaletteHelper.createPaletteJPanel(dataHandler.getPrettyName());
                panel.add(dataHandler.getGUI());
                box2.add(panel);
            }
            JScrollPane scrollPane = new JScrollPane(box2, 20, 30);
            scrollPane.setAlignmentX(0.5f);
            scrollPane.setAlignmentY(0.0f);
            this.box.add(scrollPane);
            if (this.declutterMatrix != null) {
                JPanel dbp = new JPanel(new GridLayout(0, 1));
                this.declutterButton = new JCheckBox(this.i18n.get(LocationLayer.class, "declutterNames", "Declutter Names"), this.useDeclutterMatrix);
                this.declutterButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        JCheckBox jcb = (JCheckBox)ae.getSource();
                        LocationLayer.this.useDeclutterMatrix = jcb.isSelected();
                        if (LocationLayer.this.isVisible()) {
                            LocationLayer.this.doPrepare();
                        }
                    }
                });
                this.declutterButton.setToolTipText(this.i18n.get(LocationLayer.class, "declutterNames", 3, "<HTML><BODY>Move location names so they don't overlap.<br>This may take awhile if you are zoomed out.</BODY></HTML>"));
                dbp.add(this.declutterButton);
                this.box.add(dbp);
            }
        }
        return this.box;
    }

    @Override
    public String getToolTipTextFor(OMGraphic omg) {
        String ttText = null;
        if (omg instanceof Location) {
            ttText = ((Location)omg).getName();
        }
        return ttText;
    }

    @Override
    public List<Component> getItemsForOMGraphicMenu(OMGraphic omg) {
        Location loc;
        LocationHandler lh;
        if (omg instanceof Location && (lh = (loc = (Location)omg).getLocationHandler()) != null) {
            return lh.getItemsForPopupMenu(loc);
        }
        return null;
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + UseDeclutterMatrixProperty, new Boolean(this.useDeclutterMatrix).toString());
        if (this.declutterMatrix != null) {
            props.put(prefix + DeclutterMatrixClassProperty, this.declutterMatrix.getClass().getName());
            props.put(prefix + AllowPartialsProperty, new Boolean(this.declutterMatrix.isAllowPartials()).toString());
        }
        StringBuffer handlerList = new StringBuffer();
        if (this.dataHandlers != null) {
            for (LocationHandler dataHandler : this.dataHandlers) {
                dataHandler.getProperties(props);
            }
        }
        props.put(prefix + LocationHandlerListProperty, handlerList.toString());
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        PropUtils.setI18NPropertyInfo(this.i18n, list, LocationLayer.class, UseDeclutterMatrixProperty, "Use Declutter Matrix", "Flag for using the declutter matrix.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, LocationLayer.class, DeclutterMatrixClassProperty, "Declutter Matrix Class", "Class name of the declutter matrix to use (com.bbn.openmap.layer.DeclutterMatrix).", null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, LocationLayer.class, AllowPartialsProperty, "Allow partials", "Flag to allow labels to run off the edge of the map.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, LocationLayer.class, LocationHandlerListProperty, "Location Handlers", "Space-separated list of unique names to use to scope the LocationHandler property definitions.", null);
        if (this.dataHandlers != null) {
            for (LocationHandler dataHandler : this.dataHandlers) {
                dataHandler.getPropertyInfo(list);
            }
        }
        return list;
    }
}

