/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ScaleDisplayLayer
extends OMGraphicHandlerLayer {
    protected Logger logger = Logger.getLogger("com.bbn.openmap.layer.ScaleDisplayLayer");
    protected Color lineColor = null;
    protected Color textColor = null;
    protected String defaultLineColorString = "FFFFFF";
    protected String defaultTextColorString = "FFFFFF";
    protected String defaultUnitOfMeasureString = "km";
    protected int defaultLocationXoffset = -10;
    protected int defaultLocationYoffset = -10;
    protected int defaultWidth = 150;
    protected int defaultHeight = 10;
    public static final String UnitOfMeasureProperty = "unitOfMeasure";
    public static final String LocationXOffsetProperty = "locationXoffset";
    public static final String LocationYOffsetProperty = "locationYoffset";
    public static final String WidthProperty = "width";
    public static final String HeightProperty = "height";
    protected String unitOfMeasure = null;
    protected Length uom = Length.get(this.defaultUnitOfMeasureString);
    protected String uomAbbr = this.uom.getAbbr();
    protected int locationXoffset = this.defaultLocationXoffset;
    protected int locationYoffset = this.defaultLocationYoffset;
    protected int width = this.defaultWidth;
    protected int height = this.defaultHeight;
    protected DrawingAttributes dAttributes = DrawingAttributes.getDefaultClone();
    JPanel palettePanel;
    ButtonGroup uomButtonGroup;
    Vector<JRadioButton> buttons = new Vector();

    public ScaleDisplayLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setUnitOfMeasure(Length.KM.toString());
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.dAttributes.setProperties(prefix, properties);
        String unitOfMeasureString = properties.getProperty(prefix + UnitOfMeasureProperty);
        if (unitOfMeasureString != null) {
            this.setUnitOfMeasure(unitOfMeasureString);
        }
        this.locationXoffset = PropUtils.intFromProperties(properties, prefix + LocationXOffsetProperty, this.defaultLocationXoffset);
        this.locationYoffset = PropUtils.intFromProperties(properties, prefix + LocationYOffsetProperty, this.defaultLocationYoffset);
        this.width = PropUtils.intFromProperties(properties, prefix + WidthProperty, this.defaultWidth);
        this.height = PropUtils.intFromProperties(properties, prefix + HeightProperty, this.defaultHeight);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        this.dAttributes.setProperties(props);
        props.put(prefix + LocationXOffsetProperty, Integer.toString(this.locationXoffset));
        props.put(prefix + LocationYOffsetProperty, Integer.toString(this.locationYoffset));
        props.put(prefix + WidthProperty, Integer.toString(this.width));
        props.put(prefix + HeightProperty, Integer.toString(this.height));
        props.put(prefix + UnitOfMeasureProperty, this.unitOfMeasure);
        return props;
    }

    public synchronized OMGraphicList prepare() {
        int left_x = 0;
        int right_x = 0;
        int lower_y = 0;
        int upper_y = 0;
        Projection projection = this.getProjection();
        OMGraphicList graphics = new OMGraphicList();
        int w = projection.getWidth();
        int h = projection.getHeight();
        if (this.locationXoffset < 0) {
            left_x = w + this.locationXoffset - this.width;
            right_x = w + this.locationXoffset;
        } else if (this.locationXoffset >= 0) {
            left_x = this.locationXoffset;
            right_x = this.locationXoffset + this.width;
        }
        if (this.locationYoffset < 0) {
            upper_y = h + this.locationYoffset - this.height;
            lower_y = h + this.locationYoffset;
        } else if (this.locationYoffset >= 0) {
            upper_y = this.locationYoffset;
            lower_y = this.locationYoffset + this.height;
        }
        graphics.clear();
        OMLine line = new OMLine(left_x, lower_y, right_x, lower_y);
        this.dAttributes.setTo(line);
        graphics.add(line);
        line = new OMLine(left_x, lower_y, left_x, upper_y);
        this.dAttributes.setTo(line);
        graphics.add(line);
        line = new OMLine(right_x, lower_y, right_x, upper_y);
        this.dAttributes.setTo(line);
        graphics.add(line);
        int y = h / 2;
        int x = w / 2;
        int xSide = (right_x - left_x) / 2;
        LatLonPoint loc1 = projection.inverse(x - xSide, y, new LatLonPoint.Double());
        LatLonPoint loc2 = projection.inverse(x + xSide, y, new LatLonPoint.Double());
        double dist = this.uom.fromRadians(loc1.distance(loc2));
        String outtext = dist < 1.0 ? String.format("%.3f %s", dist, this.uomAbbr) : (dist < 10.0 ? String.format("%.2f %s", dist, this.uomAbbr) : (dist < 100.0 ? String.format("%.1f %s", dist, this.uomAbbr) : String.format("%.0f %s", dist, this.uomAbbr)));
        OMText text = new OMText((left_x + right_x) / 2, lower_y - 3, "" + outtext, 1);
        Font font = text.getFont();
        text.setFont(font.deriveFont(font.getStyle(), font.getSize() + 4));
        this.dAttributes.setTo(text);
        text.setTextMatteColor((Color)this.dAttributes.getMattingPaint());
        text.setTextMatteStroke(new BasicStroke(5.0f));
        text.setMattingPaint(OMColor.clear);
        graphics.add(text);
        graphics.generate(projection);
        return graphics;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        if (unitOfMeasure == null) {
            unitOfMeasure = Length.KM.toString();
        }
        this.unitOfMeasure = unitOfMeasure;
        Length[] choices = Length.values();
        this.uom = null;
        for (int i = 0; i < choices.length; ++i) {
            if (!unitOfMeasure.equalsIgnoreCase(choices[i].toString()) && !unitOfMeasure.equalsIgnoreCase(choices[i].getAbbr())) continue;
            this.uom = choices[i];
            break;
        }
        if (this.uom == null) {
            this.uom = Length.KM;
        }
        this.uomAbbr = this.uom.getAbbr();
    }

    public Component getGUI() {
        if (this.palettePanel == null) {
            this.logger.fine("creating palette.");
            this.palettePanel = new JPanel();
            this.uomButtonGroup = new ButtonGroup();
            this.palettePanel.setLayout(new BoxLayout(this.palettePanel, 1));
            this.palettePanel.setBorder(new TitledBorder("Unit Of Measure"));
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadioButton jrb = (JRadioButton)e.getSource();
                    ScaleDisplayLayer.this.setUnitOfMeasure(jrb.getText());
                }
            };
            for (Length lengthType : Length.values()) {
                JRadioButton jrb = new JRadioButton();
                jrb.setText(lengthType.getAbbr());
                jrb.setToolTipText(lengthType.toString());
                this.uomButtonGroup.add(jrb);
                this.palettePanel.add(jrb);
                jrb.addActionListener(al);
                jrb.setSelected(this.unitOfMeasure.equalsIgnoreCase(lengthType.getAbbr()));
                this.buttons.add(jrb);
            }
        } else {
            for (JRadioButton button : this.buttons) {
                button.setSelected(this.uom.getAbbr().equalsIgnoreCase(button.getText()));
            }
        }
        return this.palettePanel;
    }
}

