/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.BufferedImageRenderPolicy;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.EditableOMPoly;
import com.bbn.openmap.omGraphics.FontSizer;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMArc;
import com.bbn.openmap.omGraphics.OMAreaList;
import com.bbn.openmap.omGraphics.OMBitmap;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMDecoratedSpline;
import com.bbn.openmap.omGraphics.OMEllipse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMScalingIcon;
import com.bbn.openmap.omGraphics.OMShape;
import com.bbn.openmap.omGraphics.OMSpline;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.omGraphics.awt.CircleShapeDecoration;
import com.bbn.openmap.omGraphics.awt.LineShapeDecoration;
import com.bbn.openmap.omGraphics.awt.ShapeDecorator;
import com.bbn.openmap.omGraphics.labeled.LabeledOMSpline;
import com.bbn.openmap.omGraphics.meteo.IceAreaShapeDecoration;
import com.bbn.openmap.omGraphics.meteo.OMHotSurfaceFront;
import com.bbn.openmap.omGraphics.meteo.OMOcclusion;
import com.bbn.openmap.omGraphics.util.ArcCalc;
import com.bbn.openmap.omGraphics.util.RibbonMaker;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolReferenceLibrary;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoLayer
extends OMGraphicHandlerLayer
implements DrawingToolRequestor {
    protected JPanel legend;
    protected DrawingTool drawingTool;
    protected SymbolReferenceLibrary srl;
    protected final DrawingToolRequestor layer = this;
    protected static final String internalKey = "ik";
    protected static final String externalKey = "ek";
    protected GraphicAttributes filterGA = null;
    protected OMGraphicList objects;
    private String RCT = "rightClickTest";

    public DemoLayer() {
        this.setName("Demo");
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setRenderPolicy(new BufferedImageRenderPolicy(this));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.legend != null) {
            this.legend.paint(g);
        }
    }

    public OMGraphicList init() {
        OMGraphicList omList = new OMGraphicList();
        int bytearrsize = 32;
        byte[] bytearr = new byte[bytearrsize];
        for (int i = 0; i < bytearr.length; ++i) {
            bytearr[i] = -1;
        }
        OMBitmap omb = new OMBitmap(45.3583f, -71.06f, 16, 16, bytearr);
        omb.setLinePaint(Color.red);
        omb.setFillPaint(null);
        omb.setSelectPaint(Color.blue);
        omb.setRotationAngle(1.5707963267948966);
        omb.putAttribute(this.RCT, "bitmap");
        omList.add(omb);
        OMPoint point = new OMPoint(42.0, -72.0, 14);
        point.setFillPaint(Color.green);
        point.setOval(true);
        omList.add(point);
        OMCircle circle = new OMCircle(40.0, -70.0, 50, 200);
        circle.setRotationAngle(0.7853981852531433);
        circle.putAttribute("Label", new OMTextLabeler("Circle Label", 1));
        circle.putAttribute(this.RCT, "circle");
        omList.add(circle);
        int[] llPointsx = new int[5];
        int[] llPointsy = new int[5];
        llPointsy[0] = 10;
        llPointsx[0] = 170;
        llPointsy[1] = 42;
        llPointsx[1] = 273;
        llPointsy[2] = 38;
        llPointsx[2] = 374;
        llPointsy[3] = 78;
        llPointsx[3] = 468;
        llPointsy[4] = 84;
        llPointsx[4] = 369;
        LabeledOMSpline spline = new LabeledOMSpline(40.0f, -72.0f, llPointsx, llPointsy, 0);
        spline.setText("Testing");
        spline.setLocateAtCenter(true);
        spline.putAttribute(this.RCT, "spline 1");
        omList.add(spline);
        OMSpline spline2 = new OMSpline(llPointsx, llPointsy);
        spline2.putAttribute("Label", new OMTextLabeler("Spline Label"));
        spline2.setLinePaint(Color.green);
        spline2.putAttribute(this.RCT, "spline 2");
        omList.add(spline2);
        double[] llPoints = new double[]{55.0, -10.0, 50.0, -5.0, 45.0, -7.0, 43.0, -12.0, 55.0, -10.0};
        OMDecoratedSpline omds = new OMDecoratedSpline(llPoints, 0, 1);
        ShapeDecorator sd = new ShapeDecorator();
        sd.addDecoration(new LineShapeDecoration(5.0f, OMColor.clear));
        sd.addDecoration(new IceAreaShapeDecoration(7, 7, 1));
        omds.setDecorator(sd);
        omList.add(omds);
        llPoints = new double[]{56.0, -11.0, 51.0, -6.0, 46.0, -8.0, 44.0, -13.0, 56.0, -11.0};
        omds = new OMDecoratedSpline(llPoints, 0, 1);
        sd = new ShapeDecorator();
        sd.addDecoration(new LineShapeDecoration(3.0f, OMColor.clear));
        sd.addDecoration(new CircleShapeDecoration(5, 5, Color.blue));
        omds.setDecorator(sd);
        omList.add(omds);
        llPoints = new double[]{57.0, -12.0, 52.0, -7.0, 47.0, -9.0, 45.0, -14.0, 57.0, -12.0};
        omds = new OMDecoratedSpline(llPoints, 0, 1);
        sd = new ShapeDecorator();
        sd.addDecoration(new LineShapeDecoration(2.0f, OMColor.clear));
        sd.addDecoration(new CircleShapeDecoration(5, 5, Color.red));
        sd.addDecoration(new LineShapeDecoration(2.0f, OMColor.clear));
        sd.addDecoration(new LineShapeDecoration(15.0f, Color.red));
        omds.setDecorator(sd);
        omList.add(omds);
        double[] llPoints2 = new double[]{55.0, -12.0, 50.0, -7.0, 45.0, -9.0, 43.0, -14.0};
        OMHotSurfaceFront hf = new OMHotSurfaceFront(llPoints2, 0, 1);
        omList.add(hf);
        double[] llPoints3 = new double[]{55.0, -14.0, 50.0, -9.0, 45.0, -11.0, 43.0, -16.0};
        OMOcclusion oc = new OMOcclusion(llPoints3, 0, 1);
        omList.add(oc);
        OMLine line = new OMLine(40.0, -75.0, 42.0, -70.0, 3);
        line.addArrowHead(2);
        line.setStroke(new BasicStroke(2.0f));
        line.putAttribute("Label", new OMTextLabeler("Line Label"));
        omList.add(line);
        OMLine arcLine = new OMLine(0.0, 0.0, -20.0, 30.0, 3);
        arcLine.setLinePaint(Color.green);
        arcLine.setArc(new ArcCalc(Math.PI, true));
        omList.add(arcLine);
        OMGraphicList pointList = new OMGraphicList();
        for (int i = 0; i < 100; ++i) {
            point = new OMPoint((float)(Math.random() * 89.0), (float)(Math.random() * -179.0), 3);
            point.setSelectPaint(Color.yellow);
            point.putAttribute(this.RCT, "Point " + i);
            pointList.add(point);
        }
        omList.add(pointList);
        OMEllipse ell = new OMEllipse(new LatLonPoint.Double(60.0, -110.0), 1000.0, 300.0, Length.NM, 0.7853981852531433);
        ell.setLinePaint(Color.blue);
        omList.add(ell);
        ell = new OMEllipse(new LatLonPoint.Double(40.0, -75.0), 800.0, 250.0, Length.MILE, 0.0);
        ell.setFillPaint(Color.yellow);
        omList.add(ell);
        double[] llp2 = new double[]{0.4178975522518158, -1.435302972793579, 0.41813868284225464, -1.396774411201477};
        OMPoly p2 = new OMPoly(llp2, 1, 2);
        p2.setLinePaint(Color.yellow);
        omList.add(p2);
        OMArc arc = new OMArc(40.0, 65.0, 750.0, Length.MILE, 20.0, 95.0);
        arc.setLinePaint(Color.red);
        arc.setFillPaint(new Color(120, 0, 0, 128));
        arc.setArcType(0);
        arc.putAttribute("Label", new OMTextLabeler("Arc Label", 1));
        omList.add(arc);
        OMAreaList combo = new OMAreaList();
        combo.addOMGraphic(new OMLine(50.45333480834961, 5.223888874053955, 50.37527847290039, 4.873888969421387, 2));
        combo.addOMGraphic(new OMLine(50.37527847290039, 4.873888969421387, 50.43694305419922, 4.860556125640869, 2));
        combo.addOMGraphic(new OMArc(50.49127f, 4.704239f, 0.0916852056980133, 118.41944885253906, -90.21759033203125));
        combo.addOMGraphic(new OMLine(50.5341682434082, 4.831110954284668, 50.64083480834961, 4.832221984863281, 2));
        combo.addOMGraphic(new OMLine(50.64083480834961, 4.832221984863281, 50.54777908325195, 5.223888874053955, 2));
        combo.addOMGraphic(new OMLine(50.54777908325195, 5.223888874053955, 50.45333480834961, 5.223888874053955, 2));
        combo.setLinePaint(Color.blue);
        combo.setFillPaint(Color.green);
        omList.add(combo);
        OMAreaList combo1 = new OMAreaList();
        combo1.addOMGraphic(new OMLine(66.61852264404297, 141.56349182128906, 66.02824401855469, 140.1939697265625, 3));
        combo1.addOMGraphic(new OMLine(66.02824401855469, 140.1939697265625, 66.96805572509766, 137.6110382080078, 2));
        combo1.addOMGraphic(new OMLine(66.96805572509766, 137.6110382080078, 67.55825805664062, 139.03395080566406, 3));
        combo1.addOMGraphic(new OMLine(67.55825805664062, 139.03395080566406, 66.61852264404297, 141.56349182128906, 2));
        combo1.setLinePaint(Color.red);
        combo1.setFillPaint(Color.blue);
        omList.add(combo1);
        combo1 = new OMAreaList();
        combo1.addOMGraphic(new OMLine(65.49527740478516, 55.488887786865234, 65.02278137207031, 55.74917f, 3));
        combo1.addOMGraphic(new OMLine(65.02278137207031, 55.74917f, 64.97027587890625, 55.20861053466797, 2));
        combo1.addOMGraphic(new OMLine(64.97027587890625, 55.20861053466797, 65.44277954101562, 54.94889f, 3));
        combo1.addOMGraphic(new OMLine(65.44277954101562, 54.94889f, 65.49527740478516, 55.488887786865234, 2));
        combo1.setLinePaint(Color.blue);
        combo1.setFillPaint(Color.red);
        omList.add(combo1);
        OMText text = new OMText(30.0, 80.0, "Testing FontSizer", 1);
        text.setFontSizer(new FontSizer(3.0E7f, 1, 5, 40));
        omList.add(text);
        if (this.srl != null) {
            ImageIcon ii = this.srl.getIcon("SFPPV-----*****", new Dimension(200, 200));
            if (ii != null) {
                OMScalingIcon omsi = new OMScalingIcon(20.0, -50.0, ii);
                omsi.setBaseScale(4000000.0f);
                omsi.setMinScale(1000000.0f);
                omsi.setMaxScale(6000000.0f);
                omsi.setRotationAngle(0.7853981633974483);
                omsi.putAttribute("Label", new OMTextLabeler("SFPPV-----*****", 0, 5));
                omsi.putAttribute("norotate", Boolean.TRUE);
                omList.add(omsi);
                SymbolPart sp = this.srl.getSymbolPartForCode("SFPPV-----*****");
                if (sp != null) {
                    omsi.putAttribute("Tooltip", sp.getDescription());
                }
                omsi = new OMScalingIcon(43.0, -70.0, ii);
                omsi.setBaseScale(500000.0f);
                omsi.setMinScale(500000.0f);
                omsi.setMaxScale(500000.0f);
                omsi.setRotationAngle(-0.7853981633974483);
                omsi.putAttribute("Label", new OMTextLabeler("SFPPV-----*****", 0, 5));
                omsi.putAttribute("norotate", Boolean.TRUE);
                omList.add(omsi);
                if (sp != null) {
                    omsi.putAttribute("Tooltip", sp.getDescription());
                }
            } else {
                Debug.output("DemoLayer: couldn't create symbol from SymbolReferenceLibrary");
            }
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo(20.0f, 20.0f);
        gp.lineTo(20.0f, -20.0f);
        gp.lineTo(-20.0f, -20.0f);
        gp.lineTo(-20.0f, 20.0f);
        gp.lineTo(20.0f, 20.0f);
        gp.moveTo(10.0f, 10.0f);
        gp.lineTo(10.0f, -10.0f);
        gp.lineTo(-10.0f, -10.0f);
        gp.lineTo(-10.0f, 10.0f);
        gp.lineTo(10.0f, 10.0f);
        OMShape oms = new OMShape(gp);
        oms.setFillPaint(Color.orange);
        omList.add(oms);
        OMGraphicList geoTest = new OMGraphicList();
        LatLonPoint.Double pnt1 = new LatLonPoint.Double(42.0, -71.0);
        LatLonPoint.Double pnt2 = new LatLonPoint.Double(42.3, -70.678);
        double gspacing = Length.MILE.toRadians(5.0f);
        OMCircle ompoint1 = new OMCircle(((Point2D)pnt1).getY(), ((Point2D)pnt1).getX(), gspacing, Length.RADIAN);
        OMCircle ompoint2 = new OMCircle(((Point2D)pnt2).getY(), ((Point2D)pnt2).getX(), gspacing, Length.RADIAN);
        LatLonPoint int1 = GreatCircle.pointAtDistanceBetweenPoints(((LatLonPoint)pnt1).getRadLat(), ((LatLonPoint)pnt1).getRadLon(), ((LatLonPoint)pnt2).getRadLat(), ((LatLonPoint)pnt2).getRadLon(), gspacing, -1);
        LatLonPoint int2 = GreatCircle.pointAtDistanceBetweenPoints(((LatLonPoint)pnt2).getRadLat(), ((LatLonPoint)pnt2).getRadLon(), ((LatLonPoint)pnt1).getRadLat(), ((LatLonPoint)pnt1).getRadLon(), gspacing, -1);
        OMLine geoline = new OMLine(int1.getY(), int1.getX(), int2.getY(), int2.getX(), 3);
        ompoint1.setLinePaint(Color.red);
        ompoint2.setLinePaint(Color.red);
        geoline.setLinePaint(Color.red);
        geoTest.add(ompoint1);
        geoTest.add(ompoint2);
        geoTest.add(geoline);
        omList.add(geoTest);
        OMText omtest = new OMText(42.0, -71.0, "Testing how this looks\nwhen doing multiple lines", 0);
        omtest.setBaseline(2);
        omtest.setFillPaint(Color.red);
        omList.add(omtest);
        llPoints = new double[]{-5.856972964554054E-4, 7.181106520146243E-5, -5.856972964554055E-4, -7.181106520146255E-5, -2.9284864843698565E-4, -7.18110652014625E-5, 5.856972969587945E-4, -5.756442432493538E-4, 5.856972969587943E-4, 5.756442432493541E-4, -2.9284864843698565E-4, 7.181106520146243E-5, -5.856972964554054E-4, 7.181106520146243E-5};
        double buffer = 0.1645788336933045;
        for (int i = 0; i < llPoints.length - 1; i += 2) {
            double lat = Math.toDegrees(llPoints[i]);
            double lon = Math.toDegrees(llPoints[i + 1]);
            OMText txt = new OMText(lat, lon, Integer.toString(i / 2), 0);
            omList.add(txt);
        }
        RibbonMaker ribbonMaker = RibbonMaker.createFromRadians(llPoints);
        OMAreaList omg = ribbonMaker.getOuterRing(Length.NM.toRadians(buffer));
        omg.setLinePaint(Color.red);
        omList.add(omg);
        OMPoly ribbonPoly = new OMPoly(llPoints, 1, 3);
        ribbonPoly.setLinePaint(Color.orange);
        omList.add(ribbonPoly);
        OMEllipse ome1 = new OMEllipse(new LatLonPoint.Double(20.0, -110.0), 600.0, 300.0, Length.MILE, 0.0);
        ome1.setLinePaint(Color.cyan);
        omList.add(ome1);
        OMEllipse ome4 = new OMEllipse(new LatLonPoint.Double(20.0, -110.0), 600.0, 300.0, Length.MILE, Math.toRadians(45.0));
        ome4.setLinePaint(Color.red);
        omList.add(ome4);
        OMEllipse ome2 = new OMEllipse(new LatLonPoint.Double(20.0, -110.0), 600.0, 300.0, Length.MILE, Math.toRadians(60.0));
        ome2.setLinePaint(Color.orange);
        omList.add(ome2);
        OMEllipse ome3 = new OMEllipse(new LatLonPoint.Double(20.0, -110.0), 600.0, 300.0, Length.MILE, Math.toRadians(115.0));
        ome3.setLinePaint(Color.green);
        omList.add(ome3);
        OMEllipse ome5 = new OMEllipse(new LatLonPoint.Double(20.0, -110.0), 600.0, 300.0, Length.MILE, Math.toRadians(135.0));
        ome5.setLinePaint(Color.MAGENTA);
        omList.add(ome5);
        return omList;
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.setAddToBeanContext(true);
    }

    @Override
    public synchronized OMGraphicList prepare() {
        if (this.objects == null) {
            this.objects = this.init();
        }
        OMGraphicList list = new OMGraphicList();
        list.addAll(this.objects);
        list.generate(this.getProjection());
        return list;
    }

    protected GraphicAttributes getFilterGA() {
        if (this.filterGA == null) {
            this.filterGA = new GraphicAttributes();
            this.filterGA.setLinePaint(Color.red);
            this.filterGA.setRenderType(1);
            this.filterGA.setLineType(3);
            BasicStroke filterStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
            this.filterGA.setStroke(filterStroke);
        }
        return (GraphicAttributes)this.filterGA.clone();
    }

    @Override
    public Component getGUI() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        JPanel box = PaletteHelper.createVerticalPanel(" Create Filters for Map ");
        box.setLayout(new GridLayout(0, 1));
        JButton button = new JButton("Create Containing Rectangle Filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawingTool dt = DemoLayer.this.getDrawingTool();
                if (dt != null) {
                    GraphicAttributes fga = DemoLayer.this.getFilterGA();
                    fga.setFillPaint(new OMColor(0xC0A0A0A));
                    OMRect rect = (OMRect)DemoLayer.this.getDrawingTool().create("com.bbn.openmap.omGraphics.OMRect", fga, DemoLayer.this.layer, false);
                    if (rect != null) {
                        rect.putAttribute("APP_OBJECT", DemoLayer.internalKey);
                    } else {
                        Debug.error("DemoLayer: Drawing tool can't create OMRect");
                    }
                } else {
                    Debug.output("DemoLayer can't find a drawing tool");
                }
            }
        });
        box.add(button);
        button = new JButton("Create Containing Polygon Filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawingTool dt = DemoLayer.this.getDrawingTool();
                if (dt != null) {
                    GraphicAttributes fga = DemoLayer.this.getFilterGA();
                    fga.setFillPaint(OMColor.clear);
                    EditableOMPoly eomp = new EditableOMPoly(fga);
                    eomp.setEnclosed(true);
                    eomp.setShowGUI(false);
                    dt.setBehaviorMask(10);
                    OMPoly poly = (OMPoly)DemoLayer.this.getDrawingTool().edit(eomp, DemoLayer.this.layer);
                    if (poly != null) {
                        poly.setIsPolygon(true);
                        poly.putAttribute("APP_OBJECT", DemoLayer.internalKey);
                    } else {
                        Debug.error("DemoLayer: Drawing tool can't create OMPoly");
                    }
                } else {
                    Debug.output("DemoLayer can't find a drawing tool");
                }
            }
        });
        box.add(button);
        button = new JButton("Create Excluding Rectangle Filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawingTool dt = DemoLayer.this.getDrawingTool();
                if (dt != null) {
                    GraphicAttributes fga = DemoLayer.this.getFilterGA();
                    fga.setFillPaint(OMColor.clear);
                    OMRect rect = (OMRect)DemoLayer.this.getDrawingTool().create("com.bbn.openmap.omGraphics.OMRect", fga, DemoLayer.this.layer, false);
                    if (rect != null) {
                        rect.putAttribute("APP_OBJECT", DemoLayer.externalKey);
                    } else {
                        Debug.error("DemoLayer: Drawing tool can't create OMRect");
                    }
                } else {
                    Debug.output("DemoLayer can't find a drawing tool");
                }
            }
        });
        box.add(button);
        button = new JButton("Reset filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DemoLayer.this.resetFiltering();
                DemoLayer.this.repaint();
            }
        });
        box.add(button);
        gridbag.setConstraints(box, c);
        panel.add(box);
        return panel;
    }

    public DrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    public void setDrawingTool(DrawingTool dt) {
        this.drawingTool = dt;
    }

    @Override
    public void drawingComplete(OMGraphic omg, OMAction action) {
        Debug.message("demo", "DemoLayer: DrawingTool complete");
        Object obj = omg.getAttribute("APP_OBJECT");
        if (!(obj == null || obj != internalKey && obj != externalKey || action.isMask(4))) {
            GeneralPath filterShape = omg.getShape();
            OMGraphicList filteredList = this.filter(filterShape, omg.getAttribute("APP_OBJECT") == internalKey);
            if (Debug.debugging("demo")) {
                Debug.output("DemoLayer filter: " + filteredList.getDescription());
            }
        } else if (!this.doAction(omg, action)) {
            this.setList(new OMGraphicList());
            this.doAction(omg, action);
        }
        this.repaint();
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof DrawingTool) {
            Debug.message("demo", "DemoLayer: found a drawing tool");
            this.setDrawingTool((DrawingTool)someObj);
        }
        if (someObj instanceof SymbolReferenceLibrary) {
            this.setSymbolReferenceLibrary((SymbolReferenceLibrary)someObj);
        }
    }

    public void setSymbolReferenceLibrary(SymbolReferenceLibrary library) {
        this.srl = library;
    }

    public SymbolReferenceLibrary getSymbolReferenceLibrary() {
        return this.srl;
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof DrawingTool && this.getDrawingTool() == (DrawingTool)someObj) {
            this.setDrawingTool(null);
        }
    }

    @Override
    public boolean isHighlightable(OMGraphic omg) {
        return true;
    }

    @Override
    public boolean isSelectable(OMGraphic omg) {
        DrawingTool dt = this.getDrawingTool();
        return dt != null && dt.canEdit(omg.getClass());
    }

    @Override
    public String getInfoText(OMGraphic omg) {
        DrawingTool dt = this.getDrawingTool();
        if (dt != null && dt.canEdit(omg.getClass())) {
            return "Click to edit graphic.";
        }
        return null;
    }

    @Override
    public String getToolTipTextFor(OMGraphic omg) {
        Object tt = omg.getAttribute("Tooltip");
        if (tt instanceof String) {
            return (String)tt;
        }
        String classname = omg.getClass().getName();
        int lio = classname.lastIndexOf(46);
        if (lio != -1) {
            classname = classname.substring(lio + 1);
        }
        return "Demo Layer Object: " + classname;
    }

    @Override
    public void select(OMGraphicList list) {
        if (list != null && !list.isEmpty()) {
            OMGraphic omg = list.getOMGraphicAt(0);
            DrawingTool dt = this.getDrawingTool();
            if (dt != null && dt.canEdit(omg.getClass())) {
                dt.setBehaviorMask(10);
                if (dt.edit(omg, (DrawingToolRequestor)this) == null) {
                    this.fireRequestInfoLine("Can't figure out how to modify this object.");
                }
            }
        }
    }

    @Override
    public List<Component> getItemsForMapMenu(MapMouseEvent me) {
        ArrayList<Component> l = new ArrayList<Component>();
        l.add(new JMenuItem("When"));
        l.add(new JMenuItem("Where"));
        l.add(new JMenuItem("How"));
        return l;
    }

    @Override
    public List<Component> getItemsForOMGraphicMenu(OMGraphic omg) {
        String rightClickTest = (String)omg.getAttribute(this.RCT);
        logger.info("right click test: " + rightClickTest);
        ArrayList<Component> l = new ArrayList<Component>();
        l.add(new JMenuItem("Which"));
        l.add(new JMenuItem("Why"));
        l.add(new JSeparator());
        l.add(new JMenuItem(rightClickTest));
        return l;
    }
}

