/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.MenuBar;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class MenuList
extends OMComponent {
    public static final String MenusProperty = "menus";
    public static final String MenuNameProperty = "name";
    protected List<JMenu> menuList = new ArrayList<JMenu>();
    protected String name = "Map";

    public JMenuBar getMenuBar() {
        MenuBar menuBar = new MenuBar();
        for (JMenu menuu : this.menuList) {
            menuBar.add(menuu);
        }
        return menuBar;
    }

    public JMenu getMenu() {
        JMenu menu = new JMenu(this.name);
        for (JMenu menuu : this.menuList) {
            menu.add(menuu);
        }
        return menu;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.name = props.getProperty(prefix + MenuNameProperty, this.name);
        Vector<String> menuItems = PropUtils.parseSpacedMarkers(props.getProperty(realPrefix + MenusProperty));
        if (!menuItems.isEmpty()) {
            for (String itemPrefix : menuItems) {
                String classProperty = itemPrefix + ".class";
                String className = props.getProperty(classProperty);
                if (className == null) {
                    Debug.error("MenuList.setProperties(): Failed to locate property \"" + classProperty + "\"\n  Skipping menu \"" + itemPrefix + "\"");
                    continue;
                }
                Object obj = ComponentFactory.create(className, itemPrefix, props);
                if (!(obj instanceof JMenu)) continue;
                this.menuList.add((JMenu)obj);
            }
        } else if (Debug.debugging("menu")) {
            Debug.output("MenuList created without menus in properties");
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        StringBuffer itemList = new StringBuffer();
        for (JMenu menu : this.menuList) {
            if (!(menu instanceof PropertyConsumer)) continue;
            PropertyConsumer ps = (PropertyConsumer)((Object)menu);
            String prefix = ps.getPropertyPrefix();
            if (prefix == null) {
                prefix = menu.getText().toLowerCase();
                ps.setPropertyPrefix(prefix);
            }
            itemList.append(prefix).append(" ");
            ps.getProperties(props);
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + MenusProperty, itemList.toString().trim());
        props.put(prefix + MenuNameProperty, PropUtils.unnull(this.name));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, MenuList.class, MenusProperty, "List of Menus", "List of marker names for menu component properties.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, MenuList.class, MenuNameProperty, "Name", "Name of the Menu provided by the MenuList.", null);
        return props;
    }

    public void setBeanContext(BeanContext bc) throws PropertyVetoException {
        super.setBeanContext(bc);
        if (bc != null) {
            for (JMenu menu : this.menuList) {
                bc.add(menu);
            }
        }
    }

    public void findAndInit(Object obj) {
        if (obj instanceof JMenu) {
            this.menuList.add((JMenu)obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof JMenu) {
            this.menuList.remove((JMenu)obj);
        }
    }

    public void add(JMenu menu) {
        this.menuList.add(menu);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

