/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.menu.MapHandlerMenuItem;
import com.bbn.openmap.util.Debug;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class LoadPropertiesMenuItem
extends MapHandlerMenuItem
implements ActionListener {
    public LoadPropertiesMenuItem() {
        super("Load Map Properties");
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.mapHandler == null) {
            return;
        }
        PropertyHandler ph = null;
        for (Object someObj : this.mapHandler) {
            if (!(someObj instanceof PropertyHandler)) continue;
            ph = (PropertyHandler)someObj;
            break;
        }
        if (ph == null) {
            Debug.error("Couldn't find PropertyHandler");
            return;
        }
        FileDialog fd = new FileDialog(new Frame(), "Loading the map from a Properties file...", 0);
        fd.setVisible(true);
        String fileName = fd.getFile();
        String dirName = fd.getDirectory();
        if (fileName == null) {
            Debug.message("loadpropertiesmenuitem", "User did not select any file");
            return;
        }
        Debug.message("loadpropertiesmenuitem", "User selected file " + dirName + File.separator + fileName);
        File file = new File(new File(dirName), fileName);
        try {
            Properties newProps = new Properties();
            FileInputStream fis = new FileInputStream(file);
            newProps.load(fis);
            String test = newProps.getProperty("openmap.layers");
            if (test == null) {
                throw new IOException("Doesn't seem like a valid properties file");
            }
            ph.loadProjectionAndLayers(this.mapHandler, newProps);
        }
        catch (FileNotFoundException fnfe) {
            Debug.error(fnfe.getMessage());
        }
        catch (IOException ioe) {
            InformationDelegator id = (InformationDelegator)this.mapHandler.get("com.bbn.openmap.InformationDelegator");
            if (id != null) {
                id.displayMessage("Error loading file...", "Error occurred loading " + file.getAbsolutePath() + "\n" + ioe.getMessage());
            }
            Debug.error("Error occurred loading " + file.getAbsolutePath());
        }
    }
}

