/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.event.OMEventComparator;
import com.bbn.openmap.event.OMEventHandler;
import com.bbn.openmap.event.OMEventSelectionCoordinator;
import com.bbn.openmap.event.OMEventSelectionListener;
import com.bbn.openmap.gui.event.AbstractEventPresenter;
import com.bbn.openmap.gui.event.EventListCellRenderer;
import com.bbn.openmap.gui.event.EventPanel;
import com.bbn.openmap.gui.event.EventPresenter;
import com.bbn.openmap.gui.event.FilterPresenter;
import com.bbn.openmap.gui.time.TimePanel;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.time.Clock;
import com.bbn.openmap.time.TimeBoundsEvent;
import com.bbn.openmap.time.TimeBoundsListener;
import com.bbn.openmap.time.TimeEvent;
import com.bbn.openmap.time.TimeEventListener;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListPresenter
extends AbstractEventPresenter
implements EventPresenter,
ListSelectionListener,
PropertyChangeListener,
MouseListener,
MouseMotionListener,
TimeBoundsListener,
TimeEventListener {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.event.EventListPresenter");
    protected LinkedList<OMEventHandler> eventHandlers;
    protected LinkedList macroFilters;
    protected EventPanel parentPanel;
    protected JList displayList;
    protected Clock clock = null;
    protected MapBean map = null;
    protected List activeFilters;
    protected Hashtable filters = new Hashtable();
    protected JPanel filterPanel;
    protected long displayTimeWindow = 1000L;
    protected int prefWidth = 200;
    protected int prefHeight = 0;
    protected JLabel detailSpace;
    protected JPanel detailSpacePanel;
    protected TreeSet<OMEvent> activeEvents;
    protected TreeSet<OMEvent> allEvents;
    protected OMEventSelectionCoordinator aesc;
    protected EventListCellRenderer cellRenderer;
    public static final String DisplayIntervalProperty = "displayInterval";
    public static final String CellRendererClassProperty = "cellRendererClass";
    public static final String PreferredWidthProperty = "width";
    public static final String PreferredHeightProperty = "height";
    protected DrawingAttributes drawingAttributes = new DrawingAttributes();
    private OMEvent lastSelectedEvent;
    protected ToolTipManager ttmanager;
    protected long currentTime;
    protected int lastIndexOfCellDetail = -1;
    JPanel eventControlPanel = null;

    public EventListPresenter() {
        this.setIsolated(true);
        this.eventHandlers = new LinkedList();
        this.macroFilters = new LinkedList();
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String crc = props.getProperty(prefix + CellRendererClassProperty);
        if (crc != null) {
            this.setEventCellRenderer((EventListCellRenderer)ComponentFactory.create(crc, prefix, props));
        }
        this.displayTimeWindow = PropUtils.longFromProperties(props, prefix + DisplayIntervalProperty, this.displayTimeWindow);
        this.prefWidth = PropUtils.intFromProperties(props, prefix + PreferredWidthProperty, this.prefWidth);
        this.prefHeight = PropUtils.intFromProperties(props, prefix + PreferredHeightProperty, this.prefHeight);
    }

    @Override
    public DrawingAttributes getSelectionDrawingAttributes() {
        return this.drawingAttributes;
    }

    public void addEventHandler(OMEventHandler aeh) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("adding " + aeh.getClass().getName());
        }
        this.eventHandlers.add(aeh);
        this.retrieveFiltersFromEventHandlers();
        this.updateInterface(false);
    }

    public void removeEventHandler(OMEventHandler aeh) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("removing " + aeh.getClass().getName());
        }
        this.eventHandlers.remove(aeh);
        this.retrieveFiltersFromEventHandlers();
        this.updateInterface();
    }

    public void clearEventHandlers() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("clearing event handlers");
        }
        this.eventHandlers.clear();
        this.retrieveFiltersFromEventHandlers();
        this.updateInterface(false);
    }

    public void rebuildEventList() {
        this.rebuildEventList(true);
    }

    public void rebuildEventList(boolean resetSelected) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("rebuilding list");
        }
        this.allEvents = null;
        this.activeEvents = null;
        this.hideDetails();
        this.initInterface(this.getActiveEvents(), resetSelected);
        this.highlightCurrentEvent(this.currentTime);
        this.firePropertyChange("activeEvents", null, this.getActiveEvents());
    }

    @Override
    public synchronized Iterator<OMEvent> getAllEvents() {
        if (this.allEvents == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("fetching all events from event handlers");
            }
            this.allEvents = new TreeSet<OMEvent>(new OMEventComparator());
            Iterator it = this.eventHandlers.iterator();
            while (it.hasNext()) {
                List<OMEvent> eventList = ((OMEventHandler)it.next()).getEventList();
                if (eventList == null) continue;
                try {
                    this.allEvents.addAll(eventList);
                }
                catch (NullPointerException npe) {
                    return this.getAllEvents();
                }
            }
        }
        return this.allEvents.iterator();
    }

    public boolean isEventActive(OMEvent OMe) {
        if (this.activeEvents != null) {
            Iterator<OMEvent> it = this.getActiveEvents();
            while (it.hasNext()) {
                if (it.next() != OMe) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized Iterator<OMEvent> getActiveEvents() {
        if (this.activeEvents == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("building list of active events");
            }
            this.activeEvents = new TreeSet<OMEvent>(new OMEventComparator());
            List activeFilters = this.getActiveFilters();
            for (OMEventHandler aeh : this.eventHandlers) {
                List<OMEvent> eventList;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("getting filtered list from (" + aeh.getClass().getName() + ")");
                }
                if ((eventList = aeh.getEventList(activeFilters)) == null) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("list from " + aeh.getClass().getName() + "has (" + eventList.size() + ") events");
                }
                Iterator<OMEvent> it2 = eventList.iterator();
                while (it2.hasNext()) {
                    OMEvent me;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("adding OM event");
                    }
                    if ((me = it2.next()) != null) {
                        this.activeEvents.add(me);
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("The " + aeh.getClass().getName() + " is providing null events.");
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("--------");
                for (OMEvent eve : this.activeEvents) {
                    logger.finer(eve.getTimeStamp() + " " + eve);
                }
                logger.finer("--------");
            }
        }
        return this.activeEvents.iterator();
    }

    protected synchronized void initInterface(Iterator<OMEvent> it, boolean setSelected) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("initing interface");
        }
        DefaultListModel<OMEvent> listModel = new DefaultListModel<OMEvent>();
        int selectedIndex = -1;
        int curIndex = 0;
        while (it.hasNext()) {
            OMEvent curEvent = it.next();
            listModel.addElement(curEvent);
            if (this.lastSelectedEvent == curEvent && this.lastSelectedEvent != null) {
                selectedIndex = curIndex;
            }
            ++curIndex;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("added " + curIndex + " events to list");
        }
        if (this.displayList == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating gui components");
            }
            JPanel wrapper = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            wrapper.setLayout(gridbag);
            c.fill = 1;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 2, 0, 2);
            if (this.ttmanager == null) {
                this.ttmanager = ToolTipManager.sharedInstance();
                this.ttmanager.setEnabled(true);
                this.ttmanager.setInitialDelay(1);
            } else if (this.displayList != null) {
                this.ttmanager.unregisterComponent(this.displayList);
            }
            this.displayList = new JList(listModel);
            this.displayList.setSelectionMode(2);
            this.displayList.addListSelectionListener(this);
            this.displayList.addMouseListener(this);
            this.displayList.addMouseMotionListener(this);
            this.displayList.setCellRenderer(this.getEventCellRenderer());
            this.ttmanager.registerComponent(this.displayList);
            JScrollPane listScrollPane = new JScrollPane(this.displayList);
            listScrollPane.setPreferredSize(new Dimension(this.prefWidth, this.prefHeight));
            listScrollPane.setHorizontalScrollBarPolicy(31);
            listScrollPane.setVerticalScrollBarPolicy(20);
            gridbag.setConstraints(listScrollPane, c);
            wrapper.add(listScrollPane);
            c.fill = 2;
            c.weighty = 0.0;
            this.detailSpace = new JLabel("");
            this.detailSpacePanel = new JPanel(new BorderLayout());
            this.detailSpacePanel.setBackground(new Color(0xFFFFCC));
            this.detailSpacePanel.setVisible(false);
            this.detailSpacePanel.add((Component)this.detailSpace, "Center");
            gridbag.setConstraints(this.detailSpacePanel, c);
            wrapper.add(this.detailSpacePanel);
            JComponent ecp = this.getEventControlPanel();
            gridbag.setConstraints(ecp, c);
            wrapper.add(ecp);
            this.add((Component)wrapper, "Center");
            this.validate();
            this.repaint();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done creating gui components");
            }
        } else {
            this.setListModel(listModel);
            this.displayList.revalidate();
            this.displayList.repaint();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("done initing");
        }
        if (selectedIndex >= 0 && setSelected) {
            this.displayList.setSelectedIndex(selectedIndex);
        } else {
            this.lastSelectedEvent = null;
        }
    }

    public ListCellRenderer getEventCellRenderer() {
        if (this.cellRenderer == null) {
            this.setEventCellRenderer(new EventListCellRenderer());
        }
        return this.cellRenderer;
    }

    public void setEventCellRenderer(EventListCellRenderer lcr) {
        this.cellRenderer = lcr;
        if (this.cellRenderer != null) {
            this.drawingAttributes = this.cellRenderer.setRenderingAttributes(this.drawingAttributes);
        }
    }

    protected void addFilter(String string, Boolean value) {
        this.filters.put(string, value);
    }

    protected void clearFilters() {
        this.filters.clear();
    }

    @Override
    public JPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = new JPanel();
        }
        return this.filterPanel;
    }

    protected void rebuildFilterInterface() {
        JPanel filterSubPanel;
        GridBagConstraints c1;
        GridBagLayout gb1;
        JPanel filterPanel;
        block5: {
            filterPanel = this.getFilterPanel();
            filterPanel.removeAll();
            gb1 = new GridBagLayout();
            c1 = new GridBagConstraints();
            filterPanel.setLayout(gb1);
            c1.insets = new Insets(10, 10, 10, 10);
            c1.gridwidth = 0;
            c1.fill = 3;
            c1.weighty = 0.33;
            filterSubPanel = new JPanel();
            GridBagLayout gb2 = new GridBagLayout();
            GridBagConstraints c2 = new GridBagConstraints();
            filterSubPanel.setLayout(gb2);
            c2.anchor = 17;
            c2.gridwidth = 0;
            try {
                Set keys = this.filters.keySet();
                for (String title : keys) {
                    JCheckBox jcb = new JCheckBox(title, (boolean)((Boolean)this.filters.get(title)));
                    jcb.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            JCheckBox jcb = (JCheckBox)ae.getSource();
                            String title = jcb.getText();
                            EventListPresenter.this.setFilterValue(title, jcb.isSelected());
                            EventListPresenter.this.rebuildEventList();
                        }
                    });
                    gb2.setConstraints(jcb, c2);
                    filterSubPanel.add(jcb);
                }
            }
            catch (ConcurrentModificationException cme) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ConcurrentModificationException caught while rebuilding the event list");
                }
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.fine("ArrayIndexOutOfBoundsException caught while rebuilding the event list: " + aioobe.getMessage());
            }
        }
        gb1.setConstraints(filterSubPanel, c1);
        filterPanel.add(filterSubPanel);
        JButton allFiltersOnButton = new JButton(" Show All Events ");
        allFiltersOnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EventListPresenter.this.resetFilters(Boolean.TRUE);
            }
        });
        JButton allFiltersOffButton = new JButton(" Hide All Events ");
        allFiltersOffButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EventListPresenter.this.resetFilters(Boolean.FALSE);
            }
        });
        JPanel resetButtonPanel = new JPanel();
        GridBagLayout gb3 = new GridBagLayout();
        GridBagConstraints c3 = new GridBagConstraints();
        resetButtonPanel.setLayout(gb3);
        gb3.setConstraints(allFiltersOnButton, c3);
        gb3.setConstraints(allFiltersOffButton, c3);
        resetButtonPanel.add(allFiltersOnButton);
        resetButtonPanel.add(allFiltersOffButton);
        c1.fill = 1;
        c1.weighty = 0.66;
        c1.weightx = 1.0;
        c1.anchor = 10;
        gb1.setConstraints(resetButtonPanel, c1);
        filterPanel.add(resetButtonPanel);
        filterPanel.revalidate();
    }

    protected void setFilterValue(String title, boolean b) {
        this.setFilterValue(title, b ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void setFilterValue(String title, Boolean val) {
        this.filters.put(title, val);
        for (OMEventHandler eh : this.eventHandlers) {
            eh.setFilterState(title, val);
        }
        this.activeFilters = null;
    }

    public void resetFilters() {
        this.resetFilters(Boolean.TRUE);
    }

    @Override
    public void resetFilters(Boolean enabled) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("enabled = " + enabled);
        }
        Set keys = this.filters.keySet();
        for (String title : keys) {
            this.setFilterValue(title, enabled);
        }
        this.updateInterface();
    }

    public void updateInterface() {
        this.updateInterface(true);
    }

    public void updateInterface(boolean resetSelected) {
        this.activeFilters = null;
        this.rebuildFilterInterface();
        this.rebuildEventList(resetSelected);
        if (this.parentPanel != null) {
            this.parentPanel.initInterface();
        }
    }

    @Override
    public Hashtable getFilters() {
        return this.filters;
    }

    @Override
    public List getActiveFilters() {
        if (this.activeFilters == null) {
            this.activeFilters = new LinkedList();
            Set filterNames = this.filters.keySet();
            for (String filterName : filterNames) {
                if (this.filters.get(filterName) != Boolean.TRUE) continue;
                this.activeFilters.add(filterName);
            }
        }
        return this.activeFilters;
    }

    public void retrieveFiltersFromEventHandlers() {
        this.clearFilters();
        for (OMEventHandler meh : this.eventHandlers) {
            List filters;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Checking out OM event handler " + meh.getClass().getName());
            }
            if ((filters = meh.getFilters()) == null || filters.isEmpty()) continue;
            for (Object filterObj : filters) {
                if (!(filterObj instanceof String)) continue;
                Boolean val = meh.getFilterState((String)filterObj);
                this.addFilter((String)filterObj, val != null ? val : Boolean.FALSE);
            }
        }
        this.rebuildFilterInterface();
    }

    public void clearSelection() {
        if (this.displayList != null) {
            this.displayList.clearSelection();
        }
    }

    protected synchronized void setListModel(ListModel lm) {
        this.displayList.setModel(lm);
    }

    protected synchronized ListModel getListModel() {
        return this.displayList.getModel();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] indicies;
        if (!e.getValueIsAdjusting() && this.displayList != null && (indicies = this.displayList.getSelectedIndices()).length > 0) {
            OMEvent selectedEvent;
            ListModel listModel = this.getListModel();
            this.lastSelectedEvent = selectedEvent = (OMEvent)listModel.getElementAt(indicies[0]);
            if (selectedEvent != null) {
                String details;
                if (this.clock != null) {
                    this.clock.setTime(selectedEvent.getTimeStamp());
                    Point2D location = selectedEvent.getLocation();
                    if (location != null && this.map != null) {
                        this.map.setCenter(location);
                    }
                }
                if ((details = selectedEvent.getDetailedInformation()) != null) {
                    this.showDetails(details);
                } else {
                    this.hideDetails();
                }
            }
            Iterator<OMEvent> it = this.getAllEvents();
            while (it.hasNext()) {
                it.next().putAttribute("SELECTED", null);
            }
            Vector<OMEvent> v = new Vector<OMEvent>();
            OMEvent firstInRangeEvent = null;
            OMEvent lastSelectedEvent = null;
            int lastIndex = -2;
            boolean inRange = false;
            for (int i = 0; i < indicies.length; ++i) {
                int curIndex = indicies[i];
                selectedEvent = (OMEvent)listModel.getElementAt(curIndex);
                selectedEvent.putAttribute("SELECTED", "SELECTED");
                if (curIndex == lastIndex + 1) {
                    inRange = true;
                    if (firstInRangeEvent == null) {
                        firstInRangeEvent = lastSelectedEvent;
                        firstInRangeEvent.putAttribute("SELECTED", "AVSSR");
                    }
                } else if (inRange && lastSelectedEvent != null) {
                    lastSelectedEvent.putAttribute("SELECTED", "AVSER");
                    inRange = false;
                }
                v.add(selectedEvent);
                Object src = selectedEvent.getSource();
                if (src instanceof OMEventSelectionListener) {
                    ((OMEventSelectionListener)src).selected(selectedEvent);
                }
                lastSelectedEvent = selectedEvent;
                lastIndex = curIndex;
            }
            if (inRange && lastSelectedEvent != null) {
                lastSelectedEvent.putAttribute("SELECTED", "AVSER");
            }
            if (this.aesc != null) {
                this.aesc.eventsSelected(v);
            }
        }
    }

    public boolean selectEvent(OMEvent event) {
        boolean ret = false;
        if (this.displayList != null) {
            this.displayList.setSelectedValue(event, true);
            String details = event.getDetailedInformation();
            if (details != null) {
                this.showDetails(details);
            } else {
                this.hideDetails();
            }
            ret = true;
        }
        return ret;
    }

    @Override
    public void findAndInit(Object someObj) {
        ListCellRenderer lcr;
        if (someObj instanceof OMEventHandler) {
            this.addEventHandler((OMEventHandler)someObj);
        }
        if (someObj instanceof Clock) {
            this.setClock((Clock)someObj);
        }
        if (someObj instanceof MapBean) {
            this.setMap((MapBean)someObj);
        }
        if (someObj instanceof FilterPresenter && someObj != this) {
            this.macroFilters.add(someObj);
            ((FilterPresenter)someObj).addPropertyChangeListener(this);
        }
        if (someObj instanceof EventPanel) {
            this.parentPanel = (EventPanel)someObj;
        }
        if (someObj instanceof OMEventSelectionCoordinator && this.aesc == null) {
            this.aesc = (OMEventSelectionCoordinator)someObj;
            this.aesc.addPropertyChangeListener(this);
        }
        if (someObj instanceof TimePanel && (lcr = this.getEventCellRenderer()) instanceof EventListCellRenderer) {
            EventListCellRenderer elcr = (EventListCellRenderer)lcr;
            ((TimePanel)someObj).setPlayFilterVisible(elcr.getIconPackage().isShowPlayFilter());
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof OMEventHandler) {
            this.removeEventHandler((OMEventHandler)someObj);
        }
        if (someObj == this.getClock()) {
            this.setClock(null);
        }
        if (someObj instanceof MapBean) {
            this.setMap(null);
        }
        if (someObj instanceof FilterPresenter && someObj != this) {
            this.macroFilters.remove(someObj);
            ((FilterPresenter)someObj).removePropertyChangeListener(this);
        }
        if (someObj == this.parentPanel) {
            this.parentPanel = null;
        }
        if (someObj == this.aesc) {
            this.aesc.removePropertyChangeListener(this);
            this.aesc = null;
        }
    }

    public void setClock(Clock cl) {
        if (this.clock != null) {
            this.clock.removeTimeEventListener(this);
            this.clock.removeTimeBoundsListener(this);
        }
        this.clock = cl;
        if (this.clock != null) {
            this.clock.addTimeEventListener(this);
            this.clock.addTimeBoundsListener(this);
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setMap(MapBean map) {
        this.map = map;
    }

    public MapBean getMap() {
        return this.map;
    }

    public long getDisplayTimeWindow() {
        return this.displayTimeWindow;
    }

    public void setDisplayTimeWindow(long displayTimeWindow) {
        this.displayTimeWindow = displayTimeWindow;
    }

    @Override
    public void updateTimeBounds(TimeBoundsEvent tbe) {
        this.allEvents = null;
        if (this.displayList != null) {
            this.displayList.repaint();
        }
        this.lastSelectedEvent = null;
        this.rebuildEventList();
        this.firePropertyChange("eventAttributesUpdated", null, Boolean.TRUE);
    }

    @Override
    public void updateTime(TimeEvent te) {
        this.highlightCurrentEvent(te.getSystemTime());
        if (this.displayList != null) {
            this.displayList.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String eventPropertyName = evt.getPropertyName();
        if (eventPropertyName == "FILTER_STATE") {
            boolean rebuildFilters = (Boolean)evt.getNewValue();
            if (rebuildFilters) {
                logger.fine(eventPropertyName + " rebuilding filters and updating interface (list rebuild to follow)");
                this.retrieveFiltersFromEventHandlers();
                this.updateInterface();
            } else {
                logger.fine(eventPropertyName + " clearing active filters and rebuilding list");
                this.activeFilters = null;
                this.rebuildEventList();
            }
        }
        if (eventPropertyName == "eventsSelected") {
            this.scrollToSelected((List)evt.getNewValue());
            this.displayList.repaint();
        }
    }

    protected void scrollToSelected(List<OMEvent> selectedEvents) {
        if (selectedEvents != null && !selectedEvents.isEmpty()) {
            OMEvent event;
            this.lastSelectedEvent = event = selectedEvents.get(0);
            long timeStamp = event.getTimeStamp();
            OMEvent dlmEvent = null;
            ListModel dlm = this.getListModel();
            int fvi = this.displayList.getFirstVisibleIndex();
            int lvi = this.displayList.getLastVisibleIndex();
            int numRowsVisible = lvi - fvi;
            int size = dlm.getSize();
            for (int i = 0; i < size; ++i) {
                Rectangle rect;
                dlmEvent = (OMEvent)dlm.getElementAt(i);
                if (dlmEvent != event && dlmEvent.getTimeStamp() <= timeStamp) continue;
                if (i >= fvi && i <= lvi - 1 || (rect = this.displayList.getCellBounds(fvi = i, lvi = size - i > numRowsVisible ? i + numRowsVisible - 1 : size)) == null) break;
                this.displayList.scrollRectToVisible(rect);
                break;
            }
        }
    }

    protected synchronized void highlightCurrentEvent(long newCurrentTime) {
        this.currentTime = newCurrentTime;
        if (this.displayList == null) {
            return;
        }
        ListModel dlm = this.displayList.getModel();
        boolean timeMarked = false;
        OMEvent lastClosest = null;
        int size = dlm.getSize();
        for (int i = 0; i < size; ++i) {
            OMEvent event = (OMEvent)dlm.getElementAt(i);
            long timeStamp = event.getTimeStamp();
            boolean atCurrentTime = Math.abs(timeStamp - this.currentTime) <= this.displayTimeWindow;
            event.setAtCurrentTime(atCurrentTime);
            boolean bl = timeMarked = atCurrentTime || timeMarked;
            if (timeMarked) continue;
            if (timeStamp < this.currentTime) {
                lastClosest = event;
                continue;
            }
            if (lastClosest == null) continue;
            lastClosest.setAtCurrentTime(true);
            timeMarked = true;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void showDetails(String contents) {
        if (contents != null) {
            this.detailSpace.setText("<html><body bgcolor=\"#ffffcc\"> <font style=\"plain\">" + contents + "</html>");
        }
        this.detailSpacePanel.setVisible(contents != null);
    }

    public void hideDetails() {
        if (this.detailSpacePanel != null) {
            this.detailSpacePanel.setVisible(false);
        }
        this.lastIndexOfCellDetail = -1;
    }

    protected int getDisplayListIndex(MouseEvent e) {
        int index = 0;
        if (this.displayList != null) {
            double height = this.getDisplayListCellHeight();
            index = e.getY() / (int)height;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("For " + e.getY() + ", the first vis: " + this.displayList.getFirstVisibleIndex() + ", heights are " + height + ", so index of click is " + index);
            }
        }
        return index;
    }

    protected double getDisplayListCellHeight() {
        double height = 0.0;
        if (this.displayList != null) {
            int rlFVI = this.displayList.getFirstVisibleIndex();
            Rectangle bounds = this.displayList.getCellBounds(rlFVI, rlFVI);
            height = bounds.getHeight();
        }
        return height;
    }

    protected JComponent getEventControlPanel() {
        if (this.eventControlPanel == null) {
            this.eventControlPanel = this.cellRenderer.getIconPackage().createEventControlPanel(this);
        }
        JToolBar jsp = new JToolBar();
        jsp.add(this.eventControlPanel);
        jsp.setFloatable(false);
        jsp.setBorder(BorderFactory.createEmptyBorder());
        return jsp;
    }

    public void setSelectedEventsAttribute(Object key, Object value) {
        Iterator<OMEvent> it = this.getActiveEvents();
        while (it.hasNext()) {
            OMEvent OMe = it.next();
            if (OMe.getAttribute("SELECTED") == null) continue;
            OMe.putAttribute(key, value);
        }
        this.resolveSelectionForHiddenEvents(key, value);
        this.firePropertyChange("eventAttributesUpdated", null, Boolean.TRUE);
        this.displayList.repaint();
    }

    public void resolveSelectionForHiddenEvents(Object key, Object value) {
        boolean inRange = false;
        Iterator<OMEvent> iIt = this.getAllEvents();
        while (iIt.hasNext()) {
            OMEvent iEvent = iIt.next();
            if (iEvent.getAttribute("SELECTED") == "AVSSR") {
                inRange = true;
                continue;
            }
            if (iEvent.getAttribute("SELECTED") == "AVSER") {
                inRange = false;
                continue;
            }
            if (!inRange) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("setting " + iEvent.getClass().getName() + " " + key + ", " + value);
            }
            iEvent.putAttribute(key, value);
        }
    }

    public void setAllEventsAttribute(Object key, Object value) {
        Iterator<OMEvent> it = this.getActiveEvents();
        while (it.hasNext()) {
            it.next().putAttribute(key, value);
        }
        this.displayList.repaint();
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("EventListPresenter");
        EventListPresenter elp = new EventListPresenter();
        frame.add(elp);
        frame.pack();
        frame.setVisible(true);
    }
}

