/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.propertyEditor.Inspector;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerAddPanel
extends OMComponentPanel
implements Serializable,
ActionListener {
    public static final String layerTypes = "addableLayers";
    protected PropertyHandler propertyHandler = null;
    protected LayerHandler layerHandler = null;
    protected JComboBox list = null;
    protected JTextField classTextField = null;
    protected JTextField prefixTextField = null;
    protected final String configureActionCommand = "configureActionCommand";
    protected Hashtable<String, String> layerClasses = null;
    protected Inspector inspector = null;
    protected Object layer;
    protected JButton configureButton;
    public static final String DefaultLayerName = "Layer Name";

    public LayerAddPanel() {
        if (Debug.debugging("addable")) {
            Debug.output("LayerAddPanel()");
        }
        this.inspector = new Inspector();
        this.inspector.addActionListener(this);
    }

    public LayerAddPanel(PropertyHandler p, LayerHandler l) {
        this();
        this.propertyHandler = p;
        this.layerHandler = l;
    }

    public void createLayerClasses(Layer[] layers) {
        this.getLayerClasses().clear();
        for (Layer l : layers) {
            int lastDotIndex;
            String name = l.getName();
            if (name == null && (lastDotIndex = (name = l.getClass().getName()).lastIndexOf(46)) >= 0) {
                name = name.substring(lastDotIndex);
            }
            this.addLayer(name, l.getClass().getName());
        }
    }

    public void createPanel(Layer[] layers) {
        this.createLayerClasses(layers);
        this.createPanel();
    }

    public void createPanel() {
        this.removeAll();
        this.configureButton = new JButton(this.i18n.get(LayerAddPanel.class, "configureButton", "Configure"));
        this.configureButton.addActionListener(this);
        this.configureButton.setActionCommand("configureActionCommand");
        String defaultLayerName = this.i18n.get(LayerAddPanel.class, "defaultLayerName", DefaultLayerName);
        this.prefixTextField = new JTextField(defaultLayerName, 12);
        Set<String> keys = this.getLayerClasses().keySet();
        String[] layerTypes = keys.toArray(new String[keys.size()]);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 10, 5, 10);
        if (layerTypes.length == 0) {
            this.configureButton.setEnabled(false);
            this.classTextField = new JTextField(30);
            this.classTextField.setToolTipText(this.i18n.get(LayerAddPanel.class, "classFieldToolTip", "Class name of layer to add"));
            this.classTextField.setInputVerifier(new InputVerifier(){

                public boolean verify(JComponent input) {
                    JTextField tf = (JTextField)input;
                    String className = tf.getText();
                    try {
                        ClassLoader.getSystemClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        LayerAddPanel.this.configureButton.setEnabled(false);
                        return false;
                    }
                    LayerAddPanel.this.configureButton.setEnabled(true);
                    return true;
                }
            });
            gridbag.setConstraints(this.classTextField, c);
            this.add(this.classTextField);
            this.configureButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String newClassName = LayerAddPanel.this.classTextField.getText();
                    String prefix = LayerAddPanel.this.prefixTextField.getText().trim();
                    LayerAddPanel.this.createLayer(newClassName, prefix);
                }
            });
        } else {
            this.list = new JComboBox<String>(layerTypes);
            gridbag.setConstraints(this.list, c);
            this.add(this.list);
            this.configureButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String prettyName = (String)LayerAddPanel.this.list.getSelectedItem();
                    String prefix = LayerAddPanel.this.prefixTextField.getText().trim();
                    if (prettyName == null) {
                        return;
                    }
                    String newClassName = LayerAddPanel.this.layerClasses.get(prettyName);
                    LayerAddPanel.this.createLayer(newClassName, prefix);
                }
            });
        }
        c.insets = new Insets(5, 10, 10, 10);
        c.gridwidth = -1;
        gridbag.setConstraints(this.prefixTextField, c);
        this.add(this.prefixTextField);
        c.weightx = 0.0;
        gridbag.setConstraints(this.configureButton, c);
        this.add(this.configureButton);
        this.invalidate();
    }

    public Hashtable<String, String> getLayerClasses() {
        if (this.layerClasses == null) {
            this.layerClasses = new Hashtable();
        }
        return this.layerClasses;
    }

    public void addLayer(String prettyName, String className) {
        this.getLayerClasses().put(prettyName, className);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        if (Debug.debugging("addable")) {
            Debug.output("LayerAddPanel.setProperties()");
        }
        this.getLayerTypes(props);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        int layerNumber = 1;
        if (this.layerClasses != null) {
            StringBuffer layerList = new StringBuffer();
            for (String prettyName : this.layerClasses.keySet()) {
                String className = this.layerClasses.get(prettyName);
                String markerName = "l" + layerNumber++;
                layerList.append(markerName).append(" ");
                props.put(markerName + ".prettyName", prettyName);
                props.put(markerName + ".class", className);
            }
            props.put("openmap.addableLayers", layerList.toString());
        }
        return props;
    }

    protected Hashtable<String, String> getLayerTypes() {
        return this.getLayerTypes(null);
    }

    protected Hashtable<String, String> getLayerTypes(Properties props) {
        Vector<String> layerClassList;
        Hashtable<String, String> layerHash = this.getLayerClasses();
        layerHash.clear();
        if (props == null) {
            if (this.propertyHandler != null) {
                props = this.propertyHandler.getProperties();
            } else {
                return layerHash;
            }
        }
        String prefix = "openmap";
        String addableList = props.getProperty(prefix + "." + layerTypes);
        if (Debug.debugging("addable")) {
            Debug.output("LayerAddPanel: " + addableList);
        }
        if ((layerClassList = PropUtils.parseSpacedMarkers(addableList)) == null) {
            return layerHash;
        }
        int unNamedCount = 1;
        for (String layerClassString : layerClassList) {
            String className = props.getProperty(layerClassString + ".class");
            String prettyName = props.getProperty(layerClassString + ".prettyName");
            if (prettyName == null) {
                prettyName = "Layer " + unNamedCount++;
            }
            if (className == null) continue;
            if (Debug.debugging("addable")) {
                Debug.output("  adding " + className + ", " + className);
            }
            layerHash.put(prettyName, className);
        }
        return layerHash;
    }

    protected void createLayer(String className, String prefix) {
        Object obj = ComponentFactory.create(className);
        if (obj instanceof Layer || obj instanceof PlugIn) {
            WindowSupport ws;
            if (obj instanceof PlugIn) {
                PlugInLayer pil = new PlugInLayer();
                pil.setPlugIn((PlugIn)obj);
                this.layer = pil;
            } else {
                this.layer = (Layer)obj;
            }
            ((Layer)this.layer).setName(prefix);
            this.prefixTextField.setText("");
            if (this.classTextField != null) {
                this.classTextField.setText("");
            }
            if ((ws = this.getWindowSupport()) != null) {
                ws.cleanUp();
            }
        }
        if (obj instanceof PropertyConsumer) {
            prefix = this.propertyHandler.getUniquePrefix(prefix);
            ((PropertyConsumer)obj).setPropertyPrefix(prefix);
            this.inspector.inspectPropertyConsumer((PropertyConsumer)obj);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "doneCommand") {
            if (this.layer != null && this.layerHandler != null) {
                if (this.layer instanceof Layer) {
                    this.layerHandler.addLayer((Layer)this.layer, 0);
                }
                this.prefixTextField.setText(DefaultLayerName);
            } else if (this.layerHandler != null) {
                String message = this.i18n.get(LayerAddPanel.class, "noLayerHandlerMessage", "Layer Handler not found.\nCan't find anything to add the layer to.");
                JOptionPane.showMessageDialog(this, message);
            } else {
                String message = this.i18n.get(LayerAddPanel.class, "noLayerCreatedMessage", "No Layer instantiated.");
                JOptionPane.showMessageDialog(this, message);
            }
        } else if (e.getActionCommand() == "cancelCommand" && this.layer != null && this.propertyHandler != null) {
            this.propertyHandler.removeUsedPrefix(((PropertyConsumer)this.layer).getPropertyPrefix());
        }
    }

    public void showPanel() {
        this.createPanel();
        this.prefixTextField.setText(DefaultLayerName);
        WindowSupport ws = this.getWindowSupport();
        MapHandler mh = (MapHandler)this.getBeanContext();
        Frame frame = null;
        if (mh != null) {
            frame = mh.get(Frame.class);
        }
        if (ws == null) {
            ws = new WindowSupport((Component)this, this.i18n.get(LayerAddPanel.class, "title", "Add Layer"));
            this.setWindowSupport(ws);
        }
        ws.displayInWindow(frame, -1, -1, -1, -1);
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof PropertyHandler) {
            Debug.message("layerspanel", "LayerAddPanel found a LayerHandler");
            this.propertyHandler = (PropertyHandler)someObj;
        }
        if (someObj instanceof LayerHandler) {
            this.layerHandler = (LayerHandler)someObj;
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof PropertyHandler && this.propertyHandler == someObj) {
            Debug.message("addable", "LayerAddPanel removing PropertyHandler");
            this.propertyHandler = null;
        }
        if (someObj instanceof LayerHandler && someObj == this.layerHandler) {
            Debug.message("addable", "LayerAddPanel removing LayerHandler");
            this.layerHandler = null;
        }
    }
}

