/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class EmbeddedScaleDisplayPanel
extends OMComponentPanel
implements ProjectionListener {
    protected String defaultLineColorString = "FFFFFF";
    protected String defaultTextColorString = "FFFFFF";
    protected String defaultUnitOfMeasureString = "km";
    protected int defaultLocationXoffset = -10;
    protected int defaultLocationYoffset = -10;
    protected int defaultWidth = 150;
    protected int defaultHeight = 10;
    public static final String UnitOfMeasureProperty = "unitOfMeasure";
    public static final String LocationXOffsetProperty = "locationXoffset";
    public static final String LocationYOffsetProperty = "locationYoffset";
    public static final String WidthProperty = "width";
    public static final String HeightProperty = "height";
    protected Length uom = Length.get(this.defaultUnitOfMeasureString);
    protected int locationXoffset = this.defaultLocationXoffset;
    protected int locationYoffset = this.defaultLocationYoffset;
    protected int width = this.defaultWidth;
    protected int height = this.defaultHeight;
    protected DrawingAttributes dAttributes = DrawingAttributes.getDefaultClone();
    private static final long serialVersionUID = 1L;
    static final float RADIANS_270 = Length.DECIMAL_DEGREE.toRadians(270.0f);
    protected OMGraphicList legend;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.EmbedddedScaleDisplayPanel");
    JPanel palette;
    Vector<JRadioButton> buttons = new Vector();
    ButtonGroup uomButtonGroup;
    protected MapBean mapBean;

    public EmbeddedScaleDisplayPanel() {
        this.setOpaque(false);
        this.setBackground(OMColor.clear);
        this.setPreferredSize(new Dimension(350, 100));
        this.dAttributes.setMattingPaint(new Color(-3355444));
        this.dAttributes.setMatted(true);
    }

    public EmbeddedScaleDisplayPanel(DrawingAttributes dAtts, Length units) {
        this();
        this.setUnitOfMeasure(units.getAbbr());
        this.dAttributes = dAtts;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.dAttributes.setProperties(prefix, properties);
        String unitOfMeasure = properties.getProperty(prefix + UnitOfMeasureProperty);
        this.setUnitOfMeasure(unitOfMeasure);
        this.locationXoffset = PropUtils.intFromProperties(properties, prefix + LocationXOffsetProperty, this.defaultLocationXoffset);
        this.locationYoffset = PropUtils.intFromProperties(properties, prefix + LocationYOffsetProperty, this.defaultLocationYoffset);
        this.width = PropUtils.intFromProperties(properties, prefix + WidthProperty, this.defaultWidth);
        this.height = PropUtils.intFromProperties(properties, prefix + HeightProperty, this.defaultHeight);
    }

    public String getUnitOfMeasure() {
        return this.uom.toString();
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        if (unitOfMeasure == null) {
            unitOfMeasure = Length.KM.toString();
        }
        Length[] choices = Length.values();
        this.uom = null;
        for (int i = 0; i < choices.length; ++i) {
            if (!unitOfMeasure.equalsIgnoreCase(choices[i].toString()) && !unitOfMeasure.equalsIgnoreCase(choices[i].getAbbr())) continue;
            this.uom = choices[i];
            break;
        }
        if (this.uom == null) {
            this.uom = Length.KM;
        }
    }

    public Component getGUI() {
        if (this.palette == null) {
            logger.fine("creating palette.");
            this.palette = new JPanel();
            this.uomButtonGroup = new ButtonGroup();
            this.palette.setLayout(new BoxLayout(this.palette, 1));
            this.palette.setBorder(new TitledBorder("Unit Of Measure"));
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadioButton jrb = (JRadioButton)e.getSource();
                    EmbeddedScaleDisplayPanel.this.setUnitOfMeasure(jrb.getText());
                }
            };
            for (Length lengthType : Length.values()) {
                JRadioButton jrb = new JRadioButton();
                jrb.setText(lengthType.getAbbr());
                jrb.setToolTipText(lengthType.toString());
                this.uomButtonGroup.add(jrb);
                this.palette.add(jrb);
                jrb.addActionListener(al);
                jrb.setSelected(this.uom.getAbbr().equalsIgnoreCase(lengthType.getAbbr()));
                this.buttons.add(jrb);
            }
        } else {
            for (JRadioButton button : this.buttons) {
                button.setSelected(this.uom.getAbbr().equalsIgnoreCase(button.getText()));
            }
        }
        return this.palette;
    }

    public void projectionChanged(ProjectionEvent e) {
        int left_x = 0;
        int right_x = 0;
        int lower_y = 0;
        int upper_y = 0;
        Projection projection = e.getProjection();
        OMGraphicList graphics = new OMGraphicList();
        int w = projection.getWidth();
        int h = projection.getHeight();
        lower_y = h / 2;
        right_x = w / 2;
        left_x = right_x - this.width;
        LatLonPoint loc1 = projection.inverse(left_x, lower_y, new LatLonPoint.Double());
        LatLonPoint loc2 = projection.inverse(right_x, lower_y, new LatLonPoint.Double());
        double dist = GreatCircle.sphericalDistance(loc1.getRadLat(), loc1.getRadLon(), loc2.getRadLat(), loc2.getRadLon());
        dist = this.uom.fromRadians(dist);
        double new_dist = this.scopeDistance(dist);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("modifying " + dist + " to new distance: " + new_dist);
        }
        left_x = this.getPtAtDistanceFromLatLon(loc2, new_dist, projection, this.uom);
        int lineLength = right_x - left_x;
        int maxWidth = Math.max(this.getWidth() - Math.abs(this.locationXoffset) * 2, 50);
        while (lineLength > maxWidth) {
            double testDist;
            lineLength /= 3;
            new_dist /= 3.0;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("length of line too long, halving to " + lineLength);
            }
            if (MoreMath.approximately_equal(testDist = this.scopeDistance(new_dist), new_dist) || new_dist <= 0.01) continue;
            lineLength = right_x - this.getPtAtDistanceFromLatLon(loc2, testDist, projection, this.uom);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("needed to rescope distance to " + testDist + " from " + new_dist);
            }
            new_dist = testDist;
        }
        Length cur_uom = this.uom;
        if (new_dist < 1.0) {
            double testDist;
            if (this.uom.equals((Object)Length.KM)) {
                new_dist *= 1000.0;
                cur_uom = Length.METER;
            } else if (this.uom.equals((Object)Length.MILE) || this.uom.equals((Object)Length.DM) || this.uom.equals((Object)Length.NM)) {
                new_dist = Length.FEET.fromRadians(this.uom.toRadians(new_dist));
                cur_uom = Length.FEET;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("modified UOM to " + cur_uom.getAbbr() + ", value: " + new_dist);
            }
            if (!MoreMath.approximately_equal(testDist = this.scopeDistance(new_dist), new_dist)) {
                lineLength = right_x - this.getPtAtDistanceFromLatLon(loc2, testDist, projection, cur_uom);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("needed to rescope distance to " + testDist + " from " + new_dist);
                }
                new_dist = testDist;
            }
        }
        if (this.locationXoffset < 0) {
            int cw = this.getWidth();
            left_x = cw + this.locationXoffset - lineLength;
            right_x = cw + this.locationXoffset;
        } else if (this.locationXoffset >= 0) {
            left_x = this.locationXoffset;
            right_x = this.locationXoffset + lineLength;
        }
        if (this.locationYoffset < 0) {
            int ch = this.getHeight();
            upper_y = ch + this.locationYoffset - this.height;
            lower_y = ch + this.locationYoffset;
        } else if (this.locationYoffset >= 0) {
            upper_y = this.locationYoffset;
            lower_y = this.locationYoffset + this.height;
        }
        OMLine line = new OMLine(left_x, lower_y, right_x, lower_y);
        this.dAttributes.setTo(line);
        graphics.add(line);
        line = new OMLine(left_x, lower_y, left_x, upper_y);
        this.dAttributes.setTo(line);
        graphics.add(line);
        line = new OMLine(right_x, lower_y, right_x, upper_y);
        this.dAttributes.setTo(line);
        graphics.add(line);
        String outtext = String.format("%.0f %s", new_dist, cur_uom.getAbbr());
        OMText text = new OMText(right_x, lower_y - 20, "" + outtext, 2);
        Font font = text.getFont();
        text.setFont(font.deriveFont(1, font.getSize() + 4));
        this.dAttributes.setTo(text);
        text.setTextMatteColor((Color)this.dAttributes.getMattingPaint());
        text.setTextMatteStroke(new BasicStroke(5.0f));
        text.setMattingPaint(OMColor.clear);
        graphics.add(text);
        graphics.generate(projection);
        this.setLegend(graphics);
    }

    protected int getPtAtDistanceFromLatLon(LatLonPoint loc2, double unitDist, Projection projection, Length uom) {
        double lineWidthInRadians = uom.toRadians(unitDist);
        LatLonPoint newX = GreatCircle.sphericalBetween(loc2.getRadLat(), loc2.getRadLon(), lineWidthInRadians, RADIANS_270);
        Point2D newLoc1 = projection.forward(newX);
        return (int)Math.round(newLoc1.getX());
    }

    protected double scopeDistance(double dist) {
        double new_dist = dist <= 0.01 ? 0.01 : (dist <= 0.02 ? 0.02 : (dist <= 0.05 ? 0.05 : (dist <= 0.1 ? 0.1 : (dist <= 0.2 ? 0.2 : (dist <= 0.5 ? 0.5 : (dist <= 1.0 ? 1.0 : (dist <= 2.0 ? 2.0 : (dist <= 5.0 ? 5.0 : (dist <= 10.0 ? 10.0 : (dist <= 20.0 ? 20.0 : (dist <= 50.0 ? 50.0 : (dist <= 100.0 ? 100.0 : (dist <= 200.0 ? 200.0 : (dist <= 500.0 ? 500.0 : 1000.0))))))))))))));
        return new_dist;
    }

    public OMGraphicList getLegend() {
        return this.legend;
    }

    public void setLegend(OMGraphicList legend) {
        this.legend = legend;
    }

    public void paint(Graphics g) {
        if (this.legend != null) {
            this.legend.render(g);
        }
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof MapBean) {
            this.mapBean = (MapBean)someObj;
            this.mapBean.addProjectionListener(this);
        }
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (someObj.equals(this.mapBean)) {
            this.mapBean.removeProjectionListener(this);
            this.mapBean = null;
        }
    }
}

